/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import com.itfsw.mybatis.generator.plugins.utils.IntrospectedTableTools;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.config.TableConfiguration;

public class TableRenamePlugin
extends BasePlugin {
    public static final String PRO_SEARCH_STRING = "searchString";
    public static final String PRO_REPLACE_STRING = "replaceString";
    public static final String PRO_TABLE_OVERRIDE = "tableOverride";

    @Override
    public boolean validate(List<String> warnings) {
        if (this.getProperties().getProperty(PRO_SEARCH_STRING) == null && this.getProperties().getProperty(PRO_REPLACE_STRING) != null || this.getProperties().getProperty(PRO_SEARCH_STRING) != null && this.getProperties().getProperty(PRO_REPLACE_STRING) == null) {
            warnings.add("itfsw:\u63d2\u4ef6" + ((Object)((Object)this)).getClass().getTypeName() + "\u63d2\u4ef6\u7684searchString\u3001replaceString\u5c5e\u6027\u9700\u914d\u5408\u4f7f\u7528\uff0c\u4e0d\u80fd\u5355\u72ec\u5b58\u5728\uff01");
            return false;
        }
        for (TableConfiguration tableConfiguration : this.context.getTableConfigurations()) {
            if (tableConfiguration.getDomainObjectName() == null && tableConfiguration.getMapperName() == null) continue;
            warnings.add("itfsw:\u63d2\u4ef6" + ((Object)((Object)this)).getClass().getTypeName() + "\u63d2\u4ef6\u8bf7\u4e0d\u8981\u914d\u5408table\u7684domainObjectName\u6216\u8005mapperName\u4e00\u8d77\u4f7f\u7528\uff01");
            return false;
        }
        return super.validate(warnings);
    }

    public void initialized(IntrospectedTable introspectedTable) {
        if (introspectedTable.getTableConfigurationProperty(PRO_TABLE_OVERRIDE) != null) {
            String override = introspectedTable.getTableConfigurationProperty(PRO_TABLE_OVERRIDE);
            try {
                IntrospectedTableTools.setDomainObjectName(introspectedTable, this.getContext(), override);
            }
            catch (Exception e) {
                logger.error("itfsw:\u63d2\u4ef6" + ((Object)((Object)this)).getClass().getTypeName() + "\u4f7f\u7528tableOverride\u66ff\u6362\u65f6\u5f02\u5e38\uff01", (Throwable)e);
            }
        } else if (this.getProperties().getProperty(PRO_SEARCH_STRING) != null) {
            String searchString = this.getProperties().getProperty(PRO_SEARCH_STRING);
            String replaceString = this.getProperties().getProperty(PRO_REPLACE_STRING);
            String domainObjectName = introspectedTable.getFullyQualifiedTable().getDomainObjectName();
            Pattern pattern = Pattern.compile(searchString);
            Matcher matcher = pattern.matcher(domainObjectName);
            domainObjectName = matcher.replaceAll(replaceString);
            domainObjectName = this.upFirstWord(domainObjectName);
            try {
                IntrospectedTableTools.setDomainObjectName(introspectedTable, this.getContext(), domainObjectName);
            }
            catch (Exception e) {
                logger.error("itfsw:\u63d2\u4ef6" + ((Object)((Object)this)).getClass().getTypeName() + "\u4f7f\u7528searchString\u3001replaceString\u66ff\u6362\u65f6\u5f02\u5e38\uff01", (Throwable)e);
            }
        }
    }

    private String upFirstWord(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }
}

