/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import com.itfsw.mybatis.generator.plugins.utils.IncrementsPluginTools;
import com.itfsw.mybatis.generator.plugins.utils.IntrospectedTableTools;
import com.itfsw.mybatis.generator.plugins.utils.JavaElementGeneratorTools;
import com.itfsw.mybatis.generator.plugins.utils.XmlElementGeneratorTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.internal.util.StringUtility;

public class UpsertPlugin
extends BasePlugin {
    public static final String METHOD_UPSERT = "upsert";
    public static final String METHOD_UPSERT_WITH_BLOBS = "upsertWithBLOBs";
    public static final String METHOD_UPSERT_SELECTIVE = "upsertSelective";
    public static final String METHOD_UPSERT_BY_EXAMPLE = "upsertByExample";
    public static final String METHOD_UPSERT_BY_EXAMPLE_WITH_BLOBS = "upsertByExampleWithBLOBs";
    public static final String METHOD_UPSERT_BY_EXAMPLE_SELECTIVE = "upsertByExampleSelective";
    public static final String PRO_ALLOW_MULTI_QUERIES = "allowMultiQueries";
    private boolean allowMultiQueries = false;

    @Override
    public boolean validate(List<String> warnings) {
        if (!"com.mysql.jdbc.Driver".equalsIgnoreCase(this.getContext().getJdbcConnectionConfiguration().getDriverClass())) {
            warnings.add("itfsw:\u63d2\u4ef6" + ((Object)((Object)this)).getClass().getTypeName() + "\u63d2\u4ef6\u4f7f\u7528\u524d\u63d0\u662f\u6570\u636e\u5e93\u4e3aMySQL\uff01");
            return false;
        }
        Properties properties = this.getProperties();
        String allowMultiQueries = properties.getProperty(PRO_ALLOW_MULTI_QUERIES);
        boolean bl = this.allowMultiQueries = allowMultiQueries == null ? false : StringUtility.isTrue((String)allowMultiQueries);
        if (this.allowMultiQueries) {
            warnings.add("itfsw:\u63d2\u4ef6" + ((Object)((Object)this)).getClass().getTypeName() + "\u63d2\u4ef6\u60a8\u5f00\u542f\u4e86allowMultiQueries\u652f\u6301\uff0c\u6ce8\u610f\u5728jdbc url \u914d\u7f6e\u4e2d\u589e\u52a0\u201callowMultiQueries=true\u201d\u652f\u6301\uff08\u4e0d\u600e\u4e48\u5efa\u8bae\u4f7f\u7528\u8be5\u529f\u80fd\uff0c\u5f00\u542f\u591asql\u63d0\u4ea4\u4f1a\u589e\u52a0sql\u6ce8\u5165\u7684\u98ce\u9669\uff0c\u8bf7\u786e\u4fdd\u4f60\u6240\u6709sql\u90fd\u4f7f\u7528MyBatis\u4e66\u5199\uff0c\u8bf7\u4e0d\u8981\u4f7f\u7528statement\u8fdb\u884csql\u63d0\u4ea4\uff09\uff01");
        }
        return super.validate(warnings);
    }

    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        Method mUpsert = JavaElementGeneratorTools.generateMethod(METHOD_UPSERT, JavaVisibility.DEFAULT, FullyQualifiedJavaType.getIntInstance(), new Parameter(JavaElementGeneratorTools.getModelTypeWithoutBLOBs(introspectedTable), "record"));
        this.commentGenerator.addGeneralMethodComment(mUpsert, introspectedTable);
        interfaze.addMethod(mUpsert);
        logger.debug("itfsw(\u5b58\u5728\u5373\u66f4\u65b0\u63d2\u4ef6):" + interfaze.getType().getShortName() + "\u589e\u52a0upsert\u65b9\u6cd5\u3002");
        if (introspectedTable.hasBLOBColumns()) {
            Method mUpsertWithBLOBs = JavaElementGeneratorTools.generateMethod(METHOD_UPSERT_WITH_BLOBS, JavaVisibility.DEFAULT, FullyQualifiedJavaType.getIntInstance(), new Parameter(JavaElementGeneratorTools.getModelTypeWithBLOBs(introspectedTable), "record"));
            this.commentGenerator.addGeneralMethodComment(mUpsertWithBLOBs, introspectedTable);
            interfaze.addMethod(mUpsertWithBLOBs);
            logger.debug("itfsw(\u5b58\u5728\u5373\u66f4\u65b0\u63d2\u4ef6):" + interfaze.getType().getShortName() + "\u589e\u52a0upsert\u65b9\u6cd5\u3002");
        }
        Method mUpsertSelective = JavaElementGeneratorTools.generateMethod(METHOD_UPSERT_SELECTIVE, JavaVisibility.DEFAULT, FullyQualifiedJavaType.getIntInstance(), new Parameter(introspectedTable.getRules().calculateAllFieldsClass(), "record"));
        this.commentGenerator.addGeneralMethodComment(mUpsertSelective, introspectedTable);
        interfaze.addMethod(mUpsertSelective);
        logger.debug("itfsw(\u5b58\u5728\u5373\u66f4\u65b0\u63d2\u4ef6):" + interfaze.getType().getShortName() + "\u589e\u52a0upsertSelective\u65b9\u6cd5\u3002");
        if (this.allowMultiQueries) {
            Method mUpsertByExample = JavaElementGeneratorTools.generateMethod(METHOD_UPSERT_BY_EXAMPLE, JavaVisibility.DEFAULT, FullyQualifiedJavaType.getIntInstance(), new Parameter(JavaElementGeneratorTools.getModelTypeWithoutBLOBs(introspectedTable), "record", "@Param(\"record\")"), new Parameter(new FullyQualifiedJavaType(introspectedTable.getExampleType()), "example", "@Param(\"example\")"));
            this.commentGenerator.addGeneralMethodComment(mUpsertByExample, introspectedTable);
            interfaze.addMethod(mUpsertByExample);
            logger.debug("itfsw(\u5b58\u5728\u5373\u66f4\u65b0\u63d2\u4ef6):" + interfaze.getType().getShortName() + "\u589e\u52a0upsertByExample\u65b9\u6cd5\u3002");
            if (introspectedTable.hasBLOBColumns()) {
                Method mUpsertByExampleWithBLOBs = JavaElementGeneratorTools.generateMethod(METHOD_UPSERT_BY_EXAMPLE_WITH_BLOBS, JavaVisibility.DEFAULT, FullyQualifiedJavaType.getIntInstance(), new Parameter(JavaElementGeneratorTools.getModelTypeWithBLOBs(introspectedTable), "record", "@Param(\"record\")"), new Parameter(new FullyQualifiedJavaType(introspectedTable.getExampleType()), "example", "@Param(\"example\")"));
                this.commentGenerator.addGeneralMethodComment(mUpsertByExampleWithBLOBs, introspectedTable);
                interfaze.addMethod(mUpsertByExampleWithBLOBs);
                logger.debug("itfsw(\u5b58\u5728\u5373\u66f4\u65b0\u63d2\u4ef6):" + interfaze.getType().getShortName() + "\u589e\u52a0upsertByExample\u65b9\u6cd5\u3002");
            }
            Method mUpsertByExampleSelective = JavaElementGeneratorTools.generateMethod(METHOD_UPSERT_BY_EXAMPLE_SELECTIVE, JavaVisibility.DEFAULT, FullyQualifiedJavaType.getIntInstance(), new Parameter(introspectedTable.getRules().calculateAllFieldsClass(), "record", "@Param(\"record\")"), new Parameter(new FullyQualifiedJavaType(introspectedTable.getExampleType()), "example", "@Param(\"example\")"));
            this.commentGenerator.addGeneralMethodComment(mUpsertByExampleSelective, introspectedTable);
            interfaze.addMethod(mUpsertByExampleSelective);
            logger.debug("itfsw(\u5b58\u5728\u5373\u66f4\u65b0\u63d2\u4ef6):" + interfaze.getType().getShortName() + "\u589e\u52a0upsertByExampleSelective\u65b9\u6cd5\u3002");
        }
        return super.clientGenerated(interfaze, topLevelClass, introspectedTable);
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        this.generateXmlElementWithoutBLOBs(document, introspectedTable);
        this.generateXmlElementWithSelective(document, introspectedTable);
        this.generateXmlElementWithBLOBs(document, introspectedTable);
        return super.sqlMapDocumentGenerated(document, introspectedTable);
    }

    private void generateXmlElementWithSelective(Document document, IntrospectedTable introspectedTable) {
        List columns = ListUtilities.removeGeneratedAlwaysColumns((List)introspectedTable.getAllColumns());
        XmlElement eleUpsertSelective = new XmlElement("insert");
        eleUpsertSelective.addAttribute(new Attribute("id", METHOD_UPSERT_SELECTIVE));
        this.commentGenerator.addComment(eleUpsertSelective);
        eleUpsertSelective.addAttribute(new Attribute("parameterType", introspectedTable.getRules().calculateAllFieldsClass().getFullyQualifiedName()));
        XmlElementGeneratorTools.useGeneratedKeys(eleUpsertSelective, introspectedTable);
        eleUpsertSelective.addElement((Element)new TextElement("insert into " + introspectedTable.getFullyQualifiedTableNameAtRuntime()));
        eleUpsertSelective.addElement(XmlElementGeneratorTools.generateKeysSelective(columns));
        eleUpsertSelective.addElement((Element)new TextElement("values"));
        eleUpsertSelective.addElement(XmlElementGeneratorTools.generateValuesSelective(columns));
        eleUpsertSelective.addElement((Element)new TextElement("on duplicate key update "));
        this.incrementsSelectiveSupport(eleUpsertSelective, XmlElementGeneratorTools.generateSetsSelective(columns, null, false), introspectedTable, false);
        document.getRootElement().addElement((Element)eleUpsertSelective);
        logger.debug("itfsw(\u5b58\u5728\u5373\u66f4\u65b0\u63d2\u4ef6):" + introspectedTable.getMyBatis3XmlMapperFileName() + "\u589e\u52a0upsertSelective\u5b9e\u73b0\u65b9\u6cd5\u3002");
        if (this.allowMultiQueries) {
            XmlElement eleUpsertByExampleSelective = new XmlElement("insert");
            eleUpsertByExampleSelective.addAttribute(new Attribute("id", METHOD_UPSERT_BY_EXAMPLE_SELECTIVE));
            eleUpsertByExampleSelective.addAttribute(new Attribute("parameterType", "map"));
            this.commentGenerator.addComment(eleUpsertByExampleSelective);
            XmlElementGeneratorTools.useGeneratedKeys(eleUpsertByExampleSelective, introspectedTable, "record.");
            eleUpsertByExampleSelective.addElement((Element)new TextElement("insert into " + introspectedTable.getFullyQualifiedTableNameAtRuntime()));
            eleUpsertByExampleSelective.addElement(XmlElementGeneratorTools.generateKeysSelective(columns, "record."));
            this.generateExistsClause(introspectedTable, eleUpsertByExampleSelective, true, columns);
            eleUpsertByExampleSelective.addElement((Element)new TextElement(";"));
            eleUpsertByExampleSelective.addElement((Element)new TextElement("update " + introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime()));
            eleUpsertByExampleSelective.addElement((Element)new TextElement("set"));
            this.incrementsSelectiveSupport(eleUpsertByExampleSelective, XmlElementGeneratorTools.generateSetsSelective(ListUtilities.removeIdentityAndGeneratedAlwaysColumns((List)columns), "record."), introspectedTable, true);
            eleUpsertByExampleSelective.addElement(XmlElementGeneratorTools.getUpdateByExampleIncludeElement(introspectedTable));
            document.getRootElement().addElement((Element)eleUpsertByExampleSelective);
            logger.debug("itfsw(\u5b58\u5728\u5373\u66f4\u65b0\u63d2\u4ef6):" + introspectedTable.getMyBatis3XmlMapperFileName() + "\u589e\u52a0upsertSelective\u5b9e\u73b0\u65b9\u6cd5\u3002");
        }
    }

    private void generateXmlElementWithBLOBs(Document document, IntrospectedTable introspectedTable) {
        if (introspectedTable.hasBLOBColumns()) {
            List columns = ListUtilities.removeGeneratedAlwaysColumns((List)introspectedTable.getAllColumns());
            XmlElement eleUpsertWithBLOBs = new XmlElement("insert");
            eleUpsertWithBLOBs.addAttribute(new Attribute("id", METHOD_UPSERT_WITH_BLOBS));
            this.commentGenerator.addComment(eleUpsertWithBLOBs);
            eleUpsertWithBLOBs.addAttribute(new Attribute("parameterType", JavaElementGeneratorTools.getModelTypeWithBLOBs(introspectedTable).getFullyQualifiedName()));
            XmlElementGeneratorTools.useGeneratedKeys(eleUpsertWithBLOBs, introspectedTable);
            eleUpsertWithBLOBs.addElement((Element)new TextElement("insert into " + introspectedTable.getFullyQualifiedTableNameAtRuntime()));
            for (Element element : XmlElementGeneratorTools.generateKeys(columns)) {
                eleUpsertWithBLOBs.addElement(element);
            }
            eleUpsertWithBLOBs.addElement((Element)new TextElement("values"));
            for (Element element : XmlElementGeneratorTools.generateValues(columns)) {
                eleUpsertWithBLOBs.addElement(element);
            }
            eleUpsertWithBLOBs.addElement((Element)new TextElement("on duplicate key update "));
            this.incrementsSupport(eleUpsertWithBLOBs, XmlElementGeneratorTools.generateSets(columns), introspectedTable, false);
            document.getRootElement().addElement((Element)eleUpsertWithBLOBs);
            logger.debug("itfsw(\u5b58\u5728\u5373\u66f4\u65b0\u63d2\u4ef6):" + introspectedTable.getMyBatis3XmlMapperFileName() + "\u589e\u52a0upsert\u5b9e\u73b0\u65b9\u6cd5\u3002");
            if (this.allowMultiQueries) {
                XmlElement eleUpsertByExampleWithBLOBs = new XmlElement("insert");
                eleUpsertByExampleWithBLOBs.addAttribute(new Attribute("id", METHOD_UPSERT_BY_EXAMPLE_WITH_BLOBS));
                eleUpsertByExampleWithBLOBs.addAttribute(new Attribute("parameterType", "map"));
                this.commentGenerator.addComment(eleUpsertByExampleWithBLOBs);
                XmlElementGeneratorTools.useGeneratedKeys(eleUpsertByExampleWithBLOBs, introspectedTable, "record.");
                eleUpsertByExampleWithBLOBs.addElement((Element)new TextElement("insert into " + introspectedTable.getFullyQualifiedTableNameAtRuntime()));
                for (Element element : XmlElementGeneratorTools.generateKeys(columns)) {
                    eleUpsertByExampleWithBLOBs.addElement(element);
                }
                this.generateExistsClause(introspectedTable, eleUpsertByExampleWithBLOBs, false, columns);
                eleUpsertByExampleWithBLOBs.addElement((Element)new TextElement(";"));
                eleUpsertByExampleWithBLOBs.addElement((Element)new TextElement("update " + introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime()));
                eleUpsertByExampleWithBLOBs.addElement((Element)new TextElement("set"));
                this.incrementsSupport(eleUpsertByExampleWithBLOBs, XmlElementGeneratorTools.generateSets(columns, "record."), introspectedTable, true);
                eleUpsertByExampleWithBLOBs.addElement(XmlElementGeneratorTools.getUpdateByExampleIncludeElement(introspectedTable));
                document.getRootElement().addElement((Element)eleUpsertByExampleWithBLOBs);
                logger.debug("itfsw(\u5b58\u5728\u5373\u66f4\u65b0\u63d2\u4ef6):" + introspectedTable.getMyBatis3XmlMapperFileName() + "\u589e\u52a0upsertSelective\u5b9e\u73b0\u65b9\u6cd5\u3002");
            }
        }
    }

    private void generateXmlElementWithoutBLOBs(Document document, IntrospectedTable introspectedTable) {
        List columns = ListUtilities.removeGeneratedAlwaysColumns((List)introspectedTable.getNonBLOBColumns());
        XmlElement eleUpsert = new XmlElement("insert");
        eleUpsert.addAttribute(new Attribute("id", METHOD_UPSERT));
        this.commentGenerator.addComment(eleUpsert);
        eleUpsert.addAttribute(new Attribute("parameterType", JavaElementGeneratorTools.getModelTypeWithoutBLOBs(introspectedTable).getFullyQualifiedName()));
        XmlElementGeneratorTools.useGeneratedKeys(eleUpsert, introspectedTable);
        eleUpsert.addElement((Element)new TextElement("insert into " + introspectedTable.getFullyQualifiedTableNameAtRuntime()));
        for (Element element : XmlElementGeneratorTools.generateKeys(columns)) {
            eleUpsert.addElement(element);
        }
        eleUpsert.addElement((Element)new TextElement("values"));
        for (Element element : XmlElementGeneratorTools.generateValues(columns)) {
            eleUpsert.addElement(element);
        }
        eleUpsert.addElement((Element)new TextElement("on duplicate key update "));
        this.incrementsSupport(eleUpsert, XmlElementGeneratorTools.generateSets(columns), introspectedTable, false);
        document.getRootElement().addElement((Element)eleUpsert);
        logger.debug("itfsw(\u5b58\u5728\u5373\u66f4\u65b0\u63d2\u4ef6):" + introspectedTable.getMyBatis3XmlMapperFileName() + "\u589e\u52a0upsert\u5b9e\u73b0\u65b9\u6cd5\u3002");
        if (this.allowMultiQueries) {
            XmlElement eleUpsertByExample = new XmlElement("insert");
            eleUpsertByExample.addAttribute(new Attribute("id", METHOD_UPSERT_BY_EXAMPLE));
            eleUpsertByExample.addAttribute(new Attribute("parameterType", "map"));
            this.commentGenerator.addComment(eleUpsertByExample);
            XmlElementGeneratorTools.useGeneratedKeys(eleUpsertByExample, introspectedTable, "record.");
            eleUpsertByExample.addElement((Element)new TextElement("insert into " + introspectedTable.getFullyQualifiedTableNameAtRuntime()));
            for (Element element : XmlElementGeneratorTools.generateKeys(columns)) {
                eleUpsertByExample.addElement(element);
            }
            this.generateExistsClause(introspectedTable, eleUpsertByExample, false, columns);
            eleUpsertByExample.addElement((Element)new TextElement(";"));
            eleUpsertByExample.addElement((Element)new TextElement("update " + introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime()));
            eleUpsertByExample.addElement((Element)new TextElement("set"));
            this.incrementsSupport(eleUpsertByExample, XmlElementGeneratorTools.generateSets(ListUtilities.removeIdentityAndGeneratedAlwaysColumns((List)columns), "record."), introspectedTable, true);
            eleUpsertByExample.addElement(XmlElementGeneratorTools.getUpdateByExampleIncludeElement(introspectedTable));
            document.getRootElement().addElement((Element)eleUpsertByExample);
            logger.debug("itfsw(\u5b58\u5728\u5373\u66f4\u65b0\u63d2\u4ef6):" + introspectedTable.getMyBatis3XmlMapperFileName() + "\u589e\u52a0upsertSelective\u5b9e\u73b0\u65b9\u6cd5\u3002");
        }
    }

    private void generateExistsClause(IntrospectedTable introspectedTable, XmlElement element, boolean selective, List<IntrospectedColumn> columns) {
        element.addElement((Element)new TextElement("select"));
        if (selective) {
            element.addElement((Element)XmlElementGeneratorTools.generateValuesSelective(columns, "record.", false));
        } else {
            for (Element element2 : XmlElementGeneratorTools.generateValues(columns, "record.", false)) {
                element.addElement(element2);
            }
        }
        element.addElement((Element)new TextElement("from dual where not exists"));
        element.addElement((Element)new TextElement("("));
        element.addElement((Element)new TextElement("select 1 from " + introspectedTable.getFullyQualifiedTableNameAtRuntime()));
        element.addElement(XmlElementGeneratorTools.getUpdateByExampleIncludeElement(introspectedTable));
        element.addElement((Element)new TextElement(")"));
    }

    private void incrementsSelectiveSupport(XmlElement xmlElement, XmlElement trimXmlElement, IntrospectedTable introspectedTable, boolean hasPrefix) {
        IncrementsPluginTools incTools = IncrementsPluginTools.getTools(this.context, introspectedTable, this.warnings);
        if (incTools.support()) {
            ArrayList<Element> ifs = new ArrayList<Element>();
            for (Element element : trimXmlElement.getElements()) {
                String text = ((TextElement)((XmlElement)element).getElements().get(0)).getContent();
                String columnName = text.split("=")[0];
                IntrospectedColumn introspectedColumn = IntrospectedTableTools.safeGetColumn(introspectedTable, columnName);
                if (incTools.supportColumn(introspectedColumn)) {
                    ((XmlElement)element).getElements().clear();
                    ((XmlElement)element).getElements().addAll(incTools.generatedIncrementsElement(introspectedColumn, hasPrefix, true));
                    continue;
                }
                ifs.add(element);
            }
        }
        xmlElement.addElement((Element)trimXmlElement);
    }

    private void incrementsSupport(XmlElement xmlElement, List<TextElement> elements, IntrospectedTable introspectedTable, boolean hasPrefix) {
        IncrementsPluginTools incTools = IncrementsPluginTools.getTools(this.context, introspectedTable, this.warnings);
        for (TextElement element : elements) {
            String text;
            String columnName;
            IntrospectedColumn introspectedColumn;
            if (incTools.support() && incTools.supportColumn(introspectedColumn = IntrospectedTableTools.safeGetColumn(introspectedTable, columnName = (text = element.getContent().trim()).split("=")[0]))) {
                xmlElement.getElements().addAll(incTools.generatedIncrementsElement(introspectedColumn, hasPrefix, text.endsWith(",")));
                continue;
            }
            xmlElement.addElement((Element)element);
        }
    }
}

