/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils;

import com.itfsw.mybatis.generator.plugins.CommentPlugin;
import com.itfsw.mybatis.generator.plugins.utils.PluginTools;
import com.itfsw.mybatis.generator.plugins.utils.enhanced.TemplateCommentGenerator;
import java.lang.reflect.Field;
import java.util.List;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.PluginConfiguration;
import org.mybatis.generator.internal.DefaultCommentGenerator;
import org.mybatis.generator.internal.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePlugin
extends PluginAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(BasePlugin.class);
    protected CommentGenerator commentGenerator;
    protected List<String> warnings;

    public void setContext(Context context) {
        super.setContext(context);
        PluginConfiguration cfg = PluginTools.getPluginConfiguration(context, CommentPlugin.class);
        if (cfg == null || cfg.getProperty("template") == null) {
            this.commentGenerator = context.getCommentGenerator() instanceof DefaultCommentGenerator ? new TemplateCommentGenerator("default-comment.ftl", true) : context.getCommentGenerator();
        } else {
            TemplateCommentGenerator templateCommentGenerator = new TemplateCommentGenerator(cfg.getProperty("template"), false);
            this.commentGenerator = templateCommentGenerator;
            try {
                context.getCommentGenerator();
                Field field = Context.class.getDeclaredField("commentGenerator");
                field.setAccessible(true);
                field.set(context, templateCommentGenerator);
            }
            catch (Exception e) {
                logger.error("\u53cd\u5c04\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public boolean validate(List<String> warnings) {
        this.warnings = warnings;
        if (StringUtility.stringHasValue((String)this.getContext().getTargetRuntime()) && !"MyBatis3".equalsIgnoreCase(this.getContext().getTargetRuntime())) {
            warnings.add("itfsw:\u63d2\u4ef6" + ((Object)((Object)this)).getClass().getTypeName() + "\u8981\u6c42\u8fd0\u884ctargetRuntime\u5fc5\u987b\u4e3aMyBatis3\uff01");
            return false;
        }
        return true;
    }
}

