/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils;

import com.itfsw.mybatis.generator.plugins.IncrementsPlugin;
import com.itfsw.mybatis.generator.plugins.utils.IntrospectedTableTools;
import com.itfsw.mybatis.generator.plugins.utils.PluginTools;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementsPluginTools {
    private static final Logger logger = LoggerFactory.getLogger(IncrementsPluginTools.class);
    private Context context;
    private IntrospectedTable introspectedTable;
    private List<IntrospectedColumn> columns = new ArrayList<IntrospectedColumn>();

    private IncrementsPluginTools(Context context, IntrospectedTable introspectedTable) {
        this.context = context;
        this.introspectedTable = introspectedTable;
    }

    public static IncrementsPluginTools getTools(Context context, IntrospectedTable introspectedTable, List<String> warnings) {
        String incrementsColumns;
        IncrementsPluginTools tools = new IncrementsPluginTools(context, introspectedTable);
        if (PluginTools.getPluginConfiguration(context, IncrementsPlugin.class) != null && StringUtility.stringHasValue((String)(incrementsColumns = introspectedTable.getTableConfigurationProperty("incrementsColumns")))) {
            String[] incrementsColumnsStrs;
            for (String incrementsColumnsStr : incrementsColumnsStrs = incrementsColumns.split(",")) {
                IntrospectedColumn column = IntrospectedTableTools.safeGetColumn(introspectedTable, incrementsColumnsStr);
                if (column == null) {
                    warnings.add("itfsw:\u63d2\u4ef6" + IncrementsPlugin.class.getTypeName() + "\u63d2\u4ef6\u6ca1\u6709\u627e\u5230column\u4e3a" + incrementsColumnsStr.trim() + "\u7684\u5b57\u6bb5\uff01");
                    continue;
                }
                tools.columns.add(column);
            }
        }
        return tools;
    }

    public FullyQualifiedJavaType getIncEnum() {
        return new FullyQualifiedJavaType(this.introspectedTable.getFullyQualifiedTable().getDomainObjectName() + "." + "Builder" + ".Inc");
    }

    public boolean support() {
        return this.columns.size() > 0;
    }

    public List<IntrospectedColumn> getColumns() {
        return this.columns;
    }

    public boolean supportColumn(IntrospectedColumn searchColumn) {
        for (IntrospectedColumn column : this.columns) {
            if (!column.getActualColumnName().equals(searchColumn.getActualColumnName())) continue;
            return true;
        }
        return false;
    }

    public List<Element> generatedIncrementsElement(IntrospectedColumn introspectedColumn, boolean hasPrefix, boolean hasComma) {
        ArrayList<Element> list = new ArrayList<Element>();
        list.add((Element)new TextElement(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + " = "));
        XmlElement choose = new XmlElement("choose");
        XmlElement when = new XmlElement("when");
        when.addAttribute(new Attribute("test", (hasPrefix ? "record." : "_parameter.") + "hasIncsForColumn" + "('" + MyBatis3FormattingUtilities.escapeStringForMyBatis3((String)introspectedColumn.getActualColumnName()) + "')"));
        TextElement spec = new TextElement(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + " ${" + (hasPrefix ? "record." : "") + "incrementsColumnsInfoMap" + "." + MyBatis3FormattingUtilities.escapeStringForMyBatis3((String)introspectedColumn.getActualColumnName()) + ".value} " + MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)(hasPrefix ? "record." : null)));
        when.addElement((Element)spec);
        choose.addElement((Element)when);
        XmlElement otherwise = new XmlElement("otherwise");
        TextElement normal = new TextElement(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)(hasPrefix ? "record." : null)));
        otherwise.addElement((Element)normal);
        choose.addElement((Element)otherwise);
        list.add((Element)choose);
        if (hasComma) {
            list.add((Element)new TextElement(","));
        }
        return list;
    }
}

