/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils;

import java.util.Collection;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.internal.util.messages.Messages;

public class JavaElementGeneratorTools {
    public static Field generateStaticFinalField(String fieldName, FullyQualifiedJavaType javaType, String initString) {
        Field field = new Field(fieldName, javaType);
        field.setVisibility(JavaVisibility.PUBLIC);
        field.setStatic(true);
        field.setFinal(true);
        if (initString != null) {
            field.setInitializationString(initString);
        }
        return field;
    }

    public static Field generateField(String fieldName, JavaVisibility visibility, FullyQualifiedJavaType javaType, String initString) {
        Field field = new Field(fieldName, javaType);
        field.setVisibility(visibility);
        if (initString != null) {
            field.setInitializationString(initString);
        }
        return field;
    }

    public static Method generateMethod(String methodName, JavaVisibility visibility, FullyQualifiedJavaType returnType, Parameter ... parameters) {
        Method method = new Method(methodName);
        method.setVisibility(visibility);
        method.setReturnType(returnType);
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                method.addParameter(parameter);
            }
        }
        return method;
    }

    public static Method generateMethodBody(Method method, String ... bodyLines) {
        if (bodyLines != null) {
            for (String bodyLine : bodyLines) {
                method.addBodyLine(bodyLine);
            }
        }
        return method;
    }

    public static Method generateSetterMethod(Field field) {
        Method method = JavaElementGeneratorTools.generateMethod("set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1), JavaVisibility.PUBLIC, null, new Parameter(field.getType(), field.getName()));
        return JavaElementGeneratorTools.generateMethodBody(method, "this." + field.getName() + " = " + field.getName() + ";");
    }

    public static Method generateGetterMethod(Field field) {
        Method method = JavaElementGeneratorTools.generateMethod("get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1), JavaVisibility.PUBLIC, field.getType(), new Parameter[0]);
        return JavaElementGeneratorTools.generateMethodBody(method, "return this." + field.getName() + ";");
    }

    public static FullyQualifiedJavaType getModelTypeWithoutBLOBs(IntrospectedTable introspectedTable) {
        FullyQualifiedJavaType type;
        if (introspectedTable.getRules().generateBaseRecordClass()) {
            type = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        } else if (introspectedTable.getRules().generatePrimaryKeyClass()) {
            type = new FullyQualifiedJavaType(introspectedTable.getPrimaryKeyType());
        } else {
            throw new RuntimeException(Messages.getString((String)"RuntimeError.12"));
        }
        return type;
    }

    public static FullyQualifiedJavaType getModelTypeWithBLOBs(IntrospectedTable introspectedTable) {
        FullyQualifiedJavaType type = introspectedTable.getRules().generateRecordWithBLOBsClass() ? new FullyQualifiedJavaType(introspectedTable.getRecordWithBLOBsType()) : new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        return type;
    }

    public static Method cloneMethod(Method method) {
        Method result = new Method();
        result.setConstructor(method.isConstructor());
        result.setFinal(method.isFinal());
        result.setName(method.getName());
        result.setNative(method.isNative());
        result.setReturnType(method.getReturnType());
        result.setSynchronized(method.isSynchronized());
        result.setStatic(method.isStatic());
        result.setVisibility(method.getVisibility());
        for (Parameter parameter : method.getParameters()) {
            result.addParameter(parameter);
        }
        for (String docLine : method.getJavaDocLines()) {
            result.addJavaDocLine(docLine);
        }
        result.addBodyLines((Collection)method.getBodyLines());
        return result;
    }
}

