/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.PluginConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginTools {
    private static final Logger logger = LoggerFactory.getLogger(PluginTools.class);

    public static boolean checkDependencyPlugin(Context context, Class plugin) {
        return PluginTools.getPluginIndex(context, plugin) >= 0;
    }

    public static int getPluginIndex(Context context, Class plugin) {
        List<PluginConfiguration> list = PluginTools.getConfigPlugins(context);
        for (int i = 0; i < list.size(); ++i) {
            PluginConfiguration config = list.get(i);
            if (!plugin.getName().equals(config.getConfigurationType())) continue;
            return i;
        }
        return -1;
    }

    public static List<PluginConfiguration> getConfigPlugins(Context ctx) {
        try {
            Field field = Context.class.getDeclaredField("pluginConfigurations");
            field.setAccessible(true);
            return (List)field.get(ctx);
        }
        catch (Exception e) {
            logger.error("\u63d2\u4ef6\u68c0\u67e5\u53cd\u5c04\u5f02\u5e38", (Throwable)e);
            return new ArrayList<PluginConfiguration>();
        }
    }

    public static PluginConfiguration getPluginConfiguration(Context context, Class plugin) {
        int index = PluginTools.getPluginIndex(context, plugin);
        if (index > -1) {
            return PluginTools.getConfigPlugins(context).get(index);
        }
        return null;
    }

    public static boolean shouldAfterPlugins(Context context, Class plugin, List<String> warnings, Class ... plugins) {
        int index = PluginTools.getPluginIndex(context, plugin);
        if (plugins != null) {
            for (Class cls : plugins) {
                int index1 = PluginTools.getPluginIndex(context, cls);
                if (index1 == -1 || index1 < index) continue;
                warnings.add("itfsw:\u63d2\u4ef6" + plugin.getTypeName() + "\u63d2\u4ef6\u5efa\u8bae\u914d\u7f6e\u5728\u63d2\u4ef6" + cls.getTypeName() + "\u540e\u9762\uff0c\u5426\u5219\u67d0\u4e9b\u529f\u80fd\u53ef\u80fd\u5f97\u4e0d\u5230\u589e\u5f3a\uff01");
                return false;
            }
            return true;
        }
        return false;
    }
}

