/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils;

import com.itfsw.mybatis.generator.plugins.utils.IntrospectedTableTools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.config.GeneratedKey;

public class XmlElementGeneratorTools {
    public static Element getSelectKey(IntrospectedColumn introspectedColumn, GeneratedKey generatedKey) {
        String identityColumnType = introspectedColumn.getFullyQualifiedJavaType().getFullyQualifiedName();
        XmlElement answer = new XmlElement("selectKey");
        answer.addAttribute(new Attribute("resultType", identityColumnType));
        answer.addAttribute(new Attribute("keyProperty", introspectedColumn.getJavaProperty()));
        answer.addAttribute(new Attribute("order", generatedKey.getMyBatis3Order()));
        answer.addElement((Element)new TextElement(generatedKey.getRuntimeSqlStatement()));
        return answer;
    }

    public static Element getBaseColumnListElement(IntrospectedTable introspectedTable) {
        XmlElement answer = new XmlElement("include");
        answer.addAttribute(new Attribute("refid", introspectedTable.getBaseColumnListId()));
        return answer;
    }

    public static Element getBlobColumnListElement(IntrospectedTable introspectedTable) {
        XmlElement answer = new XmlElement("include");
        answer.addAttribute(new Attribute("refid", introspectedTable.getBlobColumnListId()));
        return answer;
    }

    public static Element getExampleIncludeElement(IntrospectedTable introspectedTable) {
        XmlElement ifElement = new XmlElement("if");
        ifElement.addAttribute(new Attribute("test", "_parameter != null"));
        XmlElement includeElement = new XmlElement("include");
        includeElement.addAttribute(new Attribute("refid", introspectedTable.getExampleWhereClauseId()));
        ifElement.addElement((Element)includeElement);
        return ifElement;
    }

    public static Element getUpdateByExampleIncludeElement(IntrospectedTable introspectedTable) {
        XmlElement ifElement = new XmlElement("if");
        ifElement.addAttribute(new Attribute("test", "_parameter != null"));
        XmlElement includeElement = new XmlElement("include");
        includeElement.addAttribute(new Attribute("refid", introspectedTable.getMyBatis3UpdateByExampleWhereClauseId()));
        ifElement.addElement((Element)includeElement);
        return ifElement;
    }

    public static void useGeneratedKeys(XmlElement element, IntrospectedTable introspectedTable) {
        XmlElementGeneratorTools.useGeneratedKeys(element, introspectedTable, null);
    }

    public static void useGeneratedKeys(XmlElement element, IntrospectedTable introspectedTable, String prefix) {
        IntrospectedColumn introspectedColumn;
        GeneratedKey gk = introspectedTable.getGeneratedKey();
        if (gk != null && (introspectedColumn = IntrospectedTableTools.safeGetColumn(introspectedTable, gk.getColumn())) != null) {
            element.addAttribute(new Attribute("useGeneratedKeys", "true"));
            element.addAttribute(new Attribute("keyProperty", (prefix == null ? "" : prefix) + introspectedColumn.getJavaProperty()));
            element.addAttribute(new Attribute("keyColumn", introspectedColumn.getActualColumnName()));
        }
    }

    public static List<TextElement> generateKeys(List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateKeys(columns, true);
    }

    public static List<TextElement> generateKeys(List<IntrospectedColumn> columns, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumns(columns, null, bracket, 1);
    }

    public static Element generateKeysSelective(List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateKeysSelective(columns, null);
    }

    public static Element generateKeysSelective(List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateKeysSelective(columns, prefix, true);
    }

    public static XmlElement generateKeysSelective(List<IntrospectedColumn> columns, String prefix, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumnsSelective(columns, prefix, bracket, 1);
    }

    public static List<TextElement> generateValues(List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateValues(columns, null);
    }

    public static List<TextElement> generateValues(List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateValues(columns, prefix, true);
    }

    public static List<TextElement> generateValues(List<IntrospectedColumn> columns, String prefix, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumns(columns, prefix, bracket, 2);
    }

    public static Element generateValuesSelective(List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateValuesSelective(columns, null);
    }

    public static Element generateValuesSelective(List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateValuesSelective(columns, prefix, true);
    }

    public static XmlElement generateValuesSelective(List<IntrospectedColumn> columns, String prefix, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumnsSelective(columns, prefix, bracket, 2);
    }

    public static List<TextElement> generateSets(List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateSets(columns, null, false);
    }

    public static List<TextElement> generateSets(List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateSets(columns, prefix, false);
    }

    public static List<TextElement> generateSets(List<IntrospectedColumn> columns, String prefix, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumns(columns, prefix, bracket, 3);
    }

    public static XmlElement generateSetsSelective(List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateSetsSelective(columns, null, false);
    }

    public static XmlElement generateSetsSelective(List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateSetsSelective(columns, prefix, false);
    }

    public static XmlElement generateSetsSelective(List<IntrospectedColumn> columns, String prefix, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumnsSelective(columns, prefix, bracket, 3);
    }

    private static List<TextElement> generateCommColumns(List<IntrospectedColumn> columns, String prefix, boolean bracket, int type) {
        ArrayList<TextElement> list = new ArrayList<TextElement>();
        StringBuilder sb = new StringBuilder(bracket ? "(" : "");
        Iterator<IntrospectedColumn> columnIterator = columns.iterator();
        while (columnIterator.hasNext()) {
            IntrospectedColumn introspectedColumn = columnIterator.next();
            switch (type) {
                case 3: {
                    sb.append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn));
                    sb.append(" = ");
                    sb.append(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix));
                    break;
                }
                case 2: {
                    sb.append(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix));
                    break;
                }
                case 1: {
                    sb.append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn));
                }
            }
            if (columnIterator.hasNext()) {
                sb.append(", ");
            }
            if (type == 1 || type == 2) {
                if (sb.length() <= 80) continue;
                list.add(new TextElement(sb.toString()));
                sb.setLength(0);
                OutputUtilities.xmlIndent((StringBuilder)sb, (int)1);
                continue;
            }
            list.add(new TextElement(sb.toString()));
            sb.setLength(0);
        }
        if (sb.length() > 0 || bracket) {
            list.add(new TextElement(sb.append(bracket ? ")" : "").toString()));
        }
        return list;
    }

    private static XmlElement generateCommColumnsSelective(List<IntrospectedColumn> columns, String prefix, boolean bracket, int type) {
        XmlElement eleTrim = new XmlElement("trim");
        if (bracket) {
            eleTrim.addAttribute(new Attribute("prefix", "("));
            eleTrim.addAttribute(new Attribute("suffix", ")"));
            eleTrim.addAttribute(new Attribute("suffixOverrides", ","));
        } else {
            eleTrim.addAttribute(new Attribute("suffixOverrides", ","));
        }
        for (IntrospectedColumn introspectedColumn : columns) {
            XmlElement eleIf = new XmlElement("if");
            eleIf.addAttribute(new Attribute("test", introspectedColumn.getJavaProperty(prefix) + " != null"));
            switch (type) {
                case 3: {
                    eleIf.addElement((Element)new TextElement(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + " = " + MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix) + ","));
                    break;
                }
                case 2: {
                    eleIf.addElement((Element)new TextElement(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix) + ","));
                    break;
                }
                case 1: {
                    eleIf.addElement((Element)new TextElement(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + ","));
                }
            }
            eleTrim.addElement((Element)eleIf);
        }
        return eleTrim;
    }

    public static List<XmlElement> findXmlElements(XmlElement xmlElement, String name) {
        ArrayList<XmlElement> list = new ArrayList<XmlElement>();
        List elements = xmlElement.getElements();
        for (Element ele : elements) {
            XmlElement xmlElement1;
            if (!(ele instanceof XmlElement) || !name.equalsIgnoreCase((xmlElement1 = (XmlElement)ele).getName())) continue;
            list.add(xmlElement1);
        }
        return list;
    }
}

