/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import com.itfsw.mybatis.generator.plugins.utils.FormatTools;
import com.itfsw.mybatis.generator.plugins.utils.JavaElementGeneratorTools;
import com.itfsw.mybatis.generator.plugins.utils.hook.ISelectSelectivePluginHook;
import java.util.List;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.PrimitiveTypeWrapper;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.util.StringUtility;

public class LimitPlugin
extends BasePlugin
implements ISelectSelectivePluginHook {
    public static final String PRO_START_PAGE = "startPage";
    private static final int DEFAULT_START_PAGE = 0;
    private int startPage;

    @Override
    public boolean validate(List<String> warnings) {
        if (!"com.mysql.jdbc.Driver".equalsIgnoreCase(this.getContext().getJdbcConnectionConfiguration().getDriverClass()) && !"com.mysql.cj.jdbc.Driver".equalsIgnoreCase(this.getContext().getJdbcConnectionConfiguration().getDriverClass())) {
            warnings.add("itfsw:\u63d2\u4ef6" + this.getClass().getTypeName() + "\u53ea\u652f\u6301MySQL\u6570\u636e\u5e93\uff01");
            return false;
        }
        return super.validate(warnings);
    }

    @Override
    public void initialized(IntrospectedTable introspectedTable) {
        super.initialized(introspectedTable);
        String startPage = this.getProperties().getProperty(PRO_START_PAGE);
        this.startPage = StringUtility.stringHasValue((String)startPage) ? Integer.valueOf(startPage) : 0;
    }

    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        PrimitiveTypeWrapper integerWrapper = FullyQualifiedJavaType.getIntInstance().getPrimitiveTypeWrapper();
        Field offsetField = JavaElementGeneratorTools.generateField("offset", JavaVisibility.PROTECTED, (FullyQualifiedJavaType)integerWrapper, null);
        this.commentGenerator.addFieldComment(offsetField, introspectedTable);
        topLevelClass.addField(offsetField);
        Field rowsField = JavaElementGeneratorTools.generateField("rows", JavaVisibility.PROTECTED, (FullyQualifiedJavaType)integerWrapper, null);
        this.commentGenerator.addFieldComment(rowsField, introspectedTable);
        topLevelClass.addField(rowsField);
        logger.debug("itfsw(MySQL\u5206\u9875\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0offset\u548crows\u5b57\u6bb5");
        Method mSetOffset = JavaElementGeneratorTools.generateSetterMethod(offsetField);
        this.commentGenerator.addGeneralMethodComment(mSetOffset, introspectedTable);
        FormatTools.addMethodWithBestPosition(topLevelClass, mSetOffset);
        Method mGetOffset = JavaElementGeneratorTools.generateGetterMethod(offsetField);
        this.commentGenerator.addGeneralMethodComment(mGetOffset, introspectedTable);
        FormatTools.addMethodWithBestPosition(topLevelClass, mGetOffset);
        Method mSetRows = JavaElementGeneratorTools.generateSetterMethod(rowsField);
        this.commentGenerator.addGeneralMethodComment(mSetRows, introspectedTable);
        FormatTools.addMethodWithBestPosition(topLevelClass, mSetRows);
        Method mGetRows = JavaElementGeneratorTools.generateGetterMethod(rowsField);
        this.commentGenerator.addGeneralMethodComment(mGetRows, introspectedTable);
        FormatTools.addMethodWithBestPosition(topLevelClass, mGetRows);
        logger.debug("itfsw(MySQL\u5206\u9875\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0offset\u548crows\u7684getter\u548csetter\u5b9e\u73b0\u3002");
        Method setLimit = JavaElementGeneratorTools.generateMethod("limit", JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter((FullyQualifiedJavaType)integerWrapper, "rows"));
        this.commentGenerator.addGeneralMethodComment(setLimit, introspectedTable);
        setLimit = JavaElementGeneratorTools.generateMethodBody(setLimit, "this.rows = rows;", "return this;");
        FormatTools.addMethodWithBestPosition(topLevelClass, setLimit);
        Method setLimit2 = JavaElementGeneratorTools.generateMethod("limit", JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter((FullyQualifiedJavaType)integerWrapper, "offset"), new Parameter((FullyQualifiedJavaType)integerWrapper, "rows"));
        this.commentGenerator.addGeneralMethodComment(setLimit2, introspectedTable);
        setLimit2 = JavaElementGeneratorTools.generateMethodBody(setLimit2, "this.offset = offset;", "this.rows = rows;", "return this;");
        FormatTools.addMethodWithBestPosition(topLevelClass, setLimit2);
        logger.debug("itfsw(MySQL\u5206\u9875\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0limit\u65b9\u6cd5\u3002");
        Method setPage = JavaElementGeneratorTools.generateMethod("page", JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter((FullyQualifiedJavaType)integerWrapper, "page"), new Parameter((FullyQualifiedJavaType)integerWrapper, "pageSize"));
        this.commentGenerator.addGeneralMethodComment(setPage, introspectedTable);
        setPage = JavaElementGeneratorTools.generateMethodBody(setPage, "this.offset = " + (this.startPage == 0 ? "page" : "(page - " + this.startPage + ")") + " * pageSize;", "this.rows = pageSize;", "return this;");
        FormatTools.addMethodWithBestPosition(topLevelClass, setPage);
        logger.debug("itfsw(MySQL\u5206\u9875\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0page\u65b9\u6cd5");
        List methodList = topLevelClass.getMethods();
        for (Method method : methodList) {
            if (!method.getName().equals("clear")) continue;
            method.addBodyLine("rows = null;");
            method.addBodyLine("offset = null;");
            logger.debug("itfsw(MySQL\u5206\u9875\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u4fee\u6539clear\u65b9\u6cd5,\u589e\u52a0rows\u548coffset\u5b57\u6bb5\u7684\u6e05\u7a7a");
        }
        return true;
    }

    public boolean sqlMapSelectByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generateLimitElement(element);
        return true;
    }

    public boolean sqlMapSelectByExampleWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generateLimitElement(element);
        return true;
    }

    @Override
    public boolean sqlMapSelectByExampleSelectiveElementGenerated(Document document, XmlElement element, IntrospectedTable introspectedTable) {
        this.generateLimitElementWithExample(element);
        return false;
    }

    private void generateLimitElement(XmlElement element) {
        XmlElement ifLimitNotNullElement = new XmlElement("if");
        ifLimitNotNullElement.addAttribute(new Attribute("test", "rows != null"));
        XmlElement ifOffsetNotNullElement = new XmlElement("if");
        ifOffsetNotNullElement.addAttribute(new Attribute("test", "offset != null"));
        ifOffsetNotNullElement.addElement((Element)new TextElement("limit ${offset}, ${rows}"));
        ifLimitNotNullElement.addElement((Element)ifOffsetNotNullElement);
        XmlElement ifOffsetNullElement = new XmlElement("if");
        ifOffsetNullElement.addAttribute(new Attribute("test", "offset == null"));
        ifOffsetNullElement.addElement((Element)new TextElement("limit ${rows}"));
        ifLimitNotNullElement.addElement((Element)ifOffsetNullElement);
        element.addElement((Element)ifLimitNotNullElement);
    }

    private void generateLimitElementWithExample(XmlElement element) {
        XmlElement ifLimitNotNullElement = new XmlElement("if");
        ifLimitNotNullElement.addAttribute(new Attribute("test", "example.rows != null"));
        XmlElement ifOffsetNotNullElement = new XmlElement("if");
        ifOffsetNotNullElement.addAttribute(new Attribute("test", "example.offset != null"));
        ifOffsetNotNullElement.addElement((Element)new TextElement("limit ${example.offset}, ${example.rows}"));
        ifLimitNotNullElement.addElement((Element)ifOffsetNotNullElement);
        XmlElement ifOffsetNullElement = new XmlElement("if");
        ifOffsetNullElement.addAttribute(new Attribute("test", "example.offset == null"));
        ifOffsetNullElement.addElement((Element)new TextElement("limit ${example.rows}"));
        ifLimitNotNullElement.addElement((Element)ifOffsetNullElement);
        element.addElement((Element)ifLimitNotNullElement);
    }
}

