/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import com.itfsw.mybatis.generator.plugins.utils.FormatTools;
import com.itfsw.mybatis.generator.plugins.utils.JavaElementGeneratorTools;
import com.itfsw.mybatis.generator.plugins.utils.PluginTools;
import com.itfsw.mybatis.generator.plugins.utils.XmlElementGeneratorTools;
import com.itfsw.mybatis.generator.plugins.utils.XmlElementTools;
import com.itfsw.mybatis.generator.plugins.utils.hook.ILogicalDeletePluginHook;
import com.itfsw.mybatis.generator.plugins.utils.hook.IModelBuilderPluginHook;
import com.itfsw.mybatis.generator.plugins.utils.hook.IOptimisticLockerPluginHook;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;

public class OptimisticLockerPlugin
extends BasePlugin
implements IModelBuilderPluginHook,
ILogicalDeletePluginHook {
    public static final String METHOD_DELETE_WITH_VERSION_BY_EXAMPLE = "deleteWithVersionByExample";
    public static final String METHOD_DELETE_WITH_VERSION_BY_PRIMARY_KEY = "deleteWithVersionByPrimaryKey";
    public static final String METHOD_LOGICAL_DELETE_WITH_VERSION_BY_EXAMPLE = "logicalDeleteWithVersionByExample";
    public static final String METHOD_LOGICAL_DELETE_WITH_VERSION_BY_PRIMARY_KEY = "logicalDeleteWithVersionByPrimaryKey";
    public static final String METHOD_UPDATE_WITH_VERSION_BY_EXAMPLE_SELECTIVE = "updateWithVersionByExampleSelective";
    public static final String METHOD_UPDATE_WITH_VERSION_BY_EXAMPLE_WITH_BLOBS = "updateWithVersionByExampleWithBLOBs";
    public static final String METHOD_UPDATE_WITH_VERSION_BY_EXAMPLE_WITHOUT_BLOBS = "updateWithVersionByExample";
    public static final String METHOD_UPDATE_WITH_VERSION_BY_PRIMARY_KEY_SELECTIVE = "updateWithVersionByPrimaryKeySelective";
    public static final String METHOD_UPDATE_WITH_VERSION_BY_PRIMARY_KEY_WITH_BLOBS = "updateWithVersionByPrimaryKeyWithBLOBs";
    public static final String METHOD_UPDATE_WITH_VERSION_BY_PRIMARY_KEY_WITHOUT_BLOBS = "updateWithVersionByPrimaryKey";
    public static final String METHOD_NEXT_VERSION = "nextVersion";
    public static final String SQL_UPDATE_BY_EXAMPLE_WITH_VERSION_WHERE_CLAUSE = "Update_By_Example_With_Version_Where_Clause";
    public static final String PRO_VERSION_COLUMN = "versionColumn";
    public static final String PRO_CUSTOMIZED_NEXT_VERSION = "customizedNextVersion";
    private Map<IntrospectedTable, List<XmlElement>> sqlMaps = new HashMap<IntrospectedTable, List<XmlElement>>();
    private IntrospectedColumn versionColumn;
    private boolean customizedNextVersion;

    @Override
    public void initialized(IntrospectedTable introspectedTable) {
        super.initialized(introspectedTable);
        this.sqlMaps.put(introspectedTable, new ArrayList());
        String versionColumn = introspectedTable.getTableConfigurationProperty(PRO_VERSION_COLUMN);
        if (versionColumn != null) {
            this.versionColumn = introspectedTable.getColumn(versionColumn);
            if (this.versionColumn == null) {
                this.warnings.add("itfsw(\u4e50\u89c2\u9501\u63d2\u4ef6):\u8868" + introspectedTable.getFullyQualifiedTable() + "\u914d\u7f6e\u7684\u7248\u672c\u5217(" + introspectedTable.getTableConfigurationProperty(PRO_VERSION_COLUMN) + ")\u6ca1\u6709\u627e\u5230\uff01");
            }
        } else {
            this.versionColumn = null;
        }
        Properties properties = this.getProperties();
        String customizedNextVersion = properties.getProperty(PRO_CUSTOMIZED_NEXT_VERSION);
        if (introspectedTable.getTableConfigurationProperty(PRO_CUSTOMIZED_NEXT_VERSION) != null) {
            customizedNextVersion = introspectedTable.getTableConfigurationProperty(PRO_CUSTOMIZED_NEXT_VERSION);
        }
        this.customizedNextVersion = StringUtility.stringHasValue((String)customizedNextVersion) && StringUtility.isTrue((String)customizedNextVersion);
        super.initialized(introspectedTable);
    }

    public boolean clientDeleteByExampleMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            FormatTools.addMethodWithBestPosition(interfaze, this.replaceDeleteExampleMethod(introspectedTable, method, interfaze, METHOD_DELETE_WITH_VERSION_BY_EXAMPLE));
        }
        return super.clientDeleteByExampleMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean clientDeleteByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            FormatTools.addMethodWithBestPosition(interfaze, this.replaceDeletePrimaryKeyMethod(introspectedTable, method, interfaze, METHOD_DELETE_WITH_VERSION_BY_PRIMARY_KEY));
        }
        return super.clientDeleteByPrimaryKeyMethodGenerated(method, interfaze, introspectedTable);
    }

    @Override
    public boolean clientLogicalDeleteByExampleMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            if (this.customizedNextVersion) {
                Method newMethod = JavaElementGeneratorTools.generateMethod(METHOD_LOGICAL_DELETE_WITH_VERSION_BY_EXAMPLE, JavaVisibility.DEFAULT, FullyQualifiedJavaType.getIntInstance(), new Parameter(this.versionColumn.getFullyQualifiedJavaType(), "version", "@Param(\"version\")"), new Parameter(this.versionColumn.getFullyQualifiedJavaType(), METHOD_NEXT_VERSION, "@Param(\"nextVersion\")"), new Parameter(new FullyQualifiedJavaType(introspectedTable.getExampleType()), "example", "@Param(\"example\")"));
                this.commentGenerator.addGeneralMethodComment(newMethod, introspectedTable);
                FormatTools.addMethodWithBestPosition(interfaze, newMethod);
            } else {
                FormatTools.addMethodWithBestPosition(interfaze, this.replaceDeleteExampleMethod(introspectedTable, method, interfaze, METHOD_LOGICAL_DELETE_WITH_VERSION_BY_EXAMPLE));
            }
        }
        return true;
    }

    @Override
    public boolean clientLogicalDeleteByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            if (this.customizedNextVersion) {
                Method newMethod = JavaElementGeneratorTools.generateMethod(METHOD_LOGICAL_DELETE_WITH_VERSION_BY_PRIMARY_KEY, JavaVisibility.DEFAULT, FullyQualifiedJavaType.getIntInstance(), new Parameter(this.versionColumn.getFullyQualifiedJavaType(), "version", "@Param(\"version\")"), new Parameter(this.versionColumn.getFullyQualifiedJavaType(), METHOD_NEXT_VERSION, "@Param(\"nextVersion\")"), new Parameter(((Parameter)method.getParameters().get(0)).getType(), ((Parameter)method.getParameters().get(0)).getName(), "@Param(\"key\")"));
                this.commentGenerator.addGeneralMethodComment(newMethod, introspectedTable);
                FormatTools.addMethodWithBestPosition(interfaze, newMethod);
            } else {
                FormatTools.addMethodWithBestPosition(interfaze, this.replaceDeletePrimaryKeyMethod(introspectedTable, method, interfaze, METHOD_LOGICAL_DELETE_WITH_VERSION_BY_PRIMARY_KEY));
            }
        }
        return true;
    }

    public boolean clientUpdateByExampleSelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            Method withVersion = this.replaceUpdateExampleMethod(introspectedTable, method, interfaze, METHOD_UPDATE_WITH_VERSION_BY_EXAMPLE_SELECTIVE);
            if (PluginTools.getHook(IOptimisticLockerPluginHook.class).clientUpdateWithVersionByExampleSelectiveMethodGenerated(withVersion, interfaze, introspectedTable)) {
                FormatTools.addMethodWithBestPosition(interfaze, withVersion);
            }
        }
        return super.clientUpdateByExampleSelectiveMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean clientUpdateByExampleWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            FormatTools.addMethodWithBestPosition(interfaze, this.replaceUpdateExampleMethod(introspectedTable, method, interfaze, METHOD_UPDATE_WITH_VERSION_BY_EXAMPLE_WITH_BLOBS));
        }
        return super.clientUpdateByExampleWithBLOBsMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean clientUpdateByExampleWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            FormatTools.addMethodWithBestPosition(interfaze, this.replaceUpdateExampleMethod(introspectedTable, method, interfaze, METHOD_UPDATE_WITH_VERSION_BY_EXAMPLE_WITHOUT_BLOBS));
        }
        return super.clientUpdateByExampleWithoutBLOBsMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean clientUpdateByPrimaryKeySelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            Method withVersion = this.replaceUpdatePrimaryKeyMethod(introspectedTable, method, interfaze, METHOD_UPDATE_WITH_VERSION_BY_PRIMARY_KEY_SELECTIVE);
            if (PluginTools.getHook(IOptimisticLockerPluginHook.class).clientUpdateWithVersionByPrimaryKeySelectiveMethodGenerated(withVersion, interfaze, introspectedTable)) {
                FormatTools.addMethodWithBestPosition(interfaze, withVersion);
            }
        }
        return super.clientUpdateByPrimaryKeySelectiveMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean clientUpdateByPrimaryKeyWithBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            FormatTools.addMethodWithBestPosition(interfaze, this.replaceUpdatePrimaryKeyMethod(introspectedTable, method, interfaze, METHOD_UPDATE_WITH_VERSION_BY_PRIMARY_KEY_WITH_BLOBS));
        }
        return super.clientUpdateByPrimaryKeyWithBLOBsMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean clientUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            FormatTools.addMethodWithBestPosition(interfaze, this.replaceUpdatePrimaryKeyMethod(introspectedTable, method, interfaze, METHOD_UPDATE_WITH_VERSION_BY_PRIMARY_KEY_WITHOUT_BLOBS));
        }
        return super.clientUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(method, interfaze, introspectedTable);
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        if (this.versionColumn != null && this.customizedNextVersion && introspectedColumn.getActualColumnName().equals(this.versionColumn.getActualColumnName())) {
            Method nextVersion = JavaElementGeneratorTools.generateMethod(METHOD_NEXT_VERSION, JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter(this.versionColumn.getFullyQualifiedJavaType(), "version"));
            this.commentGenerator.addSetterComment(nextVersion, introspectedTable, this.versionColumn);
            JavaElementGeneratorTools.generateMethodBody(nextVersion, "this." + this.versionColumn.getJavaProperty() + " = version;", "return this;");
            FormatTools.addMethodWithBestPosition(topLevelClass, nextVersion);
        }
        return super.modelSetterMethodGenerated(method, topLevelClass, introspectedColumn, introspectedTable, modelClassType);
    }

    @Override
    public boolean modelBuilderSetterMethodGenerated(Method method, TopLevelClass topLevelClass, InnerClass builderClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null && this.customizedNextVersion && introspectedColumn.getActualColumnName().equals(this.versionColumn.getActualColumnName())) {
            Method nextVersion = JavaElementGeneratorTools.generateMethod(METHOD_NEXT_VERSION, JavaVisibility.PUBLIC, builderClass.getType(), new Parameter(this.versionColumn.getFullyQualifiedJavaType(), "version"));
            nextVersion.addAnnotation("@Deprecated");
            this.commentGenerator.addSetterComment(nextVersion, introspectedTable, this.versionColumn);
            Method setterMethod = JavaBeansUtil.getJavaBeansSetter((IntrospectedColumn)this.versionColumn, (Context)this.context, (IntrospectedTable)introspectedTable);
            JavaElementGeneratorTools.generateMethodBody(nextVersion, "obj." + setterMethod.getName() + "(version);", "return this;");
            FormatTools.addMethodWithBestPosition(builderClass, nextVersion);
        }
        return true;
    }

    @Override
    public boolean modelBuilderClassGenerated(TopLevelClass topLevelClass, InnerClass builderClass, List<IntrospectedColumn> columns, IntrospectedTable introspectedTable) {
        return true;
    }

    public boolean sqlMapDeleteByExampleElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            this.sqlMaps.get(introspectedTable).add(this.replaceExampleXmlElement(introspectedTable, element, METHOD_DELETE_WITH_VERSION_BY_EXAMPLE));
        }
        return super.sqlMapDeleteByExampleElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapDeleteByPrimaryKeyElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            this.sqlMaps.get(introspectedTable).add(this.replacePrimaryKeyXmlElement(introspectedTable, element, METHOD_DELETE_WITH_VERSION_BY_PRIMARY_KEY, false));
        }
        return super.sqlMapDeleteByPrimaryKeyElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByExampleSelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            this.sqlMaps.get(introspectedTable).add(this.generateSqlMapUpdate(introspectedTable, ListUtilities.removeGeneratedAlwaysColumns((List)introspectedTable.getAllColumns()), METHOD_UPDATE_WITH_VERSION_BY_EXAMPLE_SELECTIVE, true, true));
        }
        return super.sqlMapUpdateByExampleSelectiveElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByExampleWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            this.sqlMaps.get(introspectedTable).add(this.generateSqlMapUpdate(introspectedTable, ListUtilities.removeGeneratedAlwaysColumns((List)introspectedTable.getAllColumns()), METHOD_UPDATE_WITH_VERSION_BY_EXAMPLE_WITH_BLOBS, false, true));
        }
        return super.sqlMapUpdateByExampleWithBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            this.sqlMaps.get(introspectedTable).add(this.generateSqlMapUpdate(introspectedTable, ListUtilities.removeGeneratedAlwaysColumns((List)introspectedTable.getNonBLOBColumns()), METHOD_UPDATE_WITH_VERSION_BY_EXAMPLE_WITHOUT_BLOBS, false, true));
        }
        return super.sqlMapUpdateByExampleWithoutBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByPrimaryKeySelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            this.sqlMaps.get(introspectedTable).add(this.generateSqlMapUpdate(introspectedTable, ListUtilities.removeGeneratedAlwaysColumns((List)introspectedTable.getNonPrimaryKeyColumns()), METHOD_UPDATE_WITH_VERSION_BY_PRIMARY_KEY_SELECTIVE, true, false));
        }
        return super.sqlMapUpdateByPrimaryKeySelectiveElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            this.sqlMaps.get(introspectedTable).add(this.generateSqlMapUpdate(introspectedTable, ListUtilities.removeGeneratedAlwaysColumns((List)introspectedTable.getNonPrimaryKeyColumns()), METHOD_UPDATE_WITH_VERSION_BY_PRIMARY_KEY_WITH_BLOBS, false, false));
        }
        return super.sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            this.sqlMaps.get(introspectedTable).add(this.generateSqlMapUpdate(introspectedTable, ListUtilities.removeGeneratedAlwaysColumns((List)introspectedTable.getBaseColumns()), METHOD_UPDATE_WITH_VERSION_BY_PRIMARY_KEY_WITHOUT_BLOBS, false, false));
        }
        return super.sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            for (XmlElement element : this.sqlMaps.get(introspectedTable)) {
                FormatTools.addElementWithBestPosition(document.getRootElement(), element);
            }
        }
        return super.sqlMapDocumentGenerated(document, introspectedTable);
    }

    public boolean sqlMapExampleWhereClauseElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null && XmlElementTools.getAttribute(element, "id").getValue().equals("Update_By_Example_Where_Clause")) {
            XmlElement withVersionEle = new XmlElement("sql");
            withVersionEle.addAttribute(new Attribute("id", SQL_UPDATE_BY_EXAMPLE_WITH_VERSION_WHERE_CLAUSE));
            this.commentGenerator.addComment(withVersionEle);
            XmlElement whereEle = new XmlElement("where ");
            withVersionEle.addElement((Element)whereEle);
            whereEle.addElement((Element)new TextElement(this.generateVersionEleStr()));
            XmlElement ifEle = new XmlElement("if");
            whereEle.addElement((Element)ifEle);
            ifEle.addAttribute(new Attribute("test", "example.oredCriteria.size() > 0"));
            XmlElement foreachEle = (XmlElement)XmlElementTools.findXmlElements(element, "where").get(0).getElements().get(0);
            ifEle.addElement((Element)foreachEle);
            foreachEle.addAttribute(new Attribute("open", "and ("));
            foreachEle.addAttribute(new Attribute("close", ")"));
            this.sqlMaps.get(introspectedTable).add(withVersionEle);
            this.context.getPlugins().sqlMapExampleWhereClauseElementGenerated(withVersionEle, introspectedTable);
        }
        return super.sqlMapExampleWhereClauseElementGenerated(element, introspectedTable);
    }

    @Override
    public boolean sqlMapLogicalDeleteByExampleElementGenerated(Document document, XmlElement element, IntrospectedColumn logicalDeleteColumn, String logicalDeleteValue, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            FormatTools.addElementWithBestPosition(document.getRootElement(), this.generateSqlMapLogicalDelete(introspectedTable, METHOD_LOGICAL_DELETE_WITH_VERSION_BY_EXAMPLE, logicalDeleteColumn, logicalDeleteValue, true));
        }
        return true;
    }

    @Override
    public boolean sqlMapLogicalDeleteByPrimaryKeyElementGenerated(Document document, XmlElement element, IntrospectedColumn logicalDeleteColumn, String logicalDeleteValue, IntrospectedTable introspectedTable) {
        if (this.versionColumn != null) {
            FormatTools.addElementWithBestPosition(document.getRootElement(), this.generateSqlMapLogicalDelete(introspectedTable, METHOD_LOGICAL_DELETE_WITH_VERSION_BY_PRIMARY_KEY, logicalDeleteColumn, logicalDeleteValue, false));
        }
        return true;
    }

    @Override
    public boolean logicalDeleteEnumGenerated(IntrospectedColumn logicalDeleteColumn) {
        return false;
    }

    private String generateVersionEleStr() {
        StringBuilder sb = new StringBuilder();
        sb.append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)this.versionColumn));
        sb.append(" = ");
        sb.append("#{version,jdbcType=");
        sb.append(this.versionColumn.getJdbcTypeName());
        if (StringUtility.stringHasValue((String)this.versionColumn.getTypeHandler())) {
            sb.append(",typeHandler=");
            sb.append(this.versionColumn.getTypeHandler());
        }
        sb.append("}");
        return sb.toString();
    }

    private Method replaceUpdateExampleMethod(IntrospectedTable introspectedTable, Method method, Interface interfaze, String methodName) {
        Method withVersionMethod = new Method(method);
        withVersionMethod.setName(methodName);
        FormatTools.replaceGeneralMethodComment(this.commentGenerator, withVersionMethod, introspectedTable);
        Parameter versionParam = new Parameter(this.versionColumn.getFullyQualifiedJavaType(), "version", "@Param(\"version\")");
        withVersionMethod.addParameter(0, versionParam);
        return withVersionMethod;
    }

    private Method replaceDeleteExampleMethod(IntrospectedTable introspectedTable, Method method, Interface interfaze, String methodName) {
        Method withVersionMethod = new Method(method);
        withVersionMethod.setName(methodName);
        FormatTools.replaceGeneralMethodComment(this.commentGenerator, withVersionMethod, introspectedTable);
        Parameter versionParam = new Parameter(this.versionColumn.getFullyQualifiedJavaType(), "version", "@Param(\"version\")");
        Parameter exampleParam = new Parameter(new FullyQualifiedJavaType(introspectedTable.getExampleType()), "example", "@Param(\"example\")");
        withVersionMethod.getParameters().clear();
        withVersionMethod.addParameter(versionParam);
        withVersionMethod.addParameter(exampleParam);
        return withVersionMethod;
    }

    private Method replaceUpdatePrimaryKeyMethod(IntrospectedTable introspectedTable, Method method, Interface interfaze, String methodName) {
        Method withVersionMethod = new Method(method);
        withVersionMethod.setName(methodName);
        FormatTools.replaceGeneralMethodComment(this.commentGenerator, withVersionMethod, introspectedTable);
        Parameter versionParam = new Parameter(this.versionColumn.getFullyQualifiedJavaType(), "version", "@Param(\"version\")");
        Parameter recordParam = new Parameter(((Parameter)method.getParameters().get(0)).getType(), "record", "@Param(\"record\")");
        withVersionMethod.getParameters().clear();
        withVersionMethod.addParameter(versionParam);
        withVersionMethod.addParameter(recordParam);
        return withVersionMethod;
    }

    private Method replaceDeletePrimaryKeyMethod(IntrospectedTable introspectedTable, Method method, Interface interfaze, String methodName) {
        Method withVersionMethod = new Method(method);
        withVersionMethod.setName(methodName);
        FormatTools.replaceGeneralMethodComment(this.commentGenerator, withVersionMethod, introspectedTable);
        Parameter versionParam = new Parameter(this.versionColumn.getFullyQualifiedJavaType(), "version", "@Param(\"version\")");
        Parameter keyParam = new Parameter(((Parameter)method.getParameters().get(0)).getType(), ((Parameter)method.getParameters().get(0)).getName(), "@Param(\"key\")");
        withVersionMethod.getParameters().clear();
        withVersionMethod.addParameter(versionParam);
        withVersionMethod.addParameter(keyParam);
        return withVersionMethod;
    }

    private XmlElement replaceExampleXmlElement(IntrospectedTable introspectedTable, XmlElement element, String id) {
        XmlElement withVersionEle = XmlElementTools.clone(element);
        XmlElementTools.replaceAttribute(withVersionEle, new Attribute("id", id));
        XmlElementTools.replaceAttribute(withVersionEle, new Attribute("parameterType", "map"));
        FormatTools.replaceComment(this.commentGenerator, withVersionEle);
        List<XmlElement> ifEles = XmlElementTools.findXmlElements(withVersionEle, "if");
        for (XmlElement ifEle : ifEles) {
            List<XmlElement> includeEles = XmlElementTools.findXmlElements(ifEle, "include");
            for (XmlElement includeEle : includeEles) {
                if (XmlElementTools.getAttribute(includeEle, "refid") == null) continue;
                XmlElementTools.replaceAttribute(includeEle, new Attribute("refid", SQL_UPDATE_BY_EXAMPLE_WITH_VERSION_WHERE_CLAUSE));
            }
        }
        return withVersionEle;
    }

    private XmlElement replacePrimaryKeyXmlElement(IntrospectedTable introspectedTable, XmlElement element, String id, boolean update) {
        XmlElement withVersionEle = XmlElementTools.clone(element);
        XmlElementTools.replaceAttribute(withVersionEle, new Attribute("id", id));
        XmlElementTools.replaceAttribute(withVersionEle, new Attribute("parameterType", "map"));
        FormatTools.replaceComment(this.commentGenerator, withVersionEle);
        Iterator elementIterator = withVersionEle.getElements().iterator();
        boolean flag = false;
        while (elementIterator.hasNext()) {
            Element ele = (Element)elementIterator.next();
            if (ele instanceof TextElement && ((TextElement)ele).getContent().matches(".*where.*")) {
                flag = true;
            }
            if (!flag) continue;
            elementIterator.remove();
        }
        withVersionEle.addElement((Element)new TextElement("where " + this.generateVersionEleStr()));
        if (introspectedTable.getPrimaryKeyColumns().size() == 1) {
            IntrospectedColumn introspectedColumn = (IntrospectedColumn)introspectedTable.getPrimaryKeyColumns().get(0);
            StringBuilder sb = new StringBuilder();
            sb.append("  and ");
            sb.append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn));
            sb.append(" = ");
            if (update) {
                sb.append(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)"record."));
            } else {
                sb.append("#{key,jdbcType=");
                sb.append(introspectedColumn.getJdbcTypeName());
                if (StringUtility.stringHasValue((String)introspectedColumn.getTypeHandler())) {
                    sb.append(",typeHandler=");
                    sb.append(introspectedColumn.getTypeHandler());
                }
                sb.append("}");
            }
            withVersionEle.addElement((Element)new TextElement(sb.toString()));
        } else {
            for (IntrospectedColumn introspectedColumn : introspectedTable.getPrimaryKeyColumns()) {
                StringBuilder sb = new StringBuilder();
                sb.append("  and ");
                sb.append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn));
                sb.append(" = ");
                sb.append(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)(update ? "record." : "key.")));
                withVersionEle.addElement((Element)new TextElement(sb.toString()));
            }
        }
        return withVersionEle;
    }

    private XmlElement generateSqlMapUpdate(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, String id, boolean selective, boolean byExample) {
        Iterator<IntrospectedColumn> columnIterator = columns.iterator();
        while (columnIterator.hasNext()) {
            IntrospectedColumn introspectedColumn = columnIterator.next();
            if (!introspectedColumn.getActualColumnName().equals(this.versionColumn.getActualColumnName())) continue;
            columnIterator.remove();
        }
        XmlElement updateEle = new XmlElement("update");
        updateEle.addAttribute(new Attribute("id", id));
        updateEle.addAttribute(new Attribute("parameterType", "map"));
        this.commentGenerator.addComment(updateEle);
        updateEle.addElement((Element)new TextElement("update " + introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime()));
        if (selective) {
            XmlElement setEle = new XmlElement("set");
            updateEle.addElement((Element)setEle);
            XmlElement setsEle = XmlElementGeneratorTools.generateSetsSelective(columns, "record.");
            setEle.addElement((Element)setsEle);
            Object needVersionEle = PluginTools.getHook(IOptimisticLockerPluginHook.class).generateSetsSelectiveElement(columns, this.versionColumn, setsEle) ? setEle : setsEle;
            needVersionEle.addElement(0, (Element)this.generateVersionSetEle(selective));
        } else {
            updateEle.addElement((Element)this.generateVersionSetEle(selective));
            List<Element> setsEles = XmlElementGeneratorTools.generateSets(columns, "record.");
            for (Element ele : setsEles) {
                updateEle.addElement(ele);
            }
        }
        if (byExample) {
            XmlElement ifElement = new XmlElement("if");
            ifElement.addAttribute(new Attribute("test", "_parameter != null"));
            XmlElement includeElement = new XmlElement("include");
            includeElement.addAttribute(new Attribute("refid", SQL_UPDATE_BY_EXAMPLE_WITH_VERSION_WHERE_CLAUSE));
            ifElement.addElement((Element)includeElement);
            updateEle.addElement((Element)ifElement);
        } else {
            updateEle = this.replacePrimaryKeyXmlElement(introspectedTable, updateEle, id, true);
        }
        return updateEle;
    }

    private XmlElement generateSqlMapLogicalDelete(IntrospectedTable introspectedTable, String id, IntrospectedColumn logicalDeleteColumn, String logicalDeleteValue, boolean byExample) {
        XmlElement updateEle = new XmlElement("update");
        updateEle.addAttribute(new Attribute("id", id));
        updateEle.addAttribute(new Attribute("parameterType", "map"));
        this.commentGenerator.addComment(updateEle);
        updateEle.addElement((Element)new TextElement("update " + introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime()));
        StringBuilder sb = new StringBuilder("set ");
        if (this.customizedNextVersion) {
            sb.append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)this.versionColumn));
            sb.append(" = ");
            sb.append("#{nextVersion,jdbcType=");
            sb.append(this.versionColumn.getJdbcTypeName());
            if (StringUtility.stringHasValue((String)this.versionColumn.getTypeHandler())) {
                sb.append(",typeHandler=");
                sb.append(this.versionColumn.getTypeHandler());
            }
            sb.append("}");
        } else {
            sb.append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)this.versionColumn));
            sb.append(" = ");
            sb.append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)this.versionColumn));
            sb.append(" + 1");
        }
        sb.append(",");
        sb.append(logicalDeleteColumn.getActualColumnName());
        sb.append(" = ");
        sb.append(XmlElementGeneratorTools.generateLogicalDeleteColumnValue(logicalDeleteColumn, logicalDeleteValue));
        updateEle.addElement((Element)new TextElement(sb.toString()));
        if (byExample) {
            XmlElement ifElement = new XmlElement("if");
            ifElement.addAttribute(new Attribute("test", "_parameter != null"));
            XmlElement includeElement = new XmlElement("include");
            includeElement.addAttribute(new Attribute("refid", SQL_UPDATE_BY_EXAMPLE_WITH_VERSION_WHERE_CLAUSE));
            ifElement.addElement((Element)includeElement);
            updateEle.addElement((Element)ifElement);
        } else {
            updateEle = this.replacePrimaryKeyXmlElement(introspectedTable, updateEle, id, false);
        }
        return updateEle;
    }

    private TextElement generateVersionSetEle(boolean selective) {
        if (this.customizedNextVersion) {
            return new TextElement((selective ? "" : "set ") + MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)this.versionColumn) + " = " + MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)this.versionColumn, (String)"record.") + ",");
        }
        return new TextElement((selective ? "" : "set ") + MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)this.versionColumn) + " = " + MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)this.versionColumn) + " + 1,");
    }
}

