/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.ModelColumnPlugin;
import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import com.itfsw.mybatis.generator.plugins.utils.FormatTools;
import com.itfsw.mybatis.generator.plugins.utils.JavaElementGeneratorTools;
import com.itfsw.mybatis.generator.plugins.utils.PluginTools;
import com.itfsw.mybatis.generator.plugins.utils.enhanced.InnerInterfaceWrapperToInnerClass;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerInterface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;

public class ExampleEnhancedPlugin
extends BasePlugin {
    public static final String METHOD_NEW_AND_CREATE_CRITERIA = "newAndCreateCriteria";
    private boolean enableColumnOperate = false;

    @Override
    public void initialized(IntrospectedTable introspectedTable) {
        super.initialized(introspectedTable);
        this.enableColumnOperate = PluginTools.checkDependencyPlugin(this.context, ModelColumnPlugin.class);
    }

    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        List innerClasses = topLevelClass.getInnerClasses();
        for (int i = 0; i < innerClasses.size(); ++i) {
            InnerClass innerClass = (InnerClass)innerClasses.get(i);
            if ("Criteria".equals(innerClass.getType().getShortName())) {
                this.addFactoryMethodToCriteria(topLevelClass, innerClass, introspectedTable);
                this.addWhenToCriteria(topLevelClass, innerClass, introspectedTable);
                continue;
            }
            if (!"GeneratedCriteria".equals(innerClass.getType().getShortName()) || !this.enableColumnOperate) continue;
            this.addColumnMethodToCriteria(topLevelClass, innerClass, introspectedTable);
        }
        List methods = topLevelClass.getMethods();
        for (Method method : methods) {
            if (!"createCriteriaInternal".equals(method.getName())) continue;
            method.getBodyLines().set(0, "Criteria criteria = new Criteria(this);");
            logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u4fee\u6539createCriteriaInternal\u65b9\u6cd5\uff0c\u4fee\u6539\u6784\u9020Criteria\u65f6\u4f20\u5165Example\u5bf9\u8c61");
        }
        this.addOrderByMethodToExample(topLevelClass, introspectedTable);
        this.addStaticCreateCriteriaMethodToExample(topLevelClass, introspectedTable);
        this.addWhenToExample(topLevelClass, introspectedTable);
        this.addDistinctMethodToExample(topLevelClass, introspectedTable);
        return true;
    }

    private void addStaticCreateCriteriaMethodToExample(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        Method createCriteriaMethod = JavaElementGeneratorTools.generateMethod(METHOD_NEW_AND_CREATE_CRITERIA, JavaVisibility.PUBLIC, FullyQualifiedJavaType.getCriteriaInstance(), new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(createCriteriaMethod, introspectedTable);
        createCriteriaMethod.setStatic(true);
        createCriteriaMethod.addBodyLine(topLevelClass.getType().getShortName() + " example = new " + topLevelClass.getType().getShortName() + "();");
        createCriteriaMethod.addBodyLine("return example.createCriteria();");
        FormatTools.addMethodWithBestPosition(topLevelClass, createCriteriaMethod);
    }

    private void addColumnMethodToCriteria(TopLevelClass topLevelClass, InnerClass innerClass, IntrospectedTable introspectedTable) {
        topLevelClass.addImportedType(introspectedTable.getRules().calculateAllFieldsClass());
        for (IntrospectedColumn introspectedColumn : introspectedTable.getNonBLOBColumns()) {
            topLevelClass.addImportedType(introspectedColumn.getFullyQualifiedJavaType());
            FormatTools.addMethodWithBestPosition(innerClass, this.generateSingleValueMethod(introspectedTable, introspectedColumn, "EqualTo", "="));
            FormatTools.addMethodWithBestPosition(innerClass, this.generateSingleValueMethod(introspectedTable, introspectedColumn, "NotEqualTo", "<>"));
            FormatTools.addMethodWithBestPosition(innerClass, this.generateSingleValueMethod(introspectedTable, introspectedColumn, "GreaterThan", ">"));
            FormatTools.addMethodWithBestPosition(innerClass, this.generateSingleValueMethod(introspectedTable, introspectedColumn, "GreaterThanOrEqualTo", ">="));
            FormatTools.addMethodWithBestPosition(innerClass, this.generateSingleValueMethod(introspectedTable, introspectedColumn, "LessThan", "<"));
            FormatTools.addMethodWithBestPosition(innerClass, this.generateSingleValueMethod(introspectedTable, introspectedColumn, "LessThanOrEqualTo", "<="));
        }
    }

    private Method generateSingleValueMethod(IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn, String nameFragment, String operator) {
        StringBuilder sb = new StringBuilder();
        sb.append(introspectedColumn.getJavaProperty());
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        sb.insert(0, "and");
        sb.append(nameFragment);
        sb.append("Column");
        Method method = JavaElementGeneratorTools.generateMethod(sb.toString(), JavaVisibility.PUBLIC, FullyQualifiedJavaType.getCriteriaInstance(), new Parameter(new FullyQualifiedJavaType(introspectedTable.getRules().calculateAllFieldsClass().getShortName() + "." + "Column"), "column"));
        sb.setLength(0);
        sb.append("addCriterion(");
        sb.append("new StringBuilder(\"");
        sb.append(MyBatis3FormattingUtilities.getAliasedActualColumnName((IntrospectedColumn)introspectedColumn));
        sb.append(" ");
        sb.append(operator);
        sb.append(" \").append(");
        sb.append("column.");
        sb.append("getEscapedColumnName");
        sb.append("()).toString());");
        JavaElementGeneratorTools.generateMethodBody(method, sb.toString(), "return (Criteria) this;");
        return method;
    }

    private void addFactoryMethodToCriteria(TopLevelClass topLevelClass, InnerClass innerClass, IntrospectedTable introspectedTable) {
        Field exampleField = JavaElementGeneratorTools.generateField("example", JavaVisibility.PRIVATE, topLevelClass.getType(), null);
        this.commentGenerator.addFieldComment(exampleField, introspectedTable);
        innerClass.addField(exampleField);
        List methods = innerClass.getMethods();
        for (Method method : methods) {
            if (!method.isConstructor()) continue;
            method.addParameter(new Parameter(topLevelClass.getType(), "example"));
            method.addBodyLine("this.example = example;");
            this.commentGenerator.addGeneralMethodComment(method, introspectedTable);
            logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u4fee\u6539\u6784\u9020\u65b9\u6cd5\uff0c\u589e\u52a0example\u53c2\u6570");
        }
        Method exampleMethod = JavaElementGeneratorTools.generateMethod("example", JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter[0]);
        this.commentGenerator.addGeneralMethodComment(exampleMethod, introspectedTable);
        exampleMethod = JavaElementGeneratorTools.generateMethodBody(exampleMethod, "return this.example;");
        FormatTools.addMethodWithBestPosition(innerClass, exampleMethod);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "." + innerClass.getType().getShortName() + "\u589e\u52a0\u5de5\u5382\u65b9\u6cd5example");
    }

    private void addWhenToCriteria(TopLevelClass topLevelClass, InnerClass innerClass, IntrospectedTable introspectedTable) {
        this.addWhenToClass(topLevelClass, innerClass, introspectedTable, "criteria");
    }

    private void addWhenToExample(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addWhenToClass(topLevelClass, (InnerClass)topLevelClass, introspectedTable, "example");
    }

    private void addWhenToClass(TopLevelClass topLevelClass, InnerClass clazz, IntrospectedTable introspectedTable, String type) {
        InnerInterface whenInterface = new InnerInterface("I" + FormatTools.upFirstChar(type) + "When");
        whenInterface.setVisibility(JavaVisibility.PUBLIC);
        Method addMethod = JavaElementGeneratorTools.generateAbstractMethod(type, JavaVisibility.DEFAULT, null, new Parameter(clazz.getType(), type));
        this.commentGenerator.addGeneralMethodComment(addMethod, introspectedTable);
        whenInterface.addMethod(addMethod);
        this.commentGenerator.addClassComment((InnerClass)new InnerInterfaceWrapperToInnerClass(whenInterface), introspectedTable);
        topLevelClass.addInnerInterface(whenInterface);
        Method whenMethod = JavaElementGeneratorTools.generateMethod("when", JavaVisibility.PUBLIC, clazz.getType(), new Parameter(FullyQualifiedJavaType.getBooleanPrimitiveInstance(), "condition"), new Parameter(whenInterface.getType(), "then"));
        this.commentGenerator.addGeneralMethodComment(whenMethod, introspectedTable);
        whenMethod = JavaElementGeneratorTools.generateMethodBody(whenMethod, "if (condition) {", "then." + type + "(this);", "}", "return this;");
        FormatTools.addMethodWithBestPosition(clazz, whenMethod);
        Method whenOtherwiseMethod = JavaElementGeneratorTools.generateMethod("when", JavaVisibility.PUBLIC, clazz.getType(), new Parameter(FullyQualifiedJavaType.getBooleanPrimitiveInstance(), "condition"), new Parameter(whenInterface.getType(), "then"), new Parameter(whenInterface.getType(), "otherwise"));
        this.commentGenerator.addGeneralMethodComment(whenOtherwiseMethod, introspectedTable);
        whenOtherwiseMethod = JavaElementGeneratorTools.generateMethodBody(whenOtherwiseMethod, "if (condition) {", "then." + type + "(this);", "} else {", "otherwise." + type + "(this);", "}", "return this;");
        FormatTools.addMethodWithBestPosition(clazz, whenOtherwiseMethod);
    }

    private void addOrderByMethodToExample(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        Method orderByMethod = JavaElementGeneratorTools.generateMethod("orderBy", JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter(FullyQualifiedJavaType.getStringInstance(), "orderByClause"));
        this.commentGenerator.addGeneralMethodComment(orderByMethod, introspectedTable);
        orderByMethod = JavaElementGeneratorTools.generateMethodBody(orderByMethod, "this.setOrderByClause(orderByClause);", "return this;");
        FormatTools.addMethodWithBestPosition(topLevelClass, orderByMethod);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0\u65b9\u6cd5orderBy");
        Method orderByMethod1 = JavaElementGeneratorTools.generateMethod("orderBy", JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter(FullyQualifiedJavaType.getStringInstance(), "orderByClauses", true));
        this.commentGenerator.addGeneralMethodComment(orderByMethod1, introspectedTable);
        orderByMethod1 = JavaElementGeneratorTools.generateMethodBody(orderByMethod1, "StringBuffer sb = new StringBuffer();", "for (int i = 0; i < orderByClauses.length; i++) {", "sb.append(orderByClauses[i]);", "if (i < orderByClauses.length - 1) {", "sb.append(\" , \");", "}", "}", "this.setOrderByClause(sb.toString());", "return this;");
        FormatTools.addMethodWithBestPosition(topLevelClass, orderByMethod1);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0\u65b9\u6cd5orderBy(String ... orderByClauses)");
    }

    private void addDistinctMethodToExample(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        Method distinctMethod = JavaElementGeneratorTools.generateMethod("distinct", JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter(FullyQualifiedJavaType.getBooleanPrimitiveInstance(), "distinct"));
        this.commentGenerator.addGeneralMethodComment(distinctMethod, introspectedTable);
        distinctMethod = JavaElementGeneratorTools.generateMethodBody(distinctMethod, "this.setDistinct(distinct);", "return this;");
        FormatTools.addMethodWithBestPosition(topLevelClass, distinctMethod);
        logger.debug("itfsw(Example\u589e\u5f3a\u63d2\u4ef6):" + topLevelClass.getType().getShortName() + "\u589e\u52a0\u65b9\u6cd5distinct");
    }
}

