/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.ModelColumnPlugin;
import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import com.itfsw.mybatis.generator.plugins.utils.FormatTools;
import com.itfsw.mybatis.generator.plugins.utils.IntrospectedTableTools;
import com.itfsw.mybatis.generator.plugins.utils.JavaElementGeneratorTools;
import com.itfsw.mybatis.generator.plugins.utils.PluginTools;
import com.itfsw.mybatis.generator.plugins.utils.XmlElementGeneratorTools;
import com.itfsw.mybatis.generator.plugins.utils.XmlElementTools;
import com.itfsw.mybatis.generator.plugins.utils.hook.IIncrementPluginHook;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.VisitableElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;

public class IncrementPlugin
extends BasePlugin
implements IIncrementPluginHook {
    public static final String PRO_INCREMENT_COLUMNS = "incrementColumns";
    public static final String FIELD_INC_MAP = "incrementColumnsInfoMap";
    public static final String METHOD_INCREMENT = "increment";
    public static final String ENUM_INCREMENT = "Increment";
    public static final String CLASS_INCREMENT_ITEM = "Item";
    public static final String FIELD_COLUMN_FOR_CLASS_INCREMENT = "column";
    public static final String FIELD_VALUE_FOR_CLASS_INCREMENT = "value";
    public static final String FIELD_OPERATE_FOR_CLASS_INCREMENT = "operate";
    public static final String METHOD_INC = "inc";
    public static final String METHOD_DEC = "dec";
    private final Map<IntrospectedTable, List<IntrospectedColumn>> incColumnsMap = new HashMap<IntrospectedTable, List<IntrospectedColumn>>();

    @Override
    public boolean validate(List<String> warnings) {
        if (!PluginTools.checkDependencyPlugin(this.context, ModelColumnPlugin.class)) {
            warnings.add("itfsw:\u63d2\u4ef6" + this.getClass().getTypeName() + "\u63d2\u4ef6\u9700\u914d\u5408" + ModelColumnPlugin.class.getTypeName() + "\u63d2\u4ef6\u4f7f\u7528\uff01");
            return false;
        }
        return super.validate(warnings);
    }

    @Override
    public void initialized(IntrospectedTable introspectedTable) {
        super.initialized(introspectedTable);
        ArrayList<IntrospectedColumn> incColumns = new ArrayList<IntrospectedColumn>();
        String incrementColumns = introspectedTable.getTableConfigurationProperty(PRO_INCREMENT_COLUMNS);
        if (StringUtility.stringHasValue((String)incrementColumns)) {
            String[] incrementsColumnsStrs;
            for (String incrementsColumnsStr : incrementsColumnsStrs = incrementColumns.split(",")) {
                IntrospectedColumn column = IntrospectedTableTools.safeGetColumn(introspectedTable, incrementsColumnsStr);
                if (column == null) {
                    this.warnings.add("itfsw:\u63d2\u4ef6" + IncrementPlugin.class.getTypeName() + "\u63d2\u4ef6\u6ca1\u6709\u627e\u5230column\u4e3a" + incrementsColumnsStr.trim() + "\u7684\u5b57\u6bb5\uff01");
                    continue;
                }
                incColumns.add(column);
            }
        }
        if (!incColumns.isEmpty()) {
            this.incColumnsMap.put(introspectedTable, incColumns);
        }
    }

    public boolean sqlMapUpdateByExampleSelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithSelective(element, introspectedTable, true);
        return super.sqlMapUpdateByExampleSelectiveElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByExampleWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithoutSelective(element, introspectedTable, true);
        return super.sqlMapUpdateByExampleWithBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByExampleWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithoutSelective(element, introspectedTable, true);
        return super.sqlMapUpdateByExampleWithoutBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByPrimaryKeySelectiveElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithSelective(element, introspectedTable, false);
        return super.sqlMapUpdateByPrimaryKeySelectiveElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithoutSelective(element, introspectedTable, false);
        return super.sqlMapUpdateByPrimaryKeyWithBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(XmlElement element, IntrospectedTable introspectedTable) {
        this.generatedWithoutSelective(element, introspectedTable, false);
        return super.sqlMapUpdateByPrimaryKeyWithoutBLOBsElementGenerated(element, introspectedTable);
    }

    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generateIncrement(topLevelClass, introspectedTable);
        return super.modelBaseRecordClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generateIncrement(topLevelClass, introspectedTable);
        return super.modelRecordWithBLOBsClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.generateIncrement(topLevelClass, introspectedTable);
        return super.modelPrimaryKeyClassGenerated(topLevelClass, introspectedTable);
    }

    @Override
    public XmlElement generateIncrementSet(IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn, String prefix, boolean hasComma) {
        if (this.supportIncrement(introspectedTable, introspectedColumn)) {
            XmlElement choose = new XmlElement("choose");
            String columnMap = (prefix != null ? prefix : "_parameter.") + FIELD_INC_MAP + "." + introspectedColumn.getActualColumnName();
            XmlElement whenIncEle = new XmlElement("when");
            whenIncEle.addAttribute(new Attribute("test", columnMap + " != null"));
            TextElement spec = new TextElement(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + " = " + MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + " ${" + columnMap + "." + FIELD_OPERATE_FOR_CLASS_INCREMENT + "} " + XmlElementGeneratorTools.getParameterClause(columnMap + "." + FIELD_VALUE_FOR_CLASS_INCREMENT, introspectedColumn) + (hasComma ? "," : ""));
            whenIncEle.addElement((VisitableElement)spec);
            choose.addElement((VisitableElement)whenIncEle);
            XmlElement otherwiseEle = new XmlElement("otherwise");
            otherwiseEle.addElement((VisitableElement)new TextElement(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + " = " + MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix) + (hasComma ? "," : "")));
            choose.addElement((VisitableElement)otherwiseEle);
            return choose;
        }
        return null;
    }

    @Override
    public XmlElement generateIncrementSetSelective(IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn, String prefix) {
        if (this.supportIncrement(introspectedTable, introspectedColumn)) {
            XmlElement choose = new XmlElement("choose");
            String columnMap = (prefix != null ? prefix : "_parameter.") + FIELD_INC_MAP + "." + introspectedColumn.getActualColumnName();
            XmlElement whenIncEle = new XmlElement("when");
            whenIncEle.addAttribute(new Attribute("test", columnMap + " != null"));
            TextElement spec = new TextElement(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + " = " + MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + " ${" + columnMap + "." + FIELD_OPERATE_FOR_CLASS_INCREMENT + "} " + XmlElementGeneratorTools.getParameterClause(columnMap + "." + FIELD_VALUE_FOR_CLASS_INCREMENT, introspectedColumn) + ",");
            whenIncEle.addElement((VisitableElement)spec);
            choose.addElement((VisitableElement)whenIncEle);
            XmlElement whenEle = new XmlElement("when");
            whenEle.addAttribute(new Attribute("test", introspectedColumn.getJavaProperty(prefix) + " != null"));
            whenEle.addElement((VisitableElement)new TextElement(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + " = " + MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix) + ","));
            choose.addElement((VisitableElement)whenEle);
            return choose;
        }
        return null;
    }

    @Override
    public List<XmlElement> generateIncrementSetForSelectiveEnhancedPlugin(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns) {
        if (this.incColumnsMap.containsKey(introspectedTable)) {
            ArrayList<XmlElement> results = new ArrayList<XmlElement>();
            for (IntrospectedColumn incColumn : this.incColumnsMap.get(introspectedTable)) {
                for (IntrospectedColumn column : columns) {
                    if (!incColumn.getActualColumnName().equals(column.getActualColumnName())) continue;
                    XmlElement when = new XmlElement("when");
                    String columnMap = "row.incrementColumnsInfoMap." + MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)incColumn);
                    when.addAttribute(new Attribute("test", "'" + column.getActualColumnName() + "'.toString() == column.value and " + columnMap + " != null"));
                    when.addElement((VisitableElement)new TextElement("${column.escapedColumnName} = ${column.escapedColumnName} ${" + columnMap + "." + FIELD_OPERATE_FOR_CLASS_INCREMENT + "} " + XmlElementGeneratorTools.getParameterClause(columnMap + "." + FIELD_VALUE_FOR_CLASS_INCREMENT, incColumn)));
                    results.add(when);
                }
            }
            return results.isEmpty() ? null : results;
        }
        return null;
    }

    @Override
    public boolean supportIncrement(IntrospectedTable introspectedTable, IntrospectedColumn column) {
        if (this.incColumnsMap.containsKey(introspectedTable)) {
            for (IntrospectedColumn incColumn : this.incColumnsMap.get(introspectedTable)) {
                if (!incColumn.getActualColumnName().equals(column.getActualColumnName())) continue;
                return true;
            }
        }
        return false;
    }

    private void generateIncrement(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (this.incColumnsMap.containsKey(introspectedTable)) {
            this.addIncMethodToTopLevelClass(topLevelClass, introspectedTable);
            topLevelClass.addInnerEnum(this.generateIncrementEnum(topLevelClass, introspectedTable));
        }
    }

    private InnerEnum generateIncrementEnum(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        InnerEnum innerEnum = new InnerEnum(new FullyQualifiedJavaType(ENUM_INCREMENT));
        innerEnum.setVisibility(JavaVisibility.PUBLIC);
        innerEnum.setStatic(true);
        this.commentGenerator.addEnumComment(innerEnum, introspectedTable);
        Field columnField = new Field(FIELD_COLUMN_FOR_CLASS_INCREMENT, new FullyQualifiedJavaType("Column"));
        columnField.setVisibility(JavaVisibility.PRIVATE);
        columnField.setFinal(true);
        innerEnum.addField(columnField);
        Method constructor = new Method(ENUM_INCREMENT);
        constructor.setConstructor(true);
        constructor.addBodyLine("this.column = column;");
        constructor.addParameter(new Parameter(new FullyQualifiedJavaType("Column"), FIELD_COLUMN_FOR_CLASS_INCREMENT));
        FormatTools.addMethodWithBestPosition(innerEnum, constructor);
        innerEnum.addMethod(JavaElementGeneratorTools.generateGetterMethod(columnField));
        Method mInc = JavaElementGeneratorTools.generateMethod(METHOD_INC, JavaVisibility.PUBLIC, new FullyQualifiedJavaType("Increment.Item"), new Parameter(FullyQualifiedJavaType.getObjectInstance(), FIELD_VALUE_FOR_CLASS_INCREMENT));
        mInc.addBodyLine("return new Increment.Item(this.column, \"+\", value);");
        innerEnum.addMethod(mInc);
        Method mDec = JavaElementGeneratorTools.generateMethod(METHOD_DEC, JavaVisibility.PUBLIC, new FullyQualifiedJavaType("Increment.Item"), new Parameter(FullyQualifiedJavaType.getObjectInstance(), FIELD_VALUE_FOR_CLASS_INCREMENT));
        mDec.addBodyLine("return new Increment.Item(this.column, \"-\", value);");
        innerEnum.addMethod(mDec);
        for (IntrospectedColumn introspectedColumn : this.incColumnsMap.get(introspectedTable)) {
            Field field = JavaBeansUtil.getJavaBeansField((IntrospectedColumn)introspectedColumn, (Context)this.context, (IntrospectedTable)introspectedTable);
            String sb = field.getName() + "(" + "Column" + "." + field.getName() + ")";
            innerEnum.addEnumConstant(sb);
        }
        innerEnum.addInnerClass(this.generateIncrementItemClass(introspectedTable));
        return innerEnum;
    }

    private void addIncMethodToTopLevelClass(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        Field fIncrements = JavaElementGeneratorTools.generateField(FIELD_INC_MAP, JavaVisibility.PROTECTED, new FullyQualifiedJavaType("Map<String, Object>"), "new HashMap<>()");
        fIncrements.setFinal(true);
        this.commentGenerator.addFieldComment(fIncrements, introspectedTable);
        topLevelClass.addField(fIncrements);
        topLevelClass.addImportedType("java.util.Map");
        topLevelClass.addImportedType("java.util.HashMap");
        topLevelClass.addImportedType("java.util.Arrays");
        Method mIncrement = JavaElementGeneratorTools.generateMethod(METHOD_INCREMENT, JavaVisibility.PUBLIC, topLevelClass.getType(), new Parameter(new FullyQualifiedJavaType("Increment.Item"), METHOD_INCREMENT));
        this.commentGenerator.addGeneralMethodComment(mIncrement, introspectedTable);
        mIncrement.addBodyLine("this.incrementColumnsInfoMap.put(increment.getColumn().value(), increment);");
        mIncrement.addBodyLine("return this;");
        FormatTools.addMethodWithBestPosition(topLevelClass, mIncrement);
    }

    private void generatedWithSelective(XmlElement element, IntrospectedTable introspectedTable, boolean hasPrefix) {
        List<XmlElement> ifs;
        List<XmlElement> sets;
        if (this.incColumnsMap.containsKey(introspectedTable) && !(sets = XmlElementTools.findXmlElements(element, "set")).isEmpty() && !(ifs = XmlElementTools.findXmlElements(sets.get(0), "if")).isEmpty()) {
            for (XmlElement xmlElement : ifs) {
                List textEles = xmlElement.getElements();
                TextElement textEle = (TextElement)textEles.get(0);
                String[] strs = textEle.getContent().split("=");
                String columnName = strs[0].trim();
                IntrospectedColumn introspectedColumn = IntrospectedTableTools.safeGetColumn(introspectedTable, columnName);
                if (!this.supportIncrement(introspectedTable, introspectedColumn)) continue;
                XmlElementTools.replaceXmlElement(xmlElement, PluginTools.getHook(IIncrementPluginHook.class).generateIncrementSetSelective(introspectedTable, introspectedColumn, hasPrefix ? "row." : null));
            }
        }
    }

    private void generatedWithoutSelective(XmlElement xmlElement, IntrospectedTable introspectedTable, boolean hasPrefix) {
        for (int i = 0; i < xmlElement.getElements().size(); ++i) {
            String columnName;
            IntrospectedColumn introspectedColumn;
            String text;
            VisitableElement ele = (VisitableElement)xmlElement.getElements().get(i);
            if (!(ele instanceof TextElement) || !(text = ((TextElement)ele).getContent().trim()).matches("(^set\\s)?\\S+\\s?=.*") || !this.supportIncrement(introspectedTable, introspectedColumn = IntrospectedTableTools.safeGetColumn(introspectedTable, columnName = (text = text.replaceFirst("^set\\s", "").trim()).split("=")[0].trim()))) continue;
            xmlElement.getElements().set(i, PluginTools.getHook(IIncrementPluginHook.class).generateIncrementSet(introspectedTable, introspectedColumn, hasPrefix ? "row." : null, text.endsWith(",")));
        }
    }

    private InnerClass generateIncrementItemClass(IntrospectedTable introspectedTable) {
        InnerClass incCls = new InnerClass(CLASS_INCREMENT_ITEM);
        this.commentGenerator.addClassComment(incCls, introspectedTable);
        Field columnField = new Field(FIELD_COLUMN_FOR_CLASS_INCREMENT, new FullyQualifiedJavaType("Column"));
        columnField.setVisibility(JavaVisibility.PRIVATE);
        Field operateField = new Field(FIELD_OPERATE_FOR_CLASS_INCREMENT, FullyQualifiedJavaType.getStringInstance());
        operateField.setVisibility(JavaVisibility.PRIVATE);
        Field valueField = new Field(FIELD_VALUE_FOR_CLASS_INCREMENT, FullyQualifiedJavaType.getObjectInstance());
        valueField.setVisibility(JavaVisibility.PRIVATE);
        incCls.addField(columnField);
        incCls.addField(operateField);
        incCls.addField(valueField);
        incCls.addMethod(JavaElementGeneratorTools.generateGetterMethod(columnField));
        incCls.addMethod(JavaElementGeneratorTools.generateGetterMethod(operateField));
        incCls.addMethod(JavaElementGeneratorTools.generateGetterMethod(valueField));
        Method mConstructor = JavaElementGeneratorTools.generateMethod(CLASS_INCREMENT_ITEM, JavaVisibility.PUBLIC, incCls.getType(), new Parameter(columnField.getType(), FIELD_COLUMN_FOR_CLASS_INCREMENT), new Parameter(operateField.getType(), FIELD_OPERATE_FOR_CLASS_INCREMENT), new Parameter(valueField.getType(), FIELD_VALUE_FOR_CLASS_INCREMENT));
        mConstructor.setConstructor(true);
        mConstructor.addBodyLine("this.column = column;");
        mConstructor.addBodyLine("this.operate = operate;");
        mConstructor.addBodyLine("this.value = value;");
        incCls.addMethod(mConstructor);
        return incCls;
    }
}

