/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils;

import com.itfsw.mybatis.generator.plugins.utils.IntrospectedTableTools;
import com.itfsw.mybatis.generator.plugins.utils.PluginTools;
import com.itfsw.mybatis.generator.plugins.utils.hook.IIncrementPluginHook;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.OutputUtilities;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.VisitableElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.config.GeneratedKey;
import org.mybatis.generator.internal.util.StringUtility;

public class XmlElementGeneratorTools {
    public static VisitableElement getSelectKey(IntrospectedColumn introspectedColumn, GeneratedKey generatedKey) {
        return XmlElementGeneratorTools.getSelectKey(introspectedColumn, generatedKey, null);
    }

    public static VisitableElement getSelectKey(IntrospectedColumn introspectedColumn, GeneratedKey generatedKey, String prefix) {
        String identityColumnType = introspectedColumn.getFullyQualifiedJavaType().getFullyQualifiedName();
        XmlElement answer = new XmlElement("selectKey");
        answer.addAttribute(new Attribute("resultType", identityColumnType));
        answer.addAttribute(new Attribute("keyProperty", (prefix == null ? "" : prefix) + introspectedColumn.getJavaProperty()));
        answer.addAttribute(new Attribute("order", generatedKey.getMyBatis3Order()));
        answer.addElement((VisitableElement)new TextElement(generatedKey.getRuntimeSqlStatement()));
        return answer;
    }

    public static VisitableElement getBaseColumnListElement(IntrospectedTable introspectedTable) {
        XmlElement answer = new XmlElement("include");
        answer.addAttribute(new Attribute("refid", introspectedTable.getBaseColumnListId()));
        return answer;
    }

    public static VisitableElement getBlobColumnListElement(IntrospectedTable introspectedTable) {
        XmlElement answer = new XmlElement("include");
        answer.addAttribute(new Attribute("refid", introspectedTable.getBlobColumnListId()));
        return answer;
    }

    public static VisitableElement getExampleIncludeElement(IntrospectedTable introspectedTable) {
        XmlElement ifElement = new XmlElement("if");
        ifElement.addAttribute(new Attribute("test", "_parameter != null"));
        XmlElement includeElement = new XmlElement("include");
        includeElement.addAttribute(new Attribute("refid", introspectedTable.getExampleWhereClauseId()));
        ifElement.addElement((VisitableElement)includeElement);
        return ifElement;
    }

    public static VisitableElement getUpdateByExampleIncludeElement(IntrospectedTable introspectedTable) {
        XmlElement ifElement = new XmlElement("if");
        ifElement.addAttribute(new Attribute("test", "_parameter != null"));
        XmlElement includeElement = new XmlElement("include");
        includeElement.addAttribute(new Attribute("refid", introspectedTable.getMyBatis3UpdateByExampleWhereClauseId()));
        ifElement.addElement((VisitableElement)includeElement);
        return ifElement;
    }

    public static void useGeneratedKeys(XmlElement element, IntrospectedTable introspectedTable) {
        XmlElementGeneratorTools.useGeneratedKeys(element, introspectedTable, null);
    }

    public static void useGeneratedKeys(XmlElement element, IntrospectedTable introspectedTable, String prefix) {
        IntrospectedColumn introspectedColumn;
        Optional generatedKeyOptional = introspectedTable.getGeneratedKey();
        if (generatedKeyOptional.isPresent() && (introspectedColumn = IntrospectedTableTools.safeGetColumn(introspectedTable, ((GeneratedKey)generatedKeyOptional.get()).getColumn())) != null) {
            element.addAttribute(new Attribute("useGeneratedKeys", "true"));
            element.addAttribute(new Attribute("keyProperty", (prefix == null ? "" : prefix) + introspectedColumn.getJavaProperty()));
            element.addAttribute(new Attribute("keyColumn", introspectedColumn.getActualColumnName()));
        }
    }

    public static List<VisitableElement> generateKeys(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateKeys(introspectedTable, columns, false);
    }

    public static List<VisitableElement> generateKeys(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumns(introspectedTable, columns, null, bracket, 1);
    }

    public static XmlElement generateKeysSelective(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateKeysSelective(introspectedTable, columns, null);
    }

    public static XmlElement generateKeysSelective(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateKeysSelective(introspectedTable, columns, prefix, true);
    }

    public static XmlElement generateKeysSelective(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, String prefix, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumnsSelective(introspectedTable, columns, prefix, bracket, 1);
    }

    public static List<VisitableElement> generateValues(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateValues(introspectedTable, columns, null);
    }

    public static List<VisitableElement> generateValues(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateValues(introspectedTable, columns, prefix, true);
    }

    public static List<VisitableElement> generateValues(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, String prefix, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumns(introspectedTable, columns, prefix, bracket, 2);
    }

    public static XmlElement generateValuesSelective(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateValuesSelective(introspectedTable, columns, null);
    }

    public static XmlElement generateValuesSelective(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateValuesSelective(introspectedTable, columns, prefix, true);
    }

    public static XmlElement generateValuesSelective(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, String prefix, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumnsSelective(introspectedTable, columns, prefix, bracket, 2);
    }

    public static List<VisitableElement> generateSets(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateSets(introspectedTable, columns, null);
    }

    public static List<VisitableElement> generateSets(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateCommColumns(introspectedTable, columns, prefix, false, 3);
    }

    public static XmlElement generateSetsSelective(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns) {
        return XmlElementGeneratorTools.generateSetsSelective(introspectedTable, columns, null);
    }

    public static XmlElement generateSetsSelective(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateCommColumnsSelective(introspectedTable, columns, prefix, false, 3);
    }

    public static List<VisitableElement> generateUpsertKeys(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateCommColumns(introspectedTable, columns, prefix, true, 1, true);
    }

    public static List<VisitableElement> generateUpsertValues(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, String prefix, boolean bracket) {
        return XmlElementGeneratorTools.generateCommColumns(introspectedTable, columns, prefix, bracket, 2, true);
    }

    public static List<VisitableElement> generateUpsertSets(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, String prefix) {
        return XmlElementGeneratorTools.generateCommColumns(introspectedTable, columns, prefix, false, 3, true);
    }

    private static List<VisitableElement> generateCommColumns(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, String prefix, boolean bracket, int type) {
        return XmlElementGeneratorTools.generateCommColumns(introspectedTable, columns, prefix, bracket, type, false);
    }

    private static List<VisitableElement> generateCommColumns(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, String prefix, boolean bracket, int type, boolean upsert) {
        ArrayList<VisitableElement> list = new ArrayList<VisitableElement>();
        if (upsert && XmlElementGeneratorTools.hasIdentityAndGeneratedAlwaysColumns(columns)) {
            XmlElement trimEle = XmlElementGeneratorTools.generateTrim(bracket);
            for (IntrospectedColumn introspectedColumn : columns) {
                if (introspectedColumn.isGeneratedAlways() || introspectedColumn.isIdentity()) {
                    XmlElementGeneratorTools.generateSelectiveToTrimEleTo(introspectedTable, trimEle, introspectedColumn, prefix, type);
                    continue;
                }
                if (type == 3 && PluginTools.getHook(IIncrementPluginHook.class).generateIncrementSetSelective(introspectedTable, introspectedColumn, prefix) != null) {
                    trimEle.addElement((VisitableElement)PluginTools.getHook(IIncrementPluginHook.class).generateIncrementSetSelective(introspectedTable, introspectedColumn, prefix));
                    continue;
                }
                XmlElementGeneratorTools.generateSelectiveCommColumnTo(trimEle, introspectedColumn, prefix, type);
            }
            return Collections.singletonList(trimEle);
        }
        StringBuilder sb = new StringBuilder(bracket ? "(" : "");
        Iterator<IntrospectedColumn> columnIterator = columns.iterator();
        while (columnIterator.hasNext()) {
            IntrospectedColumn introspectedColumn = columnIterator.next();
            switch (type) {
                case 3: {
                    XmlElement incrementEle = PluginTools.getHook(IIncrementPluginHook.class).generateIncrementSet(introspectedTable, introspectedColumn, prefix, false);
                    if (incrementEle != null) {
                        if (sb.length() > 0) {
                            list.add((VisitableElement)new TextElement(sb.toString()));
                            sb.setLength(0);
                        }
                        list.add((VisitableElement)incrementEle);
                        break;
                    }
                    sb.append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn));
                    sb.append(" = ");
                    sb.append(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix));
                    break;
                }
                case 2: {
                    sb.append(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix));
                    break;
                }
                case 1: {
                    sb.append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn));
                }
            }
            if (columnIterator.hasNext()) {
                sb.append(", ");
            }
            if (type == 1 || type == 2) {
                if (sb.length() <= 80) continue;
                list.add((VisitableElement)new TextElement(sb.toString()));
                sb.setLength(0);
                OutputUtilities.xmlIndent((StringBuilder)sb, (int)1);
                continue;
            }
            list.add((VisitableElement)new TextElement(sb.toString()));
            sb.setLength(0);
        }
        if (sb.length() > 0 || bracket) {
            list.add((VisitableElement)new TextElement(sb.append(bracket ? ")" : "").toString()));
        }
        return list;
    }

    private static XmlElement generateCommColumnsSelective(IntrospectedTable introspectedTable, List<IntrospectedColumn> columns, String prefix, boolean bracket, int type) {
        XmlElement trimEle = XmlElementGeneratorTools.generateTrim(bracket);
        for (IntrospectedColumn introspectedColumn : columns) {
            XmlElementGeneratorTools.generateSelectiveToTrimEleTo(introspectedTable, trimEle, introspectedColumn, prefix, type);
        }
        return trimEle;
    }

    private static XmlElement generateTrim(boolean bracket) {
        XmlElement trimEle = new XmlElement("trim");
        if (bracket) {
            trimEle.addAttribute(new Attribute("prefix", "("));
            trimEle.addAttribute(new Attribute("suffix", ")"));
            trimEle.addAttribute(new Attribute("suffixOverrides", ","));
        } else {
            trimEle.addAttribute(new Attribute("suffixOverrides", ","));
        }
        return trimEle;
    }

    private static void generateSelectiveToTrimEleTo(IntrospectedTable introspectedTable, XmlElement trimEle, IntrospectedColumn introspectedColumn, String prefix, int type) {
        if (type != 3 && (introspectedColumn.isSequenceColumn() || introspectedColumn.getFullyQualifiedJavaType().isPrimitive())) {
            XmlElementGeneratorTools.generateSelectiveCommColumnTo(trimEle, introspectedColumn, prefix, type);
        } else if (type == 3 && PluginTools.getHook(IIncrementPluginHook.class).generateIncrementSetSelective(introspectedTable, introspectedColumn, prefix) != null) {
            trimEle.addElement((VisitableElement)PluginTools.getHook(IIncrementPluginHook.class).generateIncrementSetSelective(introspectedTable, introspectedColumn, prefix));
        } else {
            XmlElement eleIf = new XmlElement("if");
            eleIf.addAttribute(new Attribute("test", introspectedColumn.getJavaProperty(prefix) + " != null"));
            XmlElementGeneratorTools.generateSelectiveCommColumnTo(eleIf, introspectedColumn, prefix, type);
            trimEle.addElement((VisitableElement)eleIf);
        }
    }

    private static void generateSelectiveCommColumnTo(XmlElement element, IntrospectedColumn introspectedColumn, String prefix, int type) {
        switch (type) {
            case 3: {
                element.addElement((VisitableElement)new TextElement(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + " = " + MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix) + ","));
                break;
            }
            case 2: {
                element.addElement((VisitableElement)new TextElement(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix) + ","));
                break;
            }
            case 1: {
                element.addElement((VisitableElement)new TextElement(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn) + ","));
            }
        }
    }

    public static void generateWhereByPrimaryKeyTo(XmlElement element, List<IntrospectedColumn> primaryKeyColumns) {
        XmlElementGeneratorTools.generateWhereByPrimaryKeyTo(element, primaryKeyColumns, null);
    }

    public static void generateWhereByPrimaryKeyTo(XmlElement element, List<IntrospectedColumn> primaryKeyColumns, String prefix) {
        StringBuilder sb = new StringBuilder();
        boolean and = false;
        for (IntrospectedColumn introspectedColumn : primaryKeyColumns) {
            sb.setLength(0);
            if (and) {
                sb.append("  and ");
            } else {
                sb.append("where ");
                and = true;
            }
            sb.append(MyBatis3FormattingUtilities.getEscapedColumnName((IntrospectedColumn)introspectedColumn));
            sb.append(" = ");
            sb.append(MyBatis3FormattingUtilities.getParameterClause((IntrospectedColumn)introspectedColumn, (String)prefix));
            element.addElement((VisitableElement)new TextElement(sb.toString()));
        }
    }

    private static boolean hasIdentityAndGeneratedAlwaysColumns(List<IntrospectedColumn> columns) {
        for (IntrospectedColumn ic : columns) {
            if (!ic.isGeneratedAlways() && !ic.isIdentity()) continue;
            return true;
        }
        return false;
    }

    public static XmlElement generateResultMapResultElement(String name, IntrospectedColumn introspectedColumn) {
        XmlElement resultElement = new XmlElement(name);
        resultElement.addAttribute(new Attribute("column", MyBatis3FormattingUtilities.getRenamedColumnNameForResultMap((IntrospectedColumn)introspectedColumn)));
        resultElement.addAttribute(new Attribute("property", introspectedColumn.getJavaProperty()));
        resultElement.addAttribute(new Attribute("jdbcType", introspectedColumn.getJdbcTypeName()));
        if (StringUtility.stringHasValue((String)introspectedColumn.getTypeHandler())) {
            resultElement.addAttribute(new Attribute("typeHandler", introspectedColumn.getTypeHandler()));
        }
        return resultElement;
    }

    public static String generateLogicalDeleteColumnValue(IntrospectedColumn logicalDeleteColumn, String value) {
        StringBuilder sb = new StringBuilder();
        if (value == null || "NULL".equalsIgnoreCase(value)) {
            sb.append("NULL");
        } else if (logicalDeleteColumn.isStringColumn()) {
            sb.append("'");
            sb.append(value);
            sb.append("'");
        } else if (logicalDeleteColumn.getFullyQualifiedJavaType().getFullyQualifiedName().equals(Long.class.getName())) {
            sb.append(value.replaceAll("[Ll]", ""));
        } else if (logicalDeleteColumn.getFullyQualifiedJavaType().getFullyQualifiedName().equals(Float.class.getName())) {
            sb.append(value.replaceAll("[Ff]", ""));
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    public static String getParameterClause(String valueStr, IntrospectedColumn introspectedColumn) {
        StringBuilder sb = new StringBuilder();
        sb.append("#{");
        sb.append(valueStr);
        sb.append(",jdbcType=");
        sb.append(introspectedColumn.getJdbcTypeName());
        if (StringUtility.stringHasValue((String)introspectedColumn.getTypeHandler())) {
            sb.append(",typeHandler=");
            sb.append(introspectedColumn.getTypeHandler());
        }
        sb.append('}');
        return sb.toString();
    }
}

