/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.util.StringUtility;

public class IntrospectedTableTools {
    public static void setDomainObjectName(IntrospectedTable introspectedTable, Context context, String domainObjectName) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        introspectedTable.getTableConfiguration().setDomainObjectName(domainObjectName);
        Field domainObjectNameField = FullyQualifiedTable.class.getDeclaredField("domainObjectName");
        domainObjectNameField.setAccessible(true);
        domainObjectNameField.set(introspectedTable.getFullyQualifiedTable(), domainObjectName);
        Method calculateJavaClientAttributes = IntrospectedTable.class.getDeclaredMethod("calculateJavaClientAttributes", new Class[0]);
        calculateJavaClientAttributes.setAccessible(true);
        calculateJavaClientAttributes.invoke((Object)introspectedTable, new Object[0]);
        Method calculateModelAttributes = IntrospectedTable.class.getDeclaredMethod("calculateModelAttributes", new Class[0]);
        calculateModelAttributes.setAccessible(true);
        calculateModelAttributes.invoke((Object)introspectedTable, new Object[0]);
        Method calculateXmlAttributes = IntrospectedTable.class.getDeclaredMethod("calculateXmlAttributes", new Class[0]);
        calculateXmlAttributes.setAccessible(true);
        calculateXmlAttributes.invoke((Object)introspectedTable, new Object[0]);
    }

    public static IntrospectedColumn safeGetColumn(IntrospectedTable introspectedTable, String columnName) {
        String endingDelimiter;
        columnName = columnName.trim();
        String beginningDelimiter = introspectedTable.getContext().getBeginningDelimiter();
        if (StringUtility.stringHasValue((String)beginningDelimiter)) {
            columnName = columnName.replaceFirst("^" + beginningDelimiter, "");
        }
        if (StringUtility.stringHasValue((String)(endingDelimiter = introspectedTable.getContext().getEndingDelimiter()))) {
            columnName = columnName.replaceFirst(endingDelimiter + "$", "");
        }
        if (introspectedTable.getColumn(columnName).isPresent()) {
            return (IntrospectedColumn)introspectedTable.getColumn(columnName).get();
        }
        return null;
    }

    public static List<IntrospectedColumn> getModelBaseRecordColumns(IntrospectedTable introspectedTable) {
        List introspectedColumns = IntrospectedTableTools.includePrimaryKeyColumns(introspectedTable) ? (IntrospectedTableTools.includeBLOBColumns(introspectedTable) ? introspectedTable.getAllColumns() : introspectedTable.getNonBLOBColumns()) : (IntrospectedTableTools.includeBLOBColumns(introspectedTable) ? introspectedTable.getNonPrimaryKeyColumns() : introspectedTable.getBaseColumns());
        return introspectedColumns;
    }

    public static boolean includePrimaryKeyColumns(IntrospectedTable introspectedTable) {
        return !introspectedTable.getRules().generatePrimaryKeyClass() && introspectedTable.hasPrimaryKeyColumns();
    }

    public static boolean includeBLOBColumns(IntrospectedTable introspectedTable) {
        return !introspectedTable.getRules().generateRecordWithBLOBsClass() && introspectedTable.hasBLOBColumns();
    }
}

