/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils.enhanced;

import com.itfsw.mybatis.generator.plugins.utils.enhanced.InnerInterfaceWrapperToInnerClass;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.InnerEnum;
import org.mybatis.generator.api.dom.java.InnerInterface;
import org.mybatis.generator.api.dom.java.JavaElement;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.VisitableElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.config.CommentGeneratorConfiguration;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateCommentGenerator
implements CommentGenerator {
    protected static final Logger logger = LoggerFactory.getLogger(TemplateCommentGenerator.class);
    private final Map<EnumNode, Template> templates = new HashMap<EnumNode, Template>();
    private boolean suppressDate = false;
    private boolean suppressAllComments = false;

    public TemplateCommentGenerator(Context context, String templatePath) {
        try {
            CommentGeneratorConfiguration config;
            Document doc = null;
            File file = new File(templatePath);
            if (file.exists()) {
                doc = new SAXReader().read(file);
            } else {
                logger.error("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6ce8\u91ca\u6a21\u677f:" + templatePath);
            }
            if (doc != null) {
                for (EnumNode node : EnumNode.values()) {
                    Element element = doc.getRootElement().elementByID(node.value());
                    if (element == null) continue;
                    Configuration cfg = new Configuration(Configuration.VERSION_2_3_26);
                    Template template = new Template(node.value(), element.getText(), cfg);
                    this.templates.put(node, template);
                }
            }
            if ((config = context.getCommentGeneratorConfiguration()) != null) {
                this.addConfigurationProperties(config.getProperties());
            }
        }
        catch (Exception e) {
            logger.error("\u6ce8\u91ca\u6a21\u677fXML\u89e3\u6790\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    private String[] getComments(Map<String, Object> map, EnumNode node) {
        try {
            StringWriter stringWriter = new StringWriter();
            Template template = this.templates.get((Object)node);
            if (template != null) {
                template.process(map, (Writer)stringWriter);
                String comment = stringWriter.toString();
                stringWriter.close();
                return comment.replaceFirst("^[\\s\\t\\r\\n]*", "").replaceFirst("[\\s\\t\\r\\n]*$", "").split("\n");
            }
        }
        catch (Exception e) {
            logger.error("freemarker \u89e3\u6790\u5931\u8d25\uff01", (Throwable)e);
        }
        return null;
    }

    private void addJavaElementComment(JavaElement javaElement, Map<String, Object> map, EnumNode node) {
        if (this.suppressAllComments) {
            return;
        }
        String[] comments = this.getComments(map, node);
        if (comments != null) {
            if (comments.length == 1 && !StringUtility.stringHasValue((String)comments[0])) {
                return;
            }
            for (String comment : comments) {
                javaElement.addJavaDocLine(comment);
            }
        }
    }

    private void addCompilationUnitComment(CompilationUnit compilationUnit, Map<String, Object> map) {
        if (this.suppressAllComments) {
            return;
        }
        String[] comments = this.getComments(map, EnumNode.ADD_JAVA_FILE_COMMENT);
        if (comments != null) {
            if (comments.length == 1 && !StringUtility.stringHasValue((String)comments[0])) {
                return;
            }
            for (String comment : comments) {
                compilationUnit.addFileCommentLine(comment);
            }
        }
    }

    private void addXmlElementComment(XmlElement xmlElement, Map<String, Object> map, EnumNode node) {
        if (this.suppressAllComments) {
            return;
        }
        String[] comments = this.getComments(map, node);
        if (comments != null) {
            if (comments.length == 1 && !StringUtility.stringHasValue((String)comments[0])) {
                return;
            }
            for (String comment : comments) {
                xmlElement.addElement((VisitableElement)new TextElement(comment));
            }
        }
    }

    public void addConfigurationProperties(Properties properties) {
        this.suppressDate = StringUtility.isTrue((String)properties.getProperty("suppressDate"));
        this.suppressAllComments = StringUtility.isTrue((String)properties.getProperty("suppressAllComments"));
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mgb", "@mbg.generated");
        map.put("field", field);
        map.put("introspectedTable", introspectedTable);
        map.put("introspectedColumn", introspectedColumn);
        this.addJavaElementComment((JavaElement)field, map, EnumNode.ADD_FIELD_COMMENT);
    }

    public void addFieldComment(Field field, IntrospectedTable introspectedTable) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mgb", "@mbg.generated");
        map.put("field", field);
        map.put("introspectedTable", introspectedTable);
        this.addJavaElementComment((JavaElement)field, map, EnumNode.ADD_FIELD_COMMENT);
    }

    public void addModelClassComment(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mgb", "@mbg.generated");
        map.put("topLevelClass", topLevelClass);
        map.put("introspectedTable", introspectedTable);
        this.addJavaElementComment((JavaElement)topLevelClass, map, EnumNode.ADD_MODEL_CLASS_COMMENT);
    }

    public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable) {
        if (innerClass instanceof InnerInterfaceWrapperToInnerClass) {
            InnerInterface innerInterface = ((InnerInterfaceWrapperToInnerClass)innerClass).getInnerInterface();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("mgb", "@mbg.generated");
            map.put("innerInterface", innerInterface);
            map.put("introspectedTable", introspectedTable);
            this.addJavaElementComment((JavaElement)innerInterface, map, EnumNode.ADD_INTERFACE_COMMENT);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("mgb", "@mbg.generated");
            map.put("innerClass", innerClass);
            map.put("introspectedTable", introspectedTable);
            this.addJavaElementComment((JavaElement)innerClass, map, EnumNode.ADD_CLASS_COMMENT);
        }
    }

    public void addClassComment(InnerClass innerClass, IntrospectedTable introspectedTable, boolean markAsDoNotDelete) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mgb", "@mbg.generated");
        map.put("innerClass", innerClass);
        map.put("introspectedTable", introspectedTable);
        map.put("markAsDoNotDelete", markAsDoNotDelete);
        this.addJavaElementComment((JavaElement)innerClass, map, EnumNode.ADD_CLASS_COMMENT);
    }

    public void addEnumComment(InnerEnum innerEnum, IntrospectedTable introspectedTable) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mgb", "@mbg.generated");
        map.put("innerEnum", innerEnum);
        map.put("introspectedTable", introspectedTable);
        this.addJavaElementComment((JavaElement)innerEnum, map, EnumNode.ADD_ENUM_COMMENT);
    }

    public void addGetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mgb", "@mbg.generated");
        map.put("method", method);
        map.put("introspectedTable", introspectedTable);
        map.put("introspectedColumn", introspectedColumn);
        this.addJavaElementComment((JavaElement)method, map, EnumNode.ADD_GETTER_COMMENT);
    }

    public void addSetterComment(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mgb", "@mbg.generated");
        map.put("method", method);
        map.put("introspectedTable", introspectedTable);
        map.put("introspectedColumn", introspectedColumn);
        this.addJavaElementComment((JavaElement)method, map, EnumNode.ADD_SETTER_COMMENT);
    }

    public void addGeneralMethodComment(Method method, IntrospectedTable introspectedTable) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mgb", "@mbg.generated");
        map.put("method", method);
        map.put("introspectedTable", introspectedTable);
        this.addJavaElementComment((JavaElement)method, map, EnumNode.ADD_GENERAL_METHOD_COMMENT);
    }

    public void addJavaFileComment(CompilationUnit compilationUnit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mgb", "@mbg.generated");
        map.put("compilationUnit", compilationUnit);
        this.addCompilationUnitComment(compilationUnit, map);
    }

    public void addComment(XmlElement xmlElement) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mgb", "@mbg.generated");
        map.put("xmlElement", xmlElement);
        this.addXmlElementComment(xmlElement, map, EnumNode.ADD_COMMENT);
    }

    public void addRootComment(XmlElement rootElement) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mgb", "@mbg.generated");
        map.put("rootElement", rootElement);
        this.addXmlElementComment(rootElement, map, EnumNode.ADD_ROOT_COMMENT);
    }

    public void addGeneralMethodAnnotation(Method method, IntrospectedTable introspectedTable, Set<FullyQualifiedJavaType> imports) {
        imports.add(new FullyQualifiedJavaType("javax.annotation.Generated"));
        String comment = "Source Table: " + introspectedTable.getFullyQualifiedTable().toString();
        method.addAnnotation(this.getGeneratedAnnotation(comment));
    }

    public void addGeneralMethodAnnotation(Method method, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn, Set<FullyQualifiedJavaType> imports) {
        imports.add(new FullyQualifiedJavaType("javax.annotation.Generated"));
        String comment = "Source field: " + introspectedTable.getFullyQualifiedTable().toString() + "." + introspectedColumn.getActualColumnName();
        method.addAnnotation(this.getGeneratedAnnotation(comment));
    }

    public void addFieldAnnotation(Field field, IntrospectedTable introspectedTable, Set<FullyQualifiedJavaType> imports) {
        imports.add(new FullyQualifiedJavaType("javax.annotation.Generated"));
        String comment = "Source Table: " + introspectedTable.getFullyQualifiedTable().toString();
        field.addAnnotation(this.getGeneratedAnnotation(comment));
    }

    public void addFieldAnnotation(Field field, IntrospectedTable introspectedTable, IntrospectedColumn introspectedColumn, Set<FullyQualifiedJavaType> imports) {
        imports.add(new FullyQualifiedJavaType("javax.annotation.Generated"));
        String comment = "Source field: " + introspectedTable.getFullyQualifiedTable().toString() + "." + introspectedColumn.getActualColumnName();
        field.addAnnotation(this.getGeneratedAnnotation(comment));
    }

    public void addClassAnnotation(InnerClass innerClass, IntrospectedTable introspectedTable, Set<FullyQualifiedJavaType> imports) {
        imports.add(new FullyQualifiedJavaType("javax.annotation.Generated"));
        String comment = "Source Table: " + introspectedTable.getFullyQualifiedTable().toString();
        innerClass.addAnnotation(this.getGeneratedAnnotation(comment));
    }

    private String getGeneratedAnnotation(String comment) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("@Generated(");
        if (this.suppressAllComments) {
            buffer.append('\"');
        } else {
            buffer.append("value=\"");
        }
        buffer.append(MyBatisGenerator.class.getName());
        buffer.append('\"');
        if (!this.suppressDate && !this.suppressAllComments) {
            buffer.append(", date=\"");
            buffer.append(DatatypeConverter.printDateTime((Calendar)Calendar.getInstance()));
            buffer.append('\"');
        }
        if (!this.suppressAllComments) {
            buffer.append(", comments=\"");
            buffer.append(comment);
            buffer.append('\"');
        }
        buffer.append(')');
        return buffer.toString();
    }

    public static enum EnumNode {
        ADD_COMMENT("addComment"),
        ADD_ROOT_COMMENT("addRootComment"),
        ADD_JAVA_FILE_COMMENT("addJavaFileComment"),
        ADD_GENERAL_METHOD_COMMENT("addGeneralMethodComment"),
        ADD_SETTER_COMMENT("addSetterComment"),
        ADD_GETTER_COMMENT("addGetterComment"),
        ADD_ENUM_COMMENT("addEnumComment"),
        ADD_CLASS_COMMENT("addClassComment"),
        ADD_INTERFACE_COMMENT("addInterfaceComment"),
        ADD_MODEL_CLASS_COMMENT("addModelClassComment"),
        ADD_FIELD_COMMENT("addFieldComment");

        private final String value;

        private EnumNode(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }
    }
}

