/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins;

import com.itfsw.mybatis.generator.plugins.utils.BasePlugin;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;

public class ModelAnnotationPlugin
extends BasePlugin {
    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addAnnotations(topLevelClass, introspectedTable);
        return super.modelBaseRecordClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelPrimaryKeyClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addAnnotations(topLevelClass, introspectedTable);
        return super.modelPrimaryKeyClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelRecordWithBLOBsClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        this.addAnnotations(topLevelClass, introspectedTable);
        return super.modelRecordWithBLOBsClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        for (Object key : this.properties.keySet()) {
            String annotation;
            if (!(key instanceof String) || !(annotation = (String)key).startsWith("@Data") && !annotation.startsWith("@Getter")) continue;
            return false;
        }
        return true;
    }

    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, Plugin.ModelClassType modelClassType) {
        for (Object key : this.properties.keySet()) {
            String annotation;
            if (!(key instanceof String) || !(annotation = (String)key).startsWith("@Data") && !annotation.startsWith("@Setter")) continue;
            return false;
        }
        return true;
    }

    private void addAnnotations(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        for (Object key : this.properties.keySet()) {
            if (!(key instanceof String)) continue;
            String annotation = (String)key;
            String pkg = this.properties.getProperty(annotation);
            if (annotation.startsWith("@Data")) {
                this.addAnnotation(topLevelClass, annotation, pkg);
                if (!topLevelClass.getSuperClass().isPresent()) continue;
                this.addAnnotation(topLevelClass, "@EqualsAndHashCode(callSuper = true)", "lombok.EqualsAndHashCode");
                this.addAnnotation(topLevelClass, "@ToString(callSuper = true)", "lombok.ToString");
                continue;
            }
            if (annotation.startsWith("@Builder")) {
                int count = 0;
                if (introspectedTable.getRules().generatePrimaryKeyClass()) {
                    ++count;
                }
                if (introspectedTable.getRules().generateBaseRecordClass()) {
                    ++count;
                }
                if (introspectedTable.getRules().generateRecordWithBLOBsClass()) {
                    ++count;
                }
                if (topLevelClass.getSuperClass().isPresent() || count >= 2) {
                    this.addAnnotation(topLevelClass, "@SuperBuilder", "lombok.experimental.SuperBuilder");
                    continue;
                }
                this.addAnnotation(topLevelClass, annotation, pkg);
                continue;
            }
            this.addAnnotation(topLevelClass, annotation, pkg);
        }
    }

    private void addAnnotation(TopLevelClass topLevelClass, String annotation, String pkg) {
        topLevelClass.addImportedType(pkg);
        topLevelClass.addAnnotation(annotation);
    }
}

