/*
 * Decompiled with CFR 0.152.
 */
package com.itfsw.mybatis.generator.plugins.utils;

import com.itfsw.mybatis.generator.plugins.utils.BeanUtils;
import com.itfsw.mybatis.generator.plugins.utils.hook.HookAggregator;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.PluginConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginTools {
    private static final Logger logger = LoggerFactory.getLogger(PluginTools.class);

    public static <T> T getHook(Class<T> clazz) {
        return (T)HookAggregator.getInstance();
    }

    public static boolean checkDependencyPlugin(Context context, Class ... plugins) {
        for (Class plugin : plugins) {
            if (PluginTools.getPluginIndex(context, plugin) >= 0) continue;
            return false;
        }
        return true;
    }

    public static int getPluginIndex(Context context, Class plugin) {
        List<PluginConfiguration> list = PluginTools.getConfigPlugins(context);
        for (int i = 0; i < list.size(); ++i) {
            PluginConfiguration config = list.get(i);
            if (!plugin.getName().equals(config.getConfigurationType())) continue;
            return i;
        }
        return -1;
    }

    public static List<PluginConfiguration> getConfigPlugins(Context ctx) {
        try {
            return (List)BeanUtils.getProperty(ctx, "pluginConfigurations");
        }
        catch (Exception e) {
            logger.error("\u63d2\u4ef6\u68c0\u67e5\u53cd\u5c04\u5f02\u5e38", (Throwable)e);
            return new ArrayList<PluginConfiguration>();
        }
    }

    public static PluginConfiguration getPluginConfiguration(Context context, Class plugin) {
        int index = PluginTools.getPluginIndex(context, plugin);
        if (index > -1) {
            return PluginTools.getConfigPlugins(context).get(index);
        }
        return null;
    }

    public static int compareVersion(String v1, String v2) {
        if (v1.equals(v2)) {
            return 0;
        }
        String[] version1Array = v1.split("[._]");
        String[] version2Array = v2.split("[._]");
        int minLen = Math.min(version1Array.length, version2Array.length);
        long diff = 0L;
        for (int index = 0; index < minLen && (diff = Long.parseLong(version1Array[index]) - Long.parseLong(version2Array[index])) == 0L; ++index) {
        }
        if (diff == 0L) {
            int i;
            for (i = index; i < version1Array.length; ++i) {
                if (Long.parseLong(version1Array[i]) <= 0L) continue;
                return 1;
            }
            for (i = index; i < version2Array.length; ++i) {
                if (Long.parseLong(version2Array[i]) <= 0L) continue;
                return -1;
            }
            return 0;
        }
        return diff > 0L ? 1 : -1;
    }
}

