/*
 * Decompiled with CFR 0.152.
 */
package com.itlgl.java.util;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class ByteUtils {
    private static final char[] ENCODING_TABLE;
    private static final byte[] DECODING_TABLE;

    public static String toHex(byte[] src) {
        if (src == null || src.length == 0) {
            return null;
        }
        char[] chars = new char[src.length * 2];
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            chars[i * 2] = ENCODING_TABLE[v >>> 4];
            chars[i * 2 + 1] = ENCODING_TABLE[v & 0xF];
        }
        return new String(chars);
    }

    public static String toHex(byte[] src, int start) {
        if (src == null || src.length == 0) {
            return null;
        }
        return ByteUtils.toHex(src, start, src.length);
    }

    public static String toHex(byte[] src, int start, int end) {
        if (src == null || src.length == 0) {
            return null;
        }
        if (start > end) {
            throw new IllegalArgumentException(start + " > " + end);
        }
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException(start + " < 0");
        }
        if (start > src.length) {
            throw new ArrayIndexOutOfBoundsException(start + " > " + src.length);
        }
        if (end > src.length) {
            throw new ArrayIndexOutOfBoundsException(start + " > " + src.length);
        }
        char[] chars = new char[(end - start) * 2];
        for (int i = 0; i < end - start; ++i) {
            int v = src[i + start] & 0xFF;
            chars[i * 2] = ENCODING_TABLE[v >>> 4];
            chars[i * 2 + 1] = ENCODING_TABLE[v & 0xF];
        }
        return new String(chars);
    }

    public static String toHex(int src, int byteLength) {
        switch (byteLength) {
            case 1: {
                return String.format("%02x", src & 0xFF);
            }
            case 2: {
                return String.format("%04x", src & 0xFFFF);
            }
            case 3: {
                return String.format("%06x", src & 0xFFFFFF);
            }
            case 4: {
                return String.format("%08x", src & 0xFFFFFFFF);
            }
        }
        return null;
    }

    public static byte[] fromHex(String hex) {
        if (hex == null || hex.length() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int len = hex.length();
        for (int i = 0; i < len; ++i) {
            char c = hex.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f') && (c < 'A' || c > 'F')) continue;
            builder.append(c);
        }
        String hexSrc = builder.toString();
        int strLength = hexSrc.length();
        byte[] result = new byte[strLength / 2];
        int len2 = strLength / 2;
        for (int i = 0; i < len2; ++i) {
            byte b1 = DECODING_TABLE[hexSrc.charAt(i * 2)];
            byte b2 = DECODING_TABLE[hexSrc.charAt(i * 2 + 1)];
            result[i] = (byte)(b1 << 4 | b2);
        }
        return result;
    }

    public static byte[] fromShort(short s) {
        byte[] ret = new byte[]{(byte)(s >> 8 & 0xFF), (byte)(s & 0xFF)};
        return ret;
    }

    public static short toShort(byte b1, byte b2) {
        short s1 = (short)((b1 & 0xFF) << 8);
        short s2 = (short)(b2 & 0xFF);
        short ret = (short)(s1 | s2);
        return ret;
    }

    public static byte[] fromInt(int i) {
        byte[] ret = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return ret;
    }

    public static int toInt(byte b1, byte b2, byte b3, byte b4) {
        int ret = (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
        return ret;
    }

    public static byte[] combine(Object ... args) {
        if (args == null || args.length == 0) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            try {
                Number s;
                if (args[i] instanceof String) {
                    String hex = (String)args[i];
                    byte[] bytearr = ByteUtils.fromHex(hex);
                    if (bytearr == null) continue;
                    baos.write(bytearr);
                    continue;
                }
                if (args[i] instanceof byte[]) {
                    byte[] ba = (byte[])args[i];
                    baos.write(ba);
                    continue;
                }
                if (args[i] instanceof Byte) {
                    Byte b = (Byte)args[i];
                    int num = b & 0xFF;
                    baos.write(num);
                    continue;
                }
                if (args[i] instanceof Short) {
                    s = (Short)args[i];
                    int num = (Short)s & 0xFF;
                    baos.write(num);
                    continue;
                }
                if (args[i] instanceof Integer) {
                    s = (Integer)args[i];
                    int num = (Integer)s & 0xFF;
                    baos.write(num);
                    continue;
                }
                if (args[i] instanceof Long) {
                    s = (Long)args[i];
                    int num = (int)((Long)s & 0xFFL);
                    baos.write(num);
                    continue;
                }
                System.out.println("\u4e0d\u88ab\u652f\u6301\u7684\u53c2\u6570[" + i + "]");
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return baos.toByteArray();
    }

    static {
        int i;
        ENCODING_TABLE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        DECODING_TABLE = new byte[128];
        Arrays.fill(DECODING_TABLE, (byte)-1);
        for (i = 48; i <= 57; ++i) {
            ByteUtils.DECODING_TABLE[i] = (byte)(i - 48);
        }
        for (i = 97; i <= 102; i = (int)((char)(i + 1))) {
            ByteUtils.DECODING_TABLE[i] = (byte)(i - 97 + 10);
        }
        for (i = 65; i <= 70; i = (int)((char)(i + 1))) {
            ByteUtils.DECODING_TABLE[i] = (byte)(i - 65 + 10);
        }
    }
}

