/*
 * Decompiled with CFR 0.152.
 */
package com.itlgl.java.util;

import com.itlgl.java.util.ByteUtils;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TlvUtils {
    private byte[] data;
    private int index;
    private int nextTagLength = 1;

    public TlvUtils(byte[] data, int index) {
        this.data = data;
        this.index = index;
    }

    public TlvUtils(byte[] data) {
        this(data, 0);
    }

    private boolean hasNextTag() {
        int i = this.index;
        if (i >= this.data.length) {
            return false;
        }
        if ((this.data[i] & 0x1F) != 31) {
            this.nextTagLength = 1;
            return true;
        }
        if (++i >= this.data.length) {
            return false;
        }
        if ((this.data[i] & 0x80) != 128) {
            this.nextTagLength = 2;
            return true;
        }
        if (++i >= this.data.length) {
            return false;
        }
        if ((this.data[i] & 0x80) != 128) {
            this.nextTagLength = 3;
            return true;
        }
        if (++i >= this.data.length) {
            return false;
        }
        if ((this.data[i] & 0x80) != 128) {
            this.nextTagLength = 4;
            return true;
        }
        return false;
    }

    private byte[] nextTag() {
        if (!this.hasNextTag()) {
            return null;
        }
        byte[] tag = new byte[this.nextTagLength];
        System.arraycopy(this.data, this.index, tag, 0, this.nextTagLength);
        this.index += this.nextTagLength;
        return tag;
    }

    private int nextLength() {
        int subBytesLen;
        int i;
        if ((i = this.index++) >= this.data.length) {
            return -1;
        }
        if ((this.data[i] & 0x80) == 0) {
            return this.data[i] & 0xFF;
        }
        if (++i + (subBytesLen = this.data[i] & 0x7F) >= this.data.length || subBytesLen > 4 || subBytesLen == 4 && (this.data[i] & 0x80) == 128) {
            return -1;
        }
        int len = 0;
        if (subBytesLen == 1) {
            len = this.data[i] & 0xFF;
            this.index += 2;
        } else if (subBytesLen == 2) {
            len = (this.data[i] & 0xFF) << 8 | this.data[i + 1] & 0xFF;
            this.index += 3;
        } else if (subBytesLen == 3) {
            len = (this.data[i] & 0xFF) << 16 | (this.data[i + 1] & 0xFF) << 8 | this.data[i + 2] & 0xFF;
            this.index += 4;
        } else if (subBytesLen == 4) {
            len = (this.data[i] & 0xFF) << 24 | (this.data[i + 1] & 0xFF) << 16 | (this.data[i + 2] & 0xFF) << 8 | this.data[i + 3] & 0xFF;
            this.index += 5;
        }
        return len;
    }

    private byte[] nextValue(int len) {
        if (this.index + len > this.data.length) {
            return null;
        }
        byte[] result = Arrays.copyOfRange(this.data, this.index, this.index + len);
        this.index += len;
        return result;
    }

    public TagValue next() {
        if (!this.hasNextTag()) {
            return null;
        }
        byte[] tag = this.nextTag();
        int len = this.nextLength();
        if (len == -1) {
            return null;
        }
        byte[] value = this.nextValue(len);
        if (value == null) {
            return null;
        }
        return new TagValue(tag, len, value);
    }

    public List<TagValue> parseInList() {
        TagValue tagValue = null;
        ArrayList<TagValue> result = new ArrayList<TagValue>();
        while ((tagValue = this.next()) != null) {
            result.add(tagValue);
        }
        return result;
    }

    public Map<String, byte[]> parseInMap() {
        TagValue tagValue = null;
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        while ((tagValue = this.next()) != null) {
            result.put(tagValue.getTagString(), tagValue.value);
        }
        return result;
    }

    public static byte[] generateTlv(List<TagValue> tagValues) {
        if (tagValues == null) {
            return null;
        }
        TagValue[] arrays = new TagValue[tagValues.size()];
        for (int i = 0; i < tagValues.size(); ++i) {
            arrays[i] = tagValues.get(i);
        }
        return TlvUtils.generateTlv(arrays);
    }

    public static byte[] generateTlv(TagValue ... tagValues) {
        if (tagValues == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < tagValues.length; ++i) {
            TagValue tv = tagValues[i];
            out.write(tv.tag, 0, tv.tag.length);
            if (tv.value.length < 128) {
                out.write(tv.value.length);
            } else if (tv.value.length < 255) {
                out.write(129);
                out.write(tv.value.length);
            } else if (tv.value.length < 65535) {
                out.write(130);
                out.write(tv.value.length >> 8 & 0xFF);
                out.write(tv.value.length & 0xFF);
            } else if (tv.value.length < 0xFFFFFF) {
                out.write(130);
                out.write(tv.value.length >> 16 & 0xFF);
                out.write(tv.value.length >> 8 & 0xFF);
                out.write(tv.value.length & 0xFF);
            }
            out.write(tv.value, 0, tv.value.length);
        }
        return out.toByteArray();
    }

    public static class TagValue {
        public byte[] tag;
        public int length;
        public byte[] value;
        private String tagString = null;
        private String valueString = null;

        public TagValue() {
        }

        public TagValue(byte[] tag, int length, byte[] value) {
            this.tag = tag;
            this.length = length;
            this.value = value;
        }

        public TagValue(String tag, int length, byte[] value) {
            this.tag = ByteUtils.fromHex(tag);
            this.length = length;
            this.value = value;
        }

        public String getTagString() {
            if (this.tagString == null) {
                this.tagString = ByteUtils.toHex(this.tag);
            }
            return this.tagString;
        }

        public String getValueString() {
            if (this.valueString == null) {
                this.valueString = ByteUtils.toHex(this.value);
            }
            return this.valueString;
        }
    }
}

