/*
 * Decompiled with CFR 0.152.
 */
package com.ligl.android.widget.iosdialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ligl.android.widget.iosdialog.R;

public class IOSDialog
extends Dialog {
    public IOSDialog(Context context) {
        super(context, R.style.ios_dialog_style);
    }

    public static class Builder {
        private Context mContext;
        private IOSDialog mIosDialog;
        private CharSequence mTitle;
        private CharSequence mMessage;
        private CharSequence mPositiveButtonText;
        private CharSequence mNegativeButtonText;
        private View mContentView;
        private DialogInterface.OnClickListener mPositiveButtonClickListener;
        private DialogInterface.OnClickListener mNegativeButtonClickListener;
        private boolean mCancelable = true;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setTitle(int titleId) {
            this.mTitle = this.mContext.getText(titleId);
            return this;
        }

        public Builder setTitle(CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Builder setMessage(int messageId) {
            this.mMessage = this.mContext.getText(messageId);
            return this;
        }

        public Builder setMessage(CharSequence message) {
            this.mMessage = message;
            return this;
        }

        public Builder setPositiveButton(int textId, DialogInterface.OnClickListener listener) {
            this.mPositiveButtonText = this.mContext.getText(textId);
            this.mPositiveButtonClickListener = listener;
            return this;
        }

        public Builder setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mPositiveButtonText = text;
            this.mPositiveButtonClickListener = listener;
            return this;
        }

        public Builder setNegativeButton(int textId, DialogInterface.OnClickListener listener) {
            this.mNegativeButtonText = this.mContext.getText(textId);
            this.mNegativeButtonClickListener = listener;
            return this;
        }

        public Builder setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mNegativeButtonText = text;
            this.mNegativeButtonClickListener = listener;
            return this;
        }

        public Builder setCancelable(boolean cancelable) {
            this.mCancelable = cancelable;
            return this;
        }

        public Builder setContentView(View contentView) {
            this.mContentView = contentView;
            return this;
        }

        public IOSDialog create() {
            LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
            View dialogView = inflater.inflate(R.layout.ios_dialog, null);
            this.mIosDialog = new IOSDialog(this.mContext);
            this.mIosDialog.setCancelable(this.mCancelable);
            TextView tvTitle = (TextView)dialogView.findViewById(R.id.title);
            TextView tvMessage = (TextView)dialogView.findViewById(R.id.message);
            Button btnCancel = (Button)dialogView.findViewById(R.id.cancel_btn);
            Button btnConfirm = (Button)dialogView.findViewById(R.id.confirm_btn);
            View horizontal_line = dialogView.findViewById(R.id.horizontal_line);
            View vertical_line = dialogView.findViewById(R.id.vertical_line);
            View btns_panel = dialogView.findViewById(R.id.btns_panel);
            if (TextUtils.isEmpty((CharSequence)this.mTitle)) {
                tvTitle.setVisibility(8);
            } else {
                tvTitle.setText(this.mTitle);
            }
            if (this.mContentView != null) {
                LinearLayout rl = (LinearLayout)dialogView.findViewById(R.id.message_layout);
                rl.removeAllViews();
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
                rl.addView(this.mContentView, (ViewGroup.LayoutParams)params);
            } else {
                tvMessage.setText(this.mMessage);
            }
            if (this.mPositiveButtonText == null && this.mNegativeButtonText == null) {
                this.setPositiveButton(R.string.ios_dialog_default_ok, null);
                btnConfirm.setBackgroundResource(R.drawable.iosdialog_sigle_btn_selector);
                btnCancel.setVisibility(8);
                vertical_line.setVisibility(8);
            } else if (this.mPositiveButtonText != null && this.mNegativeButtonText == null) {
                btnConfirm.setBackgroundResource(R.drawable.iosdialog_sigle_btn_selector);
                btnCancel.setVisibility(8);
                vertical_line.setVisibility(8);
            } else if (this.mPositiveButtonText == null && this.mNegativeButtonText != null) {
                btnConfirm.setVisibility(8);
                btnCancel.setBackgroundResource(R.drawable.iosdialog_sigle_btn_selector);
                vertical_line.setVisibility(8);
            }
            if (this.mPositiveButtonText != null) {
                btnConfirm.setText(this.mPositiveButtonText);
                btnConfirm.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (Builder.this.mPositiveButtonClickListener != null) {
                            Builder.this.mPositiveButtonClickListener.onClick((DialogInterface)Builder.this.mIosDialog, -1);
                        }
                        Builder.this.mIosDialog.dismiss();
                    }
                });
            }
            if (this.mNegativeButtonText != null) {
                btnCancel.setText(this.mNegativeButtonText);
                btnCancel.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (Builder.this.mNegativeButtonClickListener != null) {
                            Builder.this.mNegativeButtonClickListener.onClick((DialogInterface)Builder.this.mIosDialog, -2);
                        }
                        Builder.this.mIosDialog.dismiss();
                    }
                });
            }
            dialogView.measure(-1, -2);
            int dialogHeight = dialogView.getMeasuredHeight();
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            DisplayMetrics metrics = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(metrics);
            int maxHeight = (int)((double)metrics.heightPixels * 0.8);
            ViewGroup.LayoutParams dialogParams = new ViewGroup.LayoutParams(-1, -2);
            if (dialogHeight >= maxHeight) {
                dialogParams.height = maxHeight;
            }
            this.mIosDialog.setContentView(dialogView, dialogParams);
            return this.mIosDialog;
        }

        public IOSDialog show() {
            this.mIosDialog = this.create();
            this.mIosDialog.show();
            return this.mIosDialog;
        }
    }
}

