/*
 * Decompiled with CFR 0.152.
 */
package com.ligl.android.widget.iosdialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.ligl.android.widget.iosdialog.R;
import java.util.List;

public class IOSSheetDialog
extends Dialog
implements DialogInterface {
    public IOSSheetDialog(Context context) {
        super(context, R.style.ios_sheet_style);
    }

    public static final class SheetItem {
        public static final int RED = Color.parseColor((String)"#FFFD4A2E");
        public static final int BLUE = Color.parseColor((String)"#FF037BFF");
        public String name;
        public int color;

        public SheetItem() {
        }

        public SheetItem(String name, int color2) {
            this.name = name;
            this.color = color2;
        }
    }

    public static class Builder {
        private IOSSheetDialog mIosSheetDialog;
        private Context mContext;
        private CharSequence mTitle;
        private CharSequence mCancelText;
        private SheetItem[] mItems;
        private DialogInterface.OnClickListener mOnClickListener;

        public Builder(Context context) {
            this.mContext = context;
            this.mCancelText = this.mContext.getText(R.string.iossheet_cancel);
        }

        public Builder setTitle(CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Builder setTitle(int titleId) {
            this.mTitle = this.mContext.getText(titleId);
            return this;
        }

        public Builder setCancelText(CharSequence text) {
            this.mCancelText = text;
            return this;
        }

        public Builder setCancelText(int textId) {
            this.mCancelText = this.mContext.getText(textId);
            return this;
        }

        public Builder setData(SheetItem[] items, DialogInterface.OnClickListener listener) {
            this.mItems = new SheetItem[items.length];
            int len = items.length;
            for (int i = 0; i < len; ++i) {
                this.mItems[i] = new SheetItem(items[i].name, items[i].color);
            }
            this.mOnClickListener = listener;
            return this;
        }

        public Builder setData(List<SheetItem> items, DialogInterface.OnClickListener listener) {
            this.mItems = new SheetItem[items.size()];
            int len = items.size();
            for (int i = 0; i < len; ++i) {
                SheetItem item = items.get(i);
                this.mItems[i] = new SheetItem(item.name, item.color);
            }
            this.mOnClickListener = listener;
            return this;
        }

        public IOSSheetDialog create() {
            LayoutInflater inflater = LayoutInflater.from((Context)this.mContext);
            View sheetView = inflater.inflate(R.layout.ios_sheet_dialog, null);
            this.mIosSheetDialog = new IOSSheetDialog(this.mContext);
            TextView tvTitle = (TextView)sheetView.findViewById(R.id.title);
            LinearLayout message_layout = (LinearLayout)sheetView.findViewById(R.id.message_layout);
            Button btn_cancel = (Button)sheetView.findViewById(R.id.btn_cancel);
            if (TextUtils.isEmpty((CharSequence)this.mTitle)) {
                tvTitle.setVisibility(8);
            } else {
                tvTitle.setText(this.mTitle);
            }
            int i = 0;
            int len = this.mItems.length;
            while (i < len) {
                View itemView = inflater.inflate(R.layout.ios_sheet_item, (ViewGroup)message_layout, false);
                Button btnItem = (Button)itemView.findViewById(R.id.btn_item);
                btnItem.setText((CharSequence)this.mItems[i].name);
                btnItem.setTextColor(this.mItems[i].color);
                if (i == 0 && TextUtils.isEmpty((CharSequence)this.mTitle)) {
                    View line = itemView.findViewById(R.id.line);
                    line.setVisibility(8);
                    btnItem.setBackgroundResource(R.drawable.iossheet_top_btn_selector);
                }
                if (i == this.mItems.length - 1) {
                    btnItem.setBackgroundResource(R.drawable.iossheet_bottom_btn_selector);
                }
                final int itemIndex = i++;
                btnItem.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (Builder.this.mOnClickListener != null) {
                            Builder.this.mOnClickListener.onClick((DialogInterface)Builder.this.mIosSheetDialog, itemIndex);
                        }
                        Builder.this.mIosSheetDialog.dismiss();
                    }
                });
                message_layout.addView(itemView);
            }
            btn_cancel.setText(this.mCancelText);
            btn_cancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Builder.this.mIosSheetDialog.dismiss();
                }
            });
            WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
            DisplayMetrics metrics = new DisplayMetrics();
            wm.getDefaultDisplay().getMetrics(metrics);
            Window window = this.mIosSheetDialog.getWindow();
            window.setWindowAnimations(R.style.ios_sheet_anim);
            window.setBackgroundDrawableResource(17170445);
            WindowManager.LayoutParams wml = window.getAttributes();
            wml.width = metrics.widthPixels;
            wml.gravity = 80;
            wml.y = 0;
            window.setAttributes(wml);
            sheetView.setMinimumWidth(metrics.widthPixels);
            ViewGroup.LayoutParams vgl = new ViewGroup.LayoutParams(-1, -2);
            int maxHeight = (int)((double)metrics.heightPixels * 0.7);
            sheetView.measure(-1, -2);
            int dialogMeasureHeight = sheetView.getMeasuredHeight();
            if (dialogMeasureHeight > maxHeight) {
                vgl.height = maxHeight;
            }
            this.mIosSheetDialog.setContentView(sheetView, vgl);
            return this.mIosSheetDialog;
        }

        public IOSSheetDialog show() {
            this.mIosSheetDialog = this.create();
            this.mIosSheetDialog.show();
            return this.mIosSheetDialog;
        }
    }
}

