/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.jxrest;

import com.itranswarp.jxrest.JsonCallback;
import com.itranswarp.jxrest.Route;
import com.itranswarp.jxrest.Var;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class Callable {
    final boolean isStatic;
    final String path;
    final Route route;
    final Object handlerInstance;
    final Method handlerMethod;
    final Var[] vars;
    static final Map<String, Converter> CONVERTERS = Callable.initConverters();

    Callable(Object handlerInstance, Class<?> handlerClass, Method handlerMethod, String httpMethod, String path) {
        handlerMethod.setAccessible(true);
        this.handlerInstance = handlerInstance;
        this.handlerMethod = handlerMethod;
        this.path = path;
        this.isStatic = path.indexOf(":") == -1;
        this.route = this.isStatic ? null : new Route(path);
        this.vars = this.createVars(handlerClass, handlerMethod, this.route, httpMethod);
    }

    Var[] createVars(Class<?> clazz, Method method, Route route, String httpMethod) {
        ArrayList<Var> vars = new ArrayList<Var>();
        Parameter[] ps = method.getParameters();
        boolean foundJson = false;
        for (int index = 0; index < ps.length; ++index) {
            Parameter p = ps[index];
            String varName = p.getName();
            Class<?> varType = p.getType();
            if (HttpServletRequest.class.equals(varType)) {
                vars.add(Var.createRequestVar(varName, index));
                continue;
            }
            if (HttpServletResponse.class.equals(varType)) {
                vars.add(Var.createResponseVar(varName, index));
                continue;
            }
            if (varName.equals("query") && this.isMapStringString(p)) {
                vars.add(Var.createQueryVar(varName, index));
                continue;
            }
            if (route != null && route.hasParameter(varName)) {
                if (!this.isValidPathVariableType(varType)) {
                    throw new IllegalArgumentException("Unsupported path variable \"" + varType.getName() + " " + varName + "\" in " + this.toHandlerString(clazz, method));
                }
                vars.add(Var.createPathVar(varType, varName, index));
                continue;
            }
            if (!"GET".equals(httpMethod)) {
                if (foundJson) {
                    throw new IllegalArgumentException("Duplicate json variable \"" + varType.getName() + " " + varName + "\" in " + this.toHandlerString(clazz, method));
                }
                vars.add(Var.createJsonVar(varType, varName, index));
                foundJson = true;
                continue;
            }
            throw new IllegalArgumentException("Unknown parameter \"" + varType.getName() + " " + varName + "\" in " + this.toHandlerString(clazz, method));
        }
        return vars.toArray(new Var[vars.size()]);
    }

    boolean isMapStringString(Parameter p) {
        if (!Map.class.equals(p.getType())) {
            return false;
        }
        Type type = p.getParameterizedType();
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType pt = (ParameterizedType)type;
        Type[] types = pt.getActualTypeArguments();
        if (types.length != 2) {
            return false;
        }
        return String.class.equals((Object)types[0]) && String.class.equals((Object)types[1]);
    }

    String toHandlerString(Class<?> clazz, Method method) {
        ArrayList<String> paramNames = new ArrayList<String>();
        for (Parameter param : method.getParameters()) {
            paramNames.add(param.getName());
        }
        return clazz.getName() + "." + method.getName() + "(" + String.join((CharSequence)", ", paramNames) + ")";
    }

    public Object call(Map<String, String> pathVars, JsonCallback jsonCallback, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object[] args = new Object[this.vars.length];
        block9: for (int i = 0; i < args.length; ++i) {
            Var var = this.vars[i];
            switch (var.varType) {
                case 0: {
                    args[i] = this.convertPathVariable(pathVars.get(var.name), var.argType);
                    continue block9;
                }
                case 1: {
                    args[i] = jsonCallback.getJson(var.argType);
                    continue block9;
                }
                case 2: {
                    args[i] = this.createQuery(request);
                    continue block9;
                }
                case 3: {
                    args[i] = request;
                    continue block9;
                }
                case 4: {
                    args[i] = response;
                    continue block9;
                }
                default: {
                    throw new RuntimeException("Bad var type: " + var.varType);
                }
            }
        }
        try {
            return this.handlerMethod.invoke(this.handlerInstance, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    Map<String, String> createQuery(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            map.put(key, request.getParameter(key));
        }
        return map;
    }

    static Map<String, Converter> initConverters() {
        HashMap<String, Converter> converters = new HashMap<String, Converter>();
        Converter byteConverter = str -> Byte.parseByte(str);
        converters.put(Byte.TYPE.getName(), byteConverter);
        converters.put(Byte.class.getName(), byteConverter);
        Converter shortConverter = str -> Short.parseShort(str);
        converters.put(Short.TYPE.getName(), shortConverter);
        converters.put(Short.class.getName(), shortConverter);
        Converter intConverter = str -> Integer.parseInt(str);
        converters.put(Integer.TYPE.getName(), intConverter);
        converters.put(Integer.class.getName(), intConverter);
        Converter longConverter = str -> Long.parseLong(str);
        converters.put(Long.TYPE.getName(), longConverter);
        converters.put(Long.class.getName(), longConverter);
        Converter floatConverter = str -> Float.valueOf(Float.parseFloat(str));
        converters.put(Float.TYPE.getName(), floatConverter);
        converters.put(Float.class.getName(), floatConverter);
        Converter doubleConverter = str -> Double.parseDouble(str);
        converters.put(Double.TYPE.getName(), doubleConverter);
        converters.put(Double.class.getName(), doubleConverter);
        converters.put(Number.class.getName(), str -> {
            try {
                return Long.parseLong(str);
            }
            catch (NumberFormatException e) {
                return Double.parseDouble(str);
            }
        });
        converters.put(String.class.getName(), str -> str);
        return converters;
    }

    boolean isValidPathVariableType(Class<?> clazz) {
        return CONVERTERS.containsKey(clazz.getName());
    }

    Object convertPathVariable(String str, Class<?> clazz) {
        return CONVERTERS.get(clazz.getName()).convert(str);
    }

    static interface Converter {
        public Object convert(String var1);
    }
}

