/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.jxrest;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ClassFinder {
    final Log log = LogFactory.getLog(this.getClass());
    final Pattern classFileNamePattern = Pattern.compile("^[A-Za-z0-9\\_]+\\.class$");

    ClassFinder() {
    }

    public List<Class<?>> findClasses(String ... args) {
        ArrayList list = new ArrayList();
        for (String name : args) {
            Class<?> clazz = this.findClassByName(name);
            if (clazz != null) {
                list.add(clazz);
                continue;
            }
            list.addAll(this.findClassesByPackage(name));
        }
        return list;
    }

    Class<?> findClassByName(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            this.log.info((Object)("Found class: " + name));
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    List<Class<?>> findClassesByPackage(String pkgName) {
        URL url = this.getClass().getClassLoader().getResource(pkgName.replace('.', '/'));
        if (url == null) {
            throw new RuntimeException("Package not found: " + pkgName);
        }
        String theUrl = url.toString();
        if (theUrl.startsWith("file:")) {
            return this.findClassesInDir(pkgName, url.getPath());
        }
        if (theUrl.startsWith("jar:file:") && theUrl.endsWith("!/" + pkgName.replace('.', '/'))) {
            return this.findClassesInJar(pkgName, theUrl.substring(9, theUrl.length() - pkgName.length() - 2));
        }
        throw new RuntimeException("Package not found: " + pkgName);
    }

    List<Class<?>> findClassesInDir(String pkgName, String path) {
        File dir = new File(path);
        String[] files = dir.list();
        return Arrays.asList(files).stream().filter(fileName -> fileName.endsWith(".class") && this.classFileNamePattern.matcher((CharSequence)fileName).matches()).map(fileName -> {
            try {
                String className = pkgName + "." + fileName.substring(0, fileName.length() - 6);
                Class<?> clazz = Class.forName(className);
                this.log.info((Object)("Found class " + className + " in file: " + fileName));
                return clazz;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).filter(clazz -> clazz != null).collect(Collectors.toList());
    }

    List<Class<?>> findClassesInJar(String pkgName, String jarFile) {
        this.log.info((Object)("Scan classes in jar: " + jarFile));
        ArrayList list = new ArrayList();
        String packagePrefix = pkgName + ".";
        ZipInputStream zip = null;
        try {
            zip = new ZipInputStream(new BufferedInputStream(new FileInputStream(jarFile)));
            Cloneable entry = zip.getNextEntry();
            while (entry != null) {
                String classFileName;
                String entryName = ((ZipEntry)entry).getName();
                if (!((ZipEntry)entry).isDirectory() && entryName.endsWith(".class") && (classFileName = entryName.replace('/', '.')).startsWith(packagePrefix) && this.classFileNamePattern.matcher(classFileName.substring(packagePrefix.length())).matches()) {
                    this.log.info((Object)("Found class " + classFileName + " in jar: " + jarFile));
                    try {
                        list.add(Class.forName(classFileName.substring(0, classFileName.length() - 6)));
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                entry = zip.getNextEntry();
            }
            entry = list;
            return entry;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

