/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.jxrest;

import com.itranswarp.jxrest.RestApiHandler;
import java.io.IOException;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestApiFilter
implements Filter {
    final Log log = LogFactory.getLog(this.getClass());
    String urlPrefix = "";
    RestApiHandler handler = null;

    public void setRestApiHandler(RestApiHandler handler) {
        this.handler = handler;
    }

    public void setUrlPrefix(String prefix) {
        String string = prefix = prefix == null ? "" : prefix.trim();
        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!prefix.isEmpty() && !prefix.startsWith("/")) {
            this.log.error((Object)("Invalid urlPrefix: must start with /, but actual is: " + prefix));
            throw new IllegalArgumentException("Invalid urlPrefix parameter: " + prefix);
        }
        this.log.info((Object)("Set urlPrefix of RestApiFilter to: " + prefix));
        this.urlPrefix = prefix;
    }

    public void init(FilterConfig config) throws ServletException {
        this.log.info((Object)"Init RestApiFilter...");
        if (this.handler == null) {
            this.handler = new RestApiHandler();
        }
        this.setUrlPrefix(config.getInitParameter("urlPrefix"));
        String handlers = config.getInitParameter("handlers");
        if (handlers != null) {
            Stream.of(handlers.split("\\,")).map(s -> s.trim()).filter(s -> !s.isEmpty()).forEach(s -> this.handler.findHandlers((String)s));
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String apiUrl;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String path = req.getRequestURI();
        if (path.startsWith(this.urlPrefix) && (apiUrl = path.substring(this.urlPrefix.length())).startsWith("/")) {
            this.log.info((Object)("Process API request: " + apiUrl));
            this.handler.processApi(req, resp, req.getMethod(), apiUrl);
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        this.log.info((Object)"Destroy RestApiFilter...");
    }
}

