/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.jxrest;

import com.itranswarp.jsonstream.JsonBuilder;
import com.itranswarp.jsonstream.JsonWriter;
import com.itranswarp.jxrest.ApiNotFoundException;
import com.itranswarp.jxrest.ClassFinder;
import com.itranswarp.jxrest.JsonCallback;
import com.itranswarp.jxrest.RestContext;
import com.itranswarp.jxrest.Routes;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestApiHandler {
    Log log = LogFactory.getLog(this.getClass());
    Routes routes = new Routes();
    JsonBuilder jsonBuilder = new JsonBuilder();

    public void setJsonBuilder(JsonBuilder jsonBuilder) {
        this.jsonBuilder = jsonBuilder;
    }

    public void setHandlers(List<String> names) {
        for (String name : names) {
            this.findHandlers(name);
        }
    }

    protected void findHandlers(String name) {
        for (Class<?> clazz : new ClassFinder().findClasses(name)) {
            this.addHandler(clazz);
        }
    }

    protected void addHandler(Class<?> clazz) {
        try {
            this.routes.addHandler(clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processApi(HttpServletRequest req, HttpServletResponse resp, String method, String path) throws IOException {
        switch (method) {
            case "GET": {
                this.processApiRequest(req, resp, "GET", path);
                break;
            }
            case "POST": {
                this.processApiRequest(req, resp, "POST", path);
                break;
            }
            case "PUT": {
                this.processApiRequest(req, resp, "PUT", path);
                break;
            }
            case "DELETE": {
                this.processApiRequest(req, resp, "DELETE", path);
                break;
            }
            default: {
                this.processBadRequest(req, resp, method, path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object parseBeanFromJson(Class<?> type, HttpServletRequest req) throws IOException {
        String encoding = req.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try (Reader reader = null;){
            reader = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream(), encoding));
            Object object = this.jsonBuilder.createReader(reader).parse(type);
            return object;
        }
    }

    protected void processBadRequest(HttpServletRequest req, HttpServletResponse resp, String method, String path) throws IOException {
        resp.sendError(405, "Method Not Allowed");
    }

    protected boolean checkContentType(String contentType) {
        if (contentType == null) {
            return false;
        }
        String ct = contentType.toLowerCase();
        if (ct.equals("application/json")) {
            return true;
        }
        if (ct.startsWith("application/json")) {
            char ch = ct.charAt(16);
            return ch == ' ' || ch == ';';
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processApiRequest(HttpServletRequest req, HttpServletResponse resp, String method, String path) throws IOException {
        if (!"GET".equals(method) && req.getContentLength() != 0 && !this.checkContentType(req.getContentType())) {
            this.log.debug((Object)"415 UNSUPPORTED MEDIA TYPE: not a json request.");
            resp.sendError(415, "Request must be application/json.");
            return;
        }
        RestContext.initRestContext(req, resp);
        try {
            Object ret;
            JsonCallback jsonCallback = null;
            if (!"GET".equals(method)) {
                jsonCallback = type -> this.parseBeanFromJson(type, req);
            }
            if ((ret = this.routes.call(method, path, jsonCallback, req, resp)) instanceof Void) {
                return;
            }
            resp.setCharacterEncoding("UTF-8");
            resp.setContentType("application/json");
            PrintWriter writer = resp.getWriter();
            JsonWriter jsonWriter = this.jsonBuilder.createWriter((Writer)writer);
            jsonWriter.write(ret);
            ((Writer)writer).flush();
        }
        catch (ApiNotFoundException e) {
            resp.sendError(404);
        }
        catch (Exception e) {
            this.log.error((Object)"Process API failed.", (Throwable)e);
            resp.sendError(500);
        }
        finally {
            RestContext.destroyRestContext();
        }
    }
}

