/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.jxrest;

import com.itranswarp.jxrest.RestApiHandler;
import java.io.IOException;
import java.util.stream.Stream;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestApiServlet
extends GenericServlet {
    final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    String urlPrefix = "";
    RestApiHandler handler = null;

    public void setRestApiHandler(RestApiHandler handler) {
        this.handler = handler;
    }

    public void setUrlPrefix(String prefix) {
        String string = prefix = prefix == null ? "" : prefix.trim();
        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!prefix.isEmpty() && !prefix.startsWith("/")) {
            this.log.error((Object)("Invalid urlPrefix: must start with /, but actual is: " + prefix));
            throw new IllegalArgumentException("Invalid urlPrefix parameter: " + prefix);
        }
        this.log.info((Object)("Set urlPrefix of RestApiFilter to: " + prefix));
        this.urlPrefix = prefix;
    }

    public void init() throws ServletException {
        this.log.info((Object)"Init RestApiServlet...");
        if (this.handler == null) {
            this.handler = new RestApiHandler();
        }
        this.setUrlPrefix(this.getInitParameter("urlPrefix"));
        String handlers = this.getInitParameter("handlers");
        if (handlers != null) {
            Stream.of(handlers.split("\\,")).map(s -> s.trim()).filter(s -> !s.isEmpty()).forEach(s -> this.handler.findHandlers((String)s));
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String apiUrl;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String path = req.getRequestURI();
        if (path.startsWith(this.urlPrefix) && (apiUrl = path.substring(this.urlPrefix.length())).startsWith("/")) {
            this.log.info((Object)("Process API request: " + apiUrl));
            this.handler.processApi(req, resp, req.getMethod(), apiUrl);
            return;
        }
        resp.sendError(405, "Method Not Allowed");
    }

    public void destroy() {
        this.log.info((Object)"Destroy RestApiServlet...");
        this.handler = null;
    }
}

