/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.warpdb;

import com.itranswarp.warpdb.PropertyGetter;
import com.itranswarp.warpdb.PropertySetter;
import com.itranswarp.warpdb.converter.EnumToStringConverter;
import com.itranswarp.warpdb.util.ClassUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.AttributeConverter;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Version;

class AccessibleProperty {
    final AccessibleObject accessible;
    final Class<?> propertyType;
    final AttributeConverter<Object, Object> converter;
    final String propertyName;
    final String columnName;
    final String columnDefinition;
    final PropertyGetter convertGetter;
    final PropertySetter convertSetter;
    final boolean nullable;
    final boolean unique;
    static final Map<Class<?>, String> DEFAULT_COLUMN_TYPES = new HashMap();
    static final Set<Class<?>> VERSION_TYPES = new HashSet();

    boolean isId() {
        return this.accessible.isAnnotationPresent(Id.class);
    }

    boolean isIdentityId() {
        if (!this.isId()) {
            return false;
        }
        GeneratedValue gv = this.accessible.getAnnotation(GeneratedValue.class);
        if (gv == null) {
            return false;
        }
        GenerationType gt = gv.strategy();
        return gt == GenerationType.IDENTITY;
    }

    boolean isVersion() {
        boolean isVersion = this.accessible.isAnnotationPresent(Version.class);
        if (isVersion && !VERSION_TYPES.contains(this.propertyType)) {
            throw new RuntimeException("Unsupported @Version type: " + this.propertyType.getName());
        }
        return isVersion;
    }

    boolean isInsertable() {
        if (this.isIdentityId()) {
            return false;
        }
        Column col = this.accessible.getAnnotation(Column.class);
        return col == null || col.insertable();
    }

    boolean isUpdatable() {
        if (this.isId()) {
            return false;
        }
        Column col = this.accessible.getAnnotation(Column.class);
        return col == null || col.updatable();
    }

    public AccessibleProperty(Field f) {
        this(f.getType(), f.getName(), f, obj -> f.get(obj), (obj, value) -> f.set(obj, value));
    }

    public AccessibleProperty(String name, Method getter, Method setter) {
        this(getter.getReturnType(), name, getter, obj -> getter.invoke(obj, new Object[0]), (obj, value) -> setter.invoke(obj, value));
    }

    private AccessibleProperty(Class<?> type, String propertyName, AccessibleObject accessible, PropertyGetter getter, PropertySetter setter) {
        accessible.setAccessible(true);
        this.accessible = accessible;
        AttributeConverter<Object, Object> converter = this.getConverter(accessible);
        String columnDefinition = null;
        if (converter == null && type.isEnum()) {
            converter = new EnumToStringConverter(type);
            columnDefinition = "VARCHAR(50)";
        }
        Class<?> propertyType = AccessibleProperty.checkPropertyType(type, converter);
        String columnName = AccessibleProperty.getColumnName(accessible, propertyName);
        if (columnDefinition == null) {
            Class<?> ddlType = AccessibleProperty.getConverterType(converter);
            if (ddlType == null) {
                ddlType = propertyType;
            }
            columnDefinition = AccessibleProperty.getColumnDefinition(accessible, ddlType);
        }
        this.nullable = this.isNullable();
        this.unique = this.isUnique();
        this.converter = converter;
        this.propertyType = propertyType;
        this.propertyName = propertyName;
        this.columnName = columnName;
        this.columnDefinition = columnDefinition;
        this.convertGetter = this.converter == null ? getter : bean -> {
            Object value = getter.get(bean);
            if (value != null) {
                value = this.converter.convertToDatabaseColumn(value);
            }
            return value;
        };
        this.convertSetter = this.converter == null ? setter : (bean, value) -> {
            if (value != null && this.converter != null) {
                value = this.converter.convertToEntityAttribute(value);
            }
            setter.set(bean, value);
        };
    }

    private boolean isNullable() {
        if (this.isId()) {
            return false;
        }
        Column col = this.accessible.getAnnotation(Column.class);
        return col == null || col.nullable();
    }

    private boolean isUnique() {
        if (this.isId()) {
            return true;
        }
        Column col = this.accessible.getAnnotation(Column.class);
        return col != null && col.unique();
    }

    private AttributeConverter<Object, Object> getConverter(AccessibleObject accessible) {
        Convert converter = accessible.getAnnotation(Convert.class);
        if (converter != null) {
            Class converterClass = converter.converter();
            if (!AttributeConverter.class.isAssignableFrom(converterClass)) {
                throw new RuntimeException("Converter class must be AttributeConverter rather than " + converterClass.getName());
            }
            try {
                Constructor cs = converterClass.getDeclaredConstructor(new Class[0]);
                cs.setAccessible(true);
                return (AttributeConverter)cs.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Cannot instantiate Converter: " + converterClass.getName(), e);
            }
        }
        return null;
    }

    private static Class<?> getConverterType(AttributeConverter<Object, Object> converter) {
        if (converter != null) {
            List<Type> types = ClassUtils.getGenericInterfacesIncludeHierarchy(converter.getClass());
            for (Type type : types) {
                Type dbType;
                ParameterizedType pt;
                if (!(type instanceof ParameterizedType) || (pt = (ParameterizedType)type).getRawType() != AttributeConverter.class || !((dbType = pt.getActualTypeArguments()[1]) instanceof Class)) continue;
                return (Class)dbType;
            }
        }
        return null;
    }

    private static Class<?> checkPropertyType(Class<?> typeClass, AttributeConverter<Object, Object> converter) {
        Class<?> converterType = AccessibleProperty.getConverterType(converter);
        if (converterType != null) {
            typeClass = converterType;
        }
        if (typeClass.isEnum() || DEFAULT_COLUMN_TYPES.containsKey(typeClass)) {
            return typeClass;
        }
        throw new RuntimeException("Unsupported type: " + typeClass);
    }

    private static String getColumnName(AccessibleObject ao, String defaultName) {
        Column col = ao.getAnnotation(Column.class);
        if (col == null || col.name().isEmpty()) {
            return defaultName;
        }
        return col.name();
    }

    private static String getColumnDefinition(AccessibleObject ao, Class<?> type) {
        Column col = ao.getAnnotation(Column.class);
        String colDef = null;
        colDef = col == null || col.columnDefinition().isEmpty() ? (type.isEnum() ? "VARCHAR(50)" : AccessibleProperty.getDefaultColumnType(type, col)) : col.columnDefinition().toUpperCase();
        return colDef;
    }

    private static String getDefaultColumnType(Class<?> type, Column col) {
        String ddl = DEFAULT_COLUMN_TYPES.get(type);
        if (ddl.equals("VARCHAR($1)")) {
            ddl = ddl.replace("$1", String.valueOf(col == null ? 255 : col.length()));
        }
        if (ddl.equals("DECIMAL($1,$2)")) {
            int scale;
            int preci = col == null ? 0 : col.precision();
            int n = scale = col == null ? 0 : col.scale();
            if (preci == 0) {
                preci = 10;
            }
            ddl = ddl.replace("$1", String.valueOf(preci)).replace("$2", String.valueOf(scale));
        }
        return ddl;
    }

    static {
        DEFAULT_COLUMN_TYPES.put(String.class, "VARCHAR($1)");
        DEFAULT_COLUMN_TYPES.put(Boolean.TYPE, "BIT");
        DEFAULT_COLUMN_TYPES.put(Boolean.class, "BIT");
        DEFAULT_COLUMN_TYPES.put(Byte.TYPE, "TINYINT");
        DEFAULT_COLUMN_TYPES.put(Byte.class, "TINYINT");
        DEFAULT_COLUMN_TYPES.put(Short.TYPE, "SMALLINT");
        DEFAULT_COLUMN_TYPES.put(Short.class, "SMALLINT");
        DEFAULT_COLUMN_TYPES.put(Integer.TYPE, "INTEGER");
        DEFAULT_COLUMN_TYPES.put(Integer.class, "INTEGER");
        DEFAULT_COLUMN_TYPES.put(Long.TYPE, "BIGINT");
        DEFAULT_COLUMN_TYPES.put(Long.class, "BIGINT");
        DEFAULT_COLUMN_TYPES.put(Float.TYPE, "REAL");
        DEFAULT_COLUMN_TYPES.put(Float.class, "REAL");
        DEFAULT_COLUMN_TYPES.put(Double.TYPE, "DOUBLE");
        DEFAULT_COLUMN_TYPES.put(Double.class, "DOUBLE");
        DEFAULT_COLUMN_TYPES.put(BigDecimal.class, "DECIMAL($1,$2)");
        DEFAULT_COLUMN_TYPES.put(Date.class, "DATE");
        DEFAULT_COLUMN_TYPES.put(LocalDate.class, "DATE");
        DEFAULT_COLUMN_TYPES.put(LocalTime.class, "TIME");
        DEFAULT_COLUMN_TYPES.put(java.util.Date.class, "DATETIME");
        DEFAULT_COLUMN_TYPES.put(Timestamp.class, "TIMESTAMP");
        DEFAULT_COLUMN_TYPES.put(Blob.class, "BLOB");
        DEFAULT_COLUMN_TYPES.put(Clob.class, "CLOB");
        VERSION_TYPES.addAll(Arrays.asList(Long.TYPE, Long.class, Integer.TYPE, Integer.class, Short.TYPE, Short.class, Timestamp.class));
    }
}

