/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.warpdb;

import com.itranswarp.warpdb.CompiledClause;
import com.itranswarp.warpdb.Criteria;
import com.itranswarp.warpdb.CriteriaQuery;
import com.itranswarp.warpdb.Limit;
import com.itranswarp.warpdb.Mapper;
import com.itranswarp.warpdb.OrderBy;
import com.itranswarp.warpdb.PagedResults;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.persistence.AttributeConverter;

public final class Where<T>
extends CriteriaQuery<T> {
    static final Pattern WORD_PATTERN = Pattern.compile("[^a-zA-Z0-9\\_]+");

    Where(Criteria<T> criteria, String clause, Object ... params) {
        super(criteria);
        this.criteria.where = new ArrayList<String>();
        this.criteria.whereParams = new ArrayList<Object>();
        this.append(null, clause, params);
    }

    public Where<T> and(String clause, Object ... params) {
        this.append("AND", clause, params);
        return this;
    }

    public Where<T> or(String clause, Object ... params) {
        this.append("OR", clause, params);
        return this;
    }

    Where<T> append(String type, String clause, Object ... params) {
        Mapper mapper = this.criteria.mapper;
        CompiledClause cc = CompiledClause.compile(mapper, clause);
        if (cc.converters.length != params.length) {
            throw new IllegalArgumentException("Arguments not match the placeholder.");
        }
        int n = 0;
        for (AttributeConverter<Object, Object> attributeConverter : cc.converters) {
            if (attributeConverter != null) {
                params[n] = attributeConverter.convertToDatabaseColumn(params[n]);
            }
            ++n;
        }
        if (type != null) {
            this.criteria.where.add(type);
        }
        this.criteria.where.add(cc.clause);
        for (Object object : params) {
            this.criteria.whereParams.add(object);
        }
        return this;
    }

    static String[] extractWords(String s) {
        String ss = WORD_PATTERN.matcher(s).replaceAll(" ");
        return ss.split("\\s+");
    }

    public Limit<T> limit(int maxResults) {
        return this.limit(0, maxResults);
    }

    public Limit<T> limit(int offset, int maxResults) {
        return new Limit(this.criteria, offset, maxResults);
    }

    public OrderBy<T> orderBy(String orderBy) {
        return new OrderBy(this.criteria, orderBy);
    }

    public List<T> list() {
        return this.criteria.list();
    }

    public PagedResults<T> list(int pageIndex) {
        return this.criteria.list(pageIndex, 20);
    }

    public PagedResults<T> list(int pageIndex, int itemsPerPage) {
        return this.criteria.list(pageIndex, itemsPerPage);
    }

    public int count() {
        return this.criteria.count();
    }

    public T first() {
        return this.criteria.first();
    }

    public T unique() {
        return this.criteria.unique();
    }
}

