/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.warpdb.util;

import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class IdUtils {
    static final char[] BASE32_CHARS = "0123456789abcdefghijklmnopqrstuv".toCharArray();
    static final AtomicLong sequence = new AtomicLong(System.currentTimeMillis() & 0x1FFFFFFFL);
    static final Random random = new Random();

    public static String next() {
        String timestamp = IdUtils.longToBase32(System.currentTimeMillis());
        String seq = IdUtils.longToBase32(sequence.getAndIncrement() & 0x1FFFFFFFL);
        StringBuilder builder = new StringBuilder("0000000000000000");
        IdUtils.setStringAt(builder, 0, timestamp, 9);
        IdUtils.setStringAt(builder, 9, seq, 7);
        return builder.toString();
    }

    static void setStringAt(StringBuilder buffer, int bufferStart, String str, int length) {
        int strStart = 0;
        int strEnd = str.length();
        if (str.length() < length) {
            bufferStart += length - str.length();
            strEnd = str.length();
        } else {
            strStart = str.length() - length;
        }
        int i = bufferStart;
        for (int n = strStart; n < strEnd; ++n) {
            buffer.setCharAt(i, str.charAt(n));
            ++i;
        }
    }

    public static boolean isValidId(String s) {
        if (s == null || s.length() != 16) {
            return false;
        }
        for (int i = 0; i < 15; ++i) {
            char ch = s.charAt(i);
            if (ch >= 'a' && ch <= 'v' || ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    static String longToBase32(long n) {
        char[] buffer = new char[13];
        for (int i = 12; i >= 0; --i) {
            int x = (int)(n & 0x1FL);
            buffer[i] = BASE32_CHARS[x];
            if ((n >>= 5) != 0L) continue;
            return new String(buffer, i, 13 - i);
        }
        return new String(buffer);
    }

    public static void main(String[] args) throws Exception {
        int i;
        for (i = 0; i < 100; ++i) {
            System.out.println(IdUtils.next());
        }
        Thread.sleep(1L);
        for (i = 0; i < 100; ++i) {
            System.out.println(IdUtils.next());
        }
    }
}

