/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.warpdb;

import com.itranswarp.warpdb.AccessibleProperty;
import com.itranswarp.warpdb.Mapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.AttributeConverter;

class CompiledClause {
    static final Map<String, CompiledClause> CACHE = new ConcurrentHashMap<String, CompiledClause>();
    static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("and", "or", "like", "in", "is", "not"));
    static final Pattern p = Pattern.compile("[a-z\\_][a-z0-9\\_]*");
    final String clause;
    final AttributeConverter<Object, Object>[] converters;

    CompiledClause(String clause, AttributeConverter<Object, Object>[] converters) {
        this.clause = clause;
        this.converters = converters;
    }

    static CompiledClause compile(Mapper<?> mapper, String clause) {
        String key = mapper.entityClass.getName() + "\n" + clause;
        CompiledClause cc = CACHE.get(key);
        if (cc == null) {
            cc = CompiledClause.doCompile(mapper, clause);
            CACHE.put(key, cc);
        }
        return cc;
    }

    static CompiledClause doCompile(Mapper<?> mapper, String clause) {
        Map<String, AccessibleProperty> properties = mapper.allPropertiesMap;
        StringBuilder sb = new StringBuilder(clause.length() + 10);
        ArrayList<Object> list = new ArrayList<Object>();
        int start = 0;
        Matcher m = p.matcher(clause.toLowerCase());
        while (m.find()) {
            sb.append(clause.substring(start, m.start()));
            String s = clause.substring(m.start(), m.end());
            if (properties.containsKey(s.toLowerCase())) {
                AccessibleProperty ap = properties.get(s.toLowerCase());
                sb.append(ap.columnName);
                list.add(ap.converter);
            } else {
                if (s.toLowerCase().equals("between")) {
                    list.add((AttributeConverter)list.get(list.size() - 1));
                } else if (s.toLowerCase().equals("null")) {
                    list.remove(list.size() - 1);
                } else if (!KEYWORDS.contains(s.toLowerCase())) {
                    throw new IllegalArgumentException("Invalid string \"" + s + "\" found in clause: " + clause);
                }
                sb.append(s);
            }
            start = m.end();
        }
        sb.append(clause.substring(start));
        if (list.size() != CompiledClause.numOfPlaceholder(clause)) {
            throw new IllegalArgumentException("Invalid number of placeholder.");
        }
        return new CompiledClause(sb.toString(), list.toArray(new AttributeConverter[0]));
    }

    static int numOfPlaceholder(String s) {
        int n = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '?') continue;
            ++n;
        }
        return n;
    }
}

