/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.warpdb.util;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public final class ClassUtils {
    public static List<Class<?>> scanEntities(String ... basePackages) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
        ArrayList classes = new ArrayList();
        for (String basePackage : basePackages) {
            Set beans = provider.findCandidateComponents(basePackage);
            for (BeanDefinition bean : beans) {
                try {
                    classes.add(Class.forName(bean.getBeanClassName()));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return classes;
    }

    public static List<Type> getGenericInterfacesIncludeHierarchy(Class<?> clazz) {
        ArrayList<Type> list = new ArrayList<Type>();
        ClassUtils.addGenericInterfaces(clazz, list);
        return list;
    }

    static void addGenericInterfaces(Class<?> clazz, List<Type> list) {
        Type[] types;
        for (Type type : types = clazz.getGenericInterfaces()) {
            list.add(type);
        }
        if (clazz.getSuperclass() != Object.class) {
            ClassUtils.addGenericInterfaces(clazz.getSuperclass(), list);
        }
    }
}

