/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.warpdb;

import com.itranswarp.warpdb.AccessibleProperty;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.springframework.jdbc.core.RowMapper;

class BeanRowMapper<T>
implements RowMapper<T> {
    final Map<String, AccessibleProperty> mapping;
    final Function<Void, T> constructor;

    BeanRowMapper(Class<T> clazz, List<AccessibleProperty> properties) {
        HashMap<String, AccessibleProperty> mapping = new HashMap<String, AccessibleProperty>();
        for (AccessibleProperty p : properties) {
            mapping.put(p.columnName.toLowerCase(), p);
        }
        this.mapping = mapping;
        try {
            Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            this.constructor = Void2 -> {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        T bean = this.constructor.apply(null);
        ResultSetMetaData meta = rs.getMetaData();
        int count = meta.getColumnCount();
        try {
            for (int i = 1; i <= count; ++i) {
                String name = meta.getColumnName(i);
                AccessibleProperty prop = this.mapping.get(name.toLowerCase());
                if (prop == null) continue;
                Object value = rs.getObject(i);
                prop.convertSetter.set(bean, value);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return bean;
    }
}

