/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.warpdb;

import com.itranswarp.warpdb.Mapper;
import com.itranswarp.warpdb.Page;
import com.itranswarp.warpdb.PagedResults;
import com.itranswarp.warpdb.WarpDb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class Criteria<T> {
    final WarpDb warpdb;
    Mapper<T> mapper;
    Class<T> clazz;
    List<String> select = null;
    boolean distinct = false;
    String table = null;
    List<String> where = null;
    List<Object> whereParams = null;
    List<String> orderBy = null;
    boolean forUpdate = false;
    int offset = 0;
    int maxResults = 0;

    Criteria(WarpDb db) {
        this.warpdb = db;
    }

    String sql(String aggregate) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("SELECT ");
        if (aggregate == null) {
            if (this.distinct) {
                sb.append("DISTINCT ");
            }
            sb.append(this.select == null ? "*" : String.join((CharSequence)", ", this.select));
        } else {
            sb.append(aggregate);
        }
        sb.append(" FROM ").append(this.mapper.tableName);
        if (this.where != null) {
            sb.append(" WHERE ").append(String.join((CharSequence)" ", this.where));
        }
        if (aggregate == null && this.orderBy != null) {
            sb.append(" ORDER BY ").append(String.join((CharSequence)", ", this.orderBy));
        }
        if (aggregate == null && this.offset >= 0 && this.maxResults > 0) {
            sb.append(" LIMIT ?, ?");
        }
        if (aggregate == null && this.forUpdate) {
            sb.append(" FOR UPDATE");
        }
        String s = sb.toString();
        return s;
    }

    Object[] params(String aggregate) {
        ArrayList<Object> params = new ArrayList<Object>();
        if (this.where != null) {
            for (Object obj : this.whereParams) {
                if (obj == null) {
                    params.add(null);
                    continue;
                }
                params.add(obj);
            }
        }
        if (aggregate == null && this.offset >= 0 && this.maxResults > 0) {
            params.add(this.offset);
            params.add(this.maxResults);
        }
        return params.toArray();
    }

    List<T> list() {
        String selectSql = this.sql(null);
        Object[] selectParams = this.params(null);
        return this.warpdb.list(selectSql, selectParams);
    }

    PagedResults<T> list(int pageIndex, int itemsPerPage) {
        if (pageIndex < 1) {
            throw new IllegalArgumentException("Invalid page index.");
        }
        if (itemsPerPage < 1 || itemsPerPage > 1000) {
            throw new IllegalArgumentException("Invalid items per page.");
        }
        String countSql = this.sql("count(*)");
        Object[] countParams = this.params("count(*)");
        int totalItems = this.warpdb.queryForInt(countSql, countParams).getAsInt();
        int totalPages = 0;
        if (totalItems > 0) {
            totalPages = totalItems / itemsPerPage + (totalItems % itemsPerPage > 0 ? 1 : 0);
        }
        Page page = new Page(pageIndex, itemsPerPage, totalPages, totalItems);
        if (totalItems == 0 || pageIndex > totalPages) {
            return new PagedResults(page, Collections.emptyList());
        }
        this.offset = (pageIndex - 1) * itemsPerPage;
        this.maxResults = itemsPerPage;
        String selectSql = this.sql(null);
        Object[] selectParams = this.params(null);
        return new PagedResults(page, this.warpdb.list(selectSql, selectParams));
    }

    int count() {
        String selectSql = this.sql("count(*)");
        Object[] selectParams = this.params("count(*)");
        return this.warpdb.queryForInt(selectSql, selectParams).getAsInt();
    }

    T first() {
        Object[] selectParams;
        this.offset = 0;
        this.maxResults = 1;
        String selectSql = this.sql(null);
        List list = this.warpdb.list(selectSql, selectParams = this.params(null));
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    T unique() {
        Object[] selectParams;
        this.offset = 0;
        this.maxResults = 2;
        String selectSql = this.sql(null);
        List list = this.warpdb.list(selectSql, selectParams = this.params(null));
        if (list.isEmpty()) {
            throw new RuntimeException("Expected unique row but nothing found.");
        }
        if (list.size() > 1) {
            throw new RuntimeException("Expected unique row but more than 1 rows found.");
        }
        return list.get(0);
    }
}

