/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.warpdb;

import com.itranswarp.warpdb.AccessibleProperty;
import com.itranswarp.warpdb.Criteria;
import com.itranswarp.warpdb.CriteriaQuery;
import com.itranswarp.warpdb.Limit;
import com.itranswarp.warpdb.Mapper;
import com.itranswarp.warpdb.OrderBy;
import com.itranswarp.warpdb.PagedResults;
import com.itranswarp.warpdb.Where;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class From<T>
extends CriteriaQuery<T> {
    From(Criteria<T> criteria, Mapper<T> mapper) {
        super(criteria);
        this.criteria.mapper = mapper;
        this.criteria.clazz = mapper.entityClass;
        this.criteria.table = mapper.tableName;
        this.checkSelect();
    }

    void checkSelect() {
        if (this.criteria.select == null) {
            return;
        }
        Map<String, AccessibleProperty> map = this.criteria.mapper.allPropertiesMap;
        this.criteria.select = this.criteria.select.stream().map(prop -> {
            if ("*".equals(prop)) {
                return "*";
            }
            AccessibleProperty ap = (AccessibleProperty)map.get(prop.toLowerCase());
            if (ap == null) {
                throw new IllegalArgumentException("Invalid property in select: " + prop);
            }
            return ap.columnName;
        }).collect(Collectors.toList());
    }

    public Where<T> where(String clause, Object ... args) {
        return new Where(this.criteria, clause, args);
    }

    public OrderBy<T> orderBy(String orderBy) {
        return new OrderBy(this.criteria, orderBy);
    }

    public Limit<T> limit(int maxResults) {
        return this.limit(0, maxResults);
    }

    public Limit<T> limit(int offset, int maxResults) {
        return new Limit(this.criteria, offset, maxResults);
    }

    public List<T> list() {
        return this.criteria.list();
    }

    public PagedResults<T> list(int pageIndex) {
        return this.criteria.list(pageIndex, 20);
    }

    public PagedResults<T> list(int pageIndex, int itemsPerPage) {
        return this.criteria.list(pageIndex, itemsPerPage);
    }

    public int count() {
        return this.criteria.count();
    }

    public T first() {
        return this.criteria.first();
    }

    public T unique() {
        return this.criteria.unique();
    }
}

