/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.warpdb;

import com.itranswarp.warpdb.AccessibleProperty;
import com.itranswarp.warpdb.BeanRowMapper;
import com.itranswarp.warpdb.ConfigurationException;
import com.itranswarp.warpdb.Listener;
import com.itranswarp.warpdb.util.NameUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostRemove;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class Mapper<T> {
    final Class<T> entityClass;
    final String tableName;
    final AccessibleProperty[] ids;
    final AccessibleProperty version;
    final List<AccessibleProperty> allProperties;
    final Map<String, AccessibleProperty> allPropertiesMap;
    final List<AccessibleProperty> insertableProperties;
    final List<AccessibleProperty> updatableProperties;
    final Map<String, AccessibleProperty> updatablePropertiesMap;
    final BeanRowMapper<T> rowMapper;
    final String selectSQL;
    final String insertSQL;
    final String insertIgnoreSQL;
    final String updateSQL;
    final String deleteSQL;
    final String whereIdsEquals;
    final Listener prePersist;
    final Listener preUpdate;
    final Listener preRemove;
    final Listener postLoad;
    final Listener postPersist;
    final Listener postUpdate;
    final Listener postRemove;
    static List<String> columnDefinitionSortBy = Arrays.asList("BIT", "BOOL", "TINYINT", "SMALLINT", "MEDIUMINT", "INT", "INTEGER", "BIGINT", "FLOAT", "REAL", "DOUBLE", "DECIMAL", "YEAR", "DATE", "TIME", "DATETIME", "TIMESTAMP", "VARCHAR", "CHAR", "BLOB", "TEXT", "MEDIUMTEXT");
    static final Listener EMPTY_LISTENER = new Listener(){

        @Override
        public void invoke(Object obj) throws IllegalAccessException, InvocationTargetException {
        }
    };

    public Mapper(Class<T> clazz) {
        List<AccessibleProperty> all = this.getPropertiesIncludeHierarchy(clazz);
        HashSet<String> propertyNamesSet = new HashSet<String>();
        for (String propertyName : (String[])all.stream().map(p -> p.propertyName).toArray(String[]::new)) {
            if (propertyNamesSet.add(propertyName.toLowerCase())) continue;
            throw new ConfigurationException("Duplicate property name found: " + propertyName + " in class: " + clazz.getName());
        }
        HashSet<String> columnNamesSet = new HashSet<String>();
        for (String columnName : (String[])all.stream().map(p -> p.columnName).toArray(String[]::new)) {
            if (columnNamesSet.add(columnName.toLowerCase())) continue;
            throw new ConfigurationException("Duplicate column name found: " + columnName);
        }
        AccessibleProperty[] ids = (AccessibleProperty[])all.stream().filter(p -> p.isId()).sorted((p1, p2) -> p1.columnName.compareTo(p2.columnName)).toArray(AccessibleProperty[]::new);
        if (ids.length == 0) {
            throw new ConfigurationException("No @Id found.");
        }
        if (ids.length > 1 && all.stream().filter(p -> p.isId() && p.isIdentityId()).count() > 0L) {
            throw new ConfigurationException("Mutiple @Id cannot be identity.");
        }
        AccessibleProperty[] versions = (AccessibleProperty[])all.stream().filter(p -> p.isVersion()).toArray(AccessibleProperty[]::new);
        if (versions.length > 1) {
            throw new ConfigurationException("Multiple @Version found.");
        }
        this.version = versions.length == 0 ? null : versions[0];
        this.allProperties = all;
        this.allPropertiesMap = this.buildPropertiesMap(this.allProperties);
        this.insertableProperties = all.stream().filter(p -> {
            if (p.isIdentityId()) {
                return false;
            }
            return p.isInsertable();
        }).collect(Collectors.toList());
        this.updatableProperties = all.stream().filter(p -> p.isUpdatable()).collect(Collectors.toList());
        this.updatablePropertiesMap = this.buildPropertiesMap(this.updatableProperties);
        this.ids = ids;
        this.entityClass = clazz;
        this.tableName = this.getTableName(clazz);
        this.whereIdsEquals = String.join((CharSequence)" AND ", (CharSequence[])Arrays.stream(this.ids).map(id -> id.columnName + " = ?").toArray(String[]::new));
        this.selectSQL = "SELECT * FROM " + this.tableName + " WHERE " + this.whereIdsEquals;
        String insertPostfix = this.tableName + " (" + String.join((CharSequence)", ", (CharSequence[])this.insertableProperties.stream().map(p -> p.columnName).toArray(String[]::new)) + ") VALUES (" + this.numOfQuestions(this.insertableProperties.size()) + ")";
        this.insertSQL = "INSERT INTO " + insertPostfix;
        this.insertIgnoreSQL = "INSERT IGNORE INTO " + insertPostfix;
        this.updateSQL = "UPDATE " + this.tableName + " SET " + String.join((CharSequence)", ", (CharSequence[])this.updatableProperties.stream().map(p -> p.columnName + " = ?").toArray(String[]::new)) + " WHERE " + this.whereIdsEquals;
        this.deleteSQL = "DELETE FROM " + this.tableName + " WHERE " + this.whereIdsEquals;
        this.rowMapper = new BeanRowMapper<T>(this.entityClass, this.allProperties);
        List<Method> methods = this.findMethods(clazz);
        this.prePersist = this.findListener(methods, PrePersist.class);
        this.preUpdate = this.findListener(methods, PreUpdate.class);
        this.preRemove = this.findListener(methods, PreRemove.class);
        this.postLoad = this.findListener(methods, PostLoad.class);
        this.postPersist = this.findListener(methods, PostPersist.class);
        this.postUpdate = this.findListener(methods, PostUpdate.class);
        this.postRemove = this.findListener(methods, PostRemove.class);
    }

    static int columnDefinitionSortIndex(String definition) {
        int index;
        int pos = definition.indexOf(40);
        if (pos > 0) {
            definition = definition.substring(0, pos);
        }
        return (index = columnDefinitionSortBy.indexOf(definition.toUpperCase())) == -1 ? Integer.MAX_VALUE : index;
    }

    public String ddl() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("CREATE TABLE ").append(this.tableName).append(" (\n");
        sb.append(String.join((CharSequence)",\n", (CharSequence[])this.allProperties.stream().sorted(new Comparator<AccessibleProperty>(){

            @Override
            public int compare(AccessibleProperty o1, AccessibleProperty o2) {
                int index2;
                if (o1.isId()) {
                    return -1;
                }
                if (o2.isId()) {
                    return 1;
                }
                int index1 = Mapper.columnDefinitionSortIndex(o1.columnDefinition);
                if (index1 != (index2 = Mapper.columnDefinitionSortIndex(o2.columnDefinition))) {
                    return Integer.compare(index1, index2);
                }
                if ((o1.columnDefinition.startsWith("VARCHAR") || o1.columnDefinition.startsWith("CHAR")) && o1.columnDefinition.length() != o2.columnDefinition.length()) {
                    return Integer.compare(o1.columnDefinition.length(), o2.columnDefinition.length());
                }
                return o1.columnName.compareTo(o2.columnName);
            }
        }).map(p -> "  " + p.columnName + " " + p.columnDefinition + (p.isIdentityId() ? " AUTO_INCREMENT" : "") + (p.nullable ? " NULL" : " NOT NULL") + (!p.isId() && p.unique ? " UNIQUE" : "")).toArray(String[]::new)));
        sb.append(",\n");
        sb.append(this.getUniqueKey());
        sb.append(this.getIndex());
        sb.append("  PRIMARY KEY(").append(String.join((CharSequence)", ", (CharSequence[])Arrays.stream(this.ids).map(id -> id.columnName).toArray(String[]::new))).append(")\n");
        sb.append(");\n");
        return sb.toString();
    }

    String getUniqueKey() {
        Table table = this.entityClass.getAnnotation(Table.class);
        if (table != null) {
            return Arrays.stream(table.uniqueConstraints()).map(c -> {
                String name = c.name().isEmpty() ? "UNI_" + String.join((CharSequence)"_", c.columnNames()) : c.name();
                return "  CONSTRAINT " + name + " UNIQUE (" + String.join((CharSequence)", ", c.columnNames()) + "),\n";
            }).reduce("", (acc, s) -> acc + s);
        }
        return "";
    }

    String getIndex() {
        Table table = this.entityClass.getAnnotation(Table.class);
        if (table != null) {
            return Arrays.stream(table.indexes()).map(c -> {
                if (c.unique()) {
                    String name = c.name().isEmpty() ? "UNI_" + c.columnList().replace(" ", "").replace(",", "_") : c.name();
                    return "  CONSTRAINT " + name + " UNIQUE (" + c.columnList() + "),\n";
                }
                String name = c.name().isEmpty() ? "IDX_" + c.columnList().replace(" ", "").replace(",", "_") : c.name();
                return "  INDEX " + name + " (" + c.columnList() + "),\n";
            }).reduce("", (acc, s) -> acc + s);
        }
        return "";
    }

    Object[] getIdsValue(Object bean) throws IllegalAccessException, InvocationTargetException {
        Object[] values = new Object[this.ids.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.ids[i].convertGetter.get(bean);
        }
        return values;
    }

    Map<String, AccessibleProperty> buildPropertiesMap(List<AccessibleProperty> props) {
        HashMap<String, AccessibleProperty> map = new HashMap<String, AccessibleProperty>();
        for (AccessibleProperty prop : props) {
            map.put(prop.propertyName.toLowerCase(), prop);
        }
        return map;
    }

    Listener findListener(List<Method> methods, Class<? extends Annotation> anno) {
        Method target = null;
        for (Method m : methods) {
            if (!m.isAnnotationPresent(anno)) continue;
            if (target == null) {
                target = m;
                continue;
            }
            throw new ConfigurationException("Found multiple @" + anno.getSimpleName());
        }
        if (target == null) {
            return EMPTY_LISTENER;
        }
        if (target.getParameterTypes().length > 0) {
            throw new ConfigurationException("Invalid listener method: " + target.getName() + ". Expect zero args.");
        }
        if (Modifier.isStatic(target.getModifiers())) {
            throw new ConfigurationException("Invalid listener method: " + target.getName() + ". Cannot be static.");
        }
        target.setAccessible(true);
        Method listener = target;
        return obj -> listener.invoke(obj, new Object[0]);
    }

    List<Method> findMethods(Class<T> clazz) {
        ArrayList<Method> list = new ArrayList<Method>(50);
        this.findMethodsIncludeHierarchy(clazz, list);
        return list;
    }

    void findMethodsIncludeHierarchy(Class<?> clazz, List<Method> methods) {
        Method[] ms;
        for (Method m : ms = clazz.getDeclaredMethods()) {
            methods.add(m);
        }
        if (clazz.getSuperclass() != Object.class) {
            this.findMethodsIncludeHierarchy(clazz.getSuperclass(), methods);
        }
    }

    String numOfQuestions(int n) {
        String[] qs = new String[n];
        return String.join((CharSequence)", ", (CharSequence[])Arrays.stream(qs).map(s -> "?").toArray(String[]::new));
    }

    String getTableName(Class<?> clazz) {
        Table table = clazz.getAnnotation(Table.class);
        if (table != null) {
            String schema = table.schema();
            String tableName = table.name();
            if (tableName.isEmpty()) {
                tableName = NameUtils.toCamelCaseName(clazz.getSimpleName());
            }
            return schema.isEmpty() ? tableName : schema + "." + tableName;
        }
        return NameUtils.toCamelCaseName(clazz.getSimpleName());
    }

    List<AccessibleProperty> getPropertiesIncludeHierarchy(Class<?> clazz) {
        ArrayList<AccessibleProperty> properties = new ArrayList<AccessibleProperty>();
        this.addFieldPropertiesIncludeHierarchy(clazz, properties);
        List foundMethods = Arrays.stream(clazz.getMethods()).filter(m -> {
            int mod = m.getModifiers();
            if (m.isAnnotationPresent(Transient.class)) {
                return false;
            }
            if (Modifier.isStatic(mod)) {
                return false;
            }
            if (m.getName().equals("getClass")) {
                return false;
            }
            if (m.getParameterTypes().length > 0) {
                return false;
            }
            if (m.getName().startsWith("get") && m.getName().length() >= 4) {
                return true;
            }
            return m.getName().startsWith("is") && m.getName().length() >= 3 && (m.getReturnType() == Boolean.TYPE || m.getReturnType() == Boolean.class);
        }).map(getter -> {
            Method setter;
            Class<?> type = getter.getReturnType();
            String name = getter.getName().startsWith("get") ? Character.toLowerCase(getter.getName().charAt(3)) + getter.getName().substring(4) : Character.toLowerCase(getter.getName().charAt(2)) + getter.getName().substring(3);
            String setterName = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
            try {
                setter = clazz.getMethod(setterName, type);
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            return new AccessibleProperty(name, (Method)getter, setter);
        }).collect(Collectors.toList());
        properties.addAll(foundMethods);
        return properties;
    }

    void addFieldPropertiesIncludeHierarchy(Class<?> clazz, List<AccessibleProperty> collector) {
        List foundFields = Arrays.stream(clazz.getDeclaredFields()).filter(f -> {
            int mod = f.getModifiers();
            if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) {
                return false;
            }
            if (Modifier.isPublic(mod) && f.isAnnotationPresent(Transient.class)) {
                return false;
            }
            if (Modifier.isPublic(mod) && Modifier.isTransient(mod)) {
                return false;
            }
            if (Modifier.isPublic(mod)) {
                return true;
            }
            return f.isAnnotationPresent(Column.class) || f.isAnnotationPresent(Id.class);
        }).map(f -> new AccessibleProperty((Field)f)).collect(Collectors.toList());
        collector.addAll(foundFields);
        if (clazz.getSuperclass() != Object.class) {
            this.addFieldPropertiesIncludeHierarchy(clazz.getSuperclass(), collector);
        }
    }
}

