/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.warpdb;

import com.itranswarp.warpdb.AccessibleProperty;
import com.itranswarp.warpdb.Criteria;
import com.itranswarp.warpdb.CriteriaQuery;
import com.itranswarp.warpdb.Limit;
import com.itranswarp.warpdb.PagedResults;
import java.util.ArrayList;
import java.util.List;

public final class OrderBy<T>
extends CriteriaQuery<T> {
    public OrderBy(Criteria<T> criteria, String orderBy) {
        super(criteria);
        this.orderBy(orderBy);
    }

    public OrderBy<T> orderBy(String orderBy) {
        if (this.criteria.orderBy == null) {
            this.criteria.orderBy = new ArrayList<String>();
        }
        orderBy = this.checkProperty(orderBy);
        this.criteria.orderBy.add(orderBy);
        return this;
    }

    String checkProperty(String orderBy) {
        String prop = null;
        String upper = orderBy.toUpperCase();
        if (upper.endsWith(" DESC")) {
            prop = orderBy.substring(0, orderBy.length() - 5).trim();
            return this.propertyToField(prop) + " DESC";
        }
        if (upper.endsWith(" ASC")) {
            prop = orderBy.substring(0, orderBy.length() - 4).trim();
            return this.propertyToField(prop) + " ASC";
        }
        prop = orderBy.trim();
        return this.propertyToField(prop);
    }

    String propertyToField(String prop) {
        AccessibleProperty ap = this.criteria.mapper.allPropertiesMap.get(prop.toLowerCase());
        if (ap == null) {
            throw new IllegalArgumentException("Invalid property when use order by: " + prop);
        }
        return ap.columnName;
    }

    public OrderBy<T> desc() {
        int last = this.criteria.orderBy.size() - 1;
        Object s = this.criteria.orderBy.get(last);
        if (!((String)s).toUpperCase().endsWith(" DESC")) {
            s = (String)s + " DESC";
        }
        this.criteria.orderBy.set(last, (String)s);
        return this;
    }

    public Limit<T> limit(int maxResults) {
        return this.limit(0, maxResults);
    }

    public Limit<T> limit(int offset, int maxResults) {
        return new Limit(this.criteria, offset, maxResults);
    }

    public List<T> list() {
        return this.criteria.list();
    }

    public PagedResults<T> list(int pageIndex) {
        return this.criteria.list(pageIndex, 20);
    }

    public PagedResults<T> list(int pageIndex, int itemsPerPage) {
        return this.criteria.list(pageIndex, itemsPerPage);
    }

    public T first() {
        return this.criteria.first();
    }
}

