/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.warpdb;

import com.itranswarp.warpdb.AccessibleProperty;
import com.itranswarp.warpdb.ConfigurationException;
import com.itranswarp.warpdb.Criteria;
import com.itranswarp.warpdb.From;
import com.itranswarp.warpdb.Mapper;
import com.itranswarp.warpdb.Select;
import com.itranswarp.warpdb.util.ClassUtils;
import jakarta.annotation.PostConstruct;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.PersistenceException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

public class WarpDb {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    JdbcTemplate jdbcTemplate;
    List<String> basePackages;
    Map<Class<?>, Mapper<?>> classMapping;
    Map<String, Mapper<?>> tableMapping;
    static final RowMapper<Number> NUMBER_ROW_MAPPER = new RowMapper<Number>(){

        public Number mapRow(ResultSet rs, int rowNum) throws SQLException {
            return (Number)rs.getObject(1);
        }
    };
    static final ResultSetExtractor<Number> NUMBER_RESULT_SET = new ResultSetExtractor<Number>(){

        public Number extractData(ResultSet rs) throws SQLException, DataAccessException {
            if (rs.next()) {
                return (Number)rs.getObject(1);
            }
            return null;
        }
    };

    public void setDataSource(DataSource dataSource) {
        this.jdbcTemplate = new JdbcTemplate(dataSource, false);
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setBasePackages(List<String> basePackages) {
        this.basePackages = basePackages;
    }

    @PostConstruct
    public void init() {
        List<Class<?>> classes = ClassUtils.scanEntities(this.basePackages.toArray(new String[this.basePackages.size()]));
        HashMap classMapping = new HashMap();
        HashMap tableMapping = new HashMap();
        for (Class<?> clazz : classes) {
            this.logger.info("Found class: {}", (Object)clazz.getName());
            Mapper mapper = new Mapper(clazz);
            classMapping.put(clazz, mapper);
            if (null == tableMapping.put(mapper.tableName.toLowerCase(), mapper)) continue;
            throw new ConfigurationException("Duplicate table name: " + mapper.tableName + " defined in class: " + clazz.getName());
        }
        this.classMapping = classMapping;
        this.tableMapping = tableMapping;
    }

    public String getDDL(Class<?> clazz) {
        Mapper<?> mapper = this.classMapping.get(clazz);
        if (mapper == null) {
            throw new PersistenceException("Cannot find entity class: " + clazz.getName());
        }
        return mapper.ddl();
    }

    public String getDDL() {
        return String.join((CharSequence)"\n\n", (CharSequence[])this.classMapping.values().stream().map(mapper -> mapper.ddl()).sorted().toArray(String[]::new));
    }

    public <T> T get(Class<T> clazz, Serializable id) {
        T t = this.fetch(clazz, (Object)id);
        if (t == null) {
            throw new EntityNotFoundException(clazz.getSimpleName());
        }
        return t;
    }

    public <T> T get(Class<T> clazz, Object ... ids) {
        T t = this.fetch(clazz, ids);
        if (t == null) {
            throw new EntityNotFoundException(clazz.getSimpleName());
        }
        return t;
    }

    public <T> T fetch(Class<T> clazz, Object id) {
        List list;
        Mapper<T> mapper = this.getMapper(clazz);
        if (mapper.ids.length != 1) {
            throw new IllegalArgumentException(mapper.ids.length + " id values are expected but actual 1.");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL: {}", (Object)mapper.selectSQL);
        }
        if ((list = this.jdbcTemplate.query(mapper.selectSQL, mapper.rowMapper, new Object[]{id})).isEmpty()) {
            return null;
        }
        Object t = list.get(0);
        try {
            mapper.postLoad.invoke(t);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PersistenceException((Throwable)e);
        }
        return (T)t;
    }

    public <T> T fetch(Class<T> clazz, Object ... ids) {
        List list;
        Mapper<T> mapper = this.getMapper(clazz);
        if (mapper.ids.length != ids.length) {
            throw new IllegalArgumentException(mapper.ids.length + " id values are expected but actual " + ids.length + ".");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL: {}", (Object)mapper.selectSQL);
        }
        if ((list = this.jdbcTemplate.query(mapper.selectSQL, mapper.rowMapper, ids)).isEmpty()) {
            return null;
        }
        Object t = list.get(0);
        try {
            mapper.postLoad.invoke(t);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PersistenceException((Throwable)e);
        }
        return (T)t;
    }

    public <T> void remove(T bean) {
        try {
            Mapper<?> mapper = this.getMapper(bean.getClass());
            mapper.preRemove.invoke(bean);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL: {}", (Object)mapper.deleteSQL);
            }
            this.jdbcTemplate.update(mapper.deleteSQL, mapper.getIdsValue(bean));
            mapper.postRemove.invoke(bean);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public <T> void remove(List<T> beans) {
        if (beans.isEmpty()) {
            return;
        }
        try {
            for (T bean : beans) {
                Mapper<?> mapper = this.getMapper(bean.getClass());
                mapper.preRemove.invoke(bean);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("SQL: {}", (Object)mapper.deleteSQL);
                }
                this.jdbcTemplate.update(mapper.deleteSQL, mapper.getIdsValue(bean));
                mapper.postRemove.invoke(bean);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public Select select(String ... selectFields) {
        return new Select(new Criteria(this), selectFields);
    }

    public Select selectForUpdate(String ... selectFields) {
        Criteria c = new Criteria(this);
        c.forUpdate = true;
        return new Select(c, selectFields);
    }

    public <T> From<T> from(Class<T> entityClass) {
        Mapper<T> mapper = this.getMapper(entityClass);
        return new From(new Criteria(this), mapper);
    }

    public <T> void update(T bean) {
        try {
            Mapper<?> mapper = this.getMapper(bean.getClass());
            mapper.preUpdate.invoke(bean);
            Object[] args = new Object[mapper.updatableProperties.size() + mapper.ids.length];
            int n = 0;
            for (AccessibleProperty prop : mapper.updatableProperties) {
                args[n] = prop.convertGetter.get(bean);
                ++n;
            }
            for (int i = 0; i < mapper.ids.length; ++i) {
                args[n] = mapper.ids[i].convertGetter.get(bean);
                ++n;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL: {}", (Object)mapper.updateSQL);
            }
            this.jdbcTemplate.update(mapper.updateSQL, args);
            mapper.postUpdate.invoke(bean);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public <T> void update(final List<T> beans) {
        if (beans.isEmpty()) {
            return;
        }
        final Mapper<?> mapper = this.getMapper(beans.iterator().next().getClass());
        this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                Iterator iterator;
                block12: {
                    PreparedStatement ps = con.prepareStatement(mapper.updateSQL);
                    try {
                        for (Object bean : beans) {
                            mapper.preUpdate.invoke(bean);
                            int n = 0;
                            for (AccessibleProperty prop : mapper.updatableProperties) {
                                Object arg = prop.convertGetter.get(bean);
                                ps.setObject(++n, arg);
                            }
                            for (int i = 0; i < mapper.ids.length; ++i) {
                                ps.setObject(++n, mapper.ids[i].convertGetter.get(bean));
                            }
                            ps.addBatch();
                        }
                        ps.executeBatch();
                        for (Object bean : beans) {
                            mapper.postUpdate.invoke(bean);
                        }
                        iterator = null;
                        if (ps == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ps != null) {
                                try {
                                    ps.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    ps.close();
                }
                return iterator;
            }
        });
    }

    public <T> void updateProperties(T bean, String ... properties) {
        if (properties.length == 0) {
            throw new IllegalArgumentException("No properties provided.");
        }
        Mapper<?> mapper = this.getMapper(bean.getClass());
        try {
            mapper.preUpdate.invoke(bean);
            Object[] args = new Object[properties.length + mapper.ids.length];
            StringBuilder sb = new StringBuilder(150);
            sb.append("UPDATE ").append(mapper.tableName).append(" SET ");
            int n = 0;
            for (String prop : properties) {
                AccessibleProperty ap = mapper.updatablePropertiesMap.get(prop.toLowerCase());
                if (ap == null) {
                    throw new IllegalArgumentException("Property " + prop + " not exist or un-updatable.");
                }
                sb.append(ap.columnName).append(" = ?, ");
                args[n] = ap.convertGetter.get(bean);
                ++n;
            }
            for (int i = 0; i < mapper.ids.length; ++i) {
                args[n] = mapper.ids[i].convertGetter.get(bean);
                ++n;
            }
            sb.delete(sb.length() - 2, sb.length());
            sb.append(" WHERE ").append(mapper.whereIdsEquals);
            String sql = sb.toString();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL: {}", (Object)sql);
            }
            this.jdbcTemplate.update(sql, args);
            mapper.postUpdate.invoke(bean);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    @Deprecated
    public <T> void save(List<T> beans) {
        this.insert((T)beans);
    }

    public <T> void insert(List<T> beans) {
        if (beans.isEmpty()) {
            return;
        }
        this.doInsert(this.getMapper(beans.iterator().next().getClass()), false, beans);
    }

    public <T> void insertIgnore(List<T> beans) {
        if (beans.isEmpty()) {
            return;
        }
        this.doInsert(this.getMapper(beans.iterator().next().getClass()), true, beans);
    }

    private <T> void doInsert(final Mapper<?> mapper, boolean ignore, final List<T> beans) {
        String sql;
        String string = sql = ignore ? mapper.insertIgnoreSQL : mapper.insertSQL;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL: {}", (Object)sql);
        }
        try {
            this.jdbcTemplate.execute((ConnectionCallback)new ConnectionCallback<Object>(){

                public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                    Object var4_6;
                    block20: {
                        PreparedStatement ps = mapper.ids[0].isIdentityId() ? con.prepareStatement(sql, 1) : con.prepareStatement(sql);
                        try {
                            int n;
                            for (Object bean : beans) {
                                mapper.prePersist.invoke(bean);
                                n = 0;
                                for (AccessibleProperty prop : mapper.insertableProperties) {
                                    Object arg = prop.convertGetter.get(bean);
                                    ps.setObject(++n, arg);
                                }
                                ps.addBatch();
                            }
                            int[] results = ps.executeBatch();
                            if (mapper.ids[0].isIdentityId()) {
                                try (ResultSet rs = ps.getGeneratedKeys();){
                                    n = 0;
                                    for (AccessibleProperty bean : beans) {
                                        int result = results[n];
                                        ++n;
                                        if (result != 1) continue;
                                        if (rs.next()) {
                                            mapper.ids[0].convertSetter.set(bean, rs.getObject(1));
                                            continue;
                                        }
                                        throw new RuntimeException("Not enough id returned.");
                                    }
                                }
                            }
                            var4_6 = null;
                            if (ps == null) break block20;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (ps != null) {
                                    try {
                                        ps.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        ps.close();
                    }
                    return var4_6;
                }
            });
            for (T bean : beans) {
                mapper.postPersist.invoke(bean);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    @Deprecated
    public <T> void save(T bean) {
        this.insert(bean);
    }

    public <T> void insert(T bean) {
        this.doInsert(false, bean);
    }

    public <T> boolean insertIgnore(T bean) {
        return this.doInsert(true, bean);
    }

    private <T> boolean doInsert(boolean ignore, T bean) {
        try {
            int rows;
            Mapper<?> mapper = this.getMapper(bean.getClass());
            final String sql = ignore ? mapper.insertIgnoreSQL : mapper.insertSQL;
            mapper.prePersist.invoke(bean);
            final Object[] args = new Object[mapper.insertableProperties.size()];
            int n = 0;
            for (AccessibleProperty prop : mapper.insertableProperties) {
                args[n] = prop.convertGetter.get(bean);
                ++n;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SQL: {}", (Object)sql);
            }
            if (mapper.ids[0].isIdentityId()) {
                GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
                rows = this.jdbcTemplate.update(new PreparedStatementCreator(){

                    public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                        PreparedStatement ps = connection.prepareStatement(sql, 1);
                        for (int i = 0; i < args.length; ++i) {
                            ps.setObject(i + 1, args[i]);
                        }
                        return ps;
                    }
                }, (KeyHolder)keyHolder);
                if (rows == 1) {
                    mapper.ids[0].convertSetter.set(bean, keyHolder.getKey());
                }
            } else {
                rows = this.jdbcTemplate.update(sql, args);
            }
            mapper.postPersist.invoke(bean);
            return rows == 1;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public int updateSql(String sql, Object ... args) {
        return this.jdbcTemplate.update(sql, args);
    }

    public <T> List<T> list(String sql, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL: {}", (Object)sql);
        }
        Mapper<T> mapper = this.getMapper(sql);
        List list = this.jdbcTemplate.query(sql, mapper.rowMapper, args);
        try {
            for (Object bean : list) {
                mapper.postLoad.invoke(bean);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PersistenceException((Throwable)e);
        }
        return list;
    }

    public <T> List<T> list(Class<T> clazz, String sql, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL: {}", (Object)sql);
        }
        Mapper<T> mapper = this.getMapper(clazz);
        List list = this.jdbcTemplate.query(sql, mapper.rowMapper, args);
        try {
            for (Object bean : list) {
                mapper.postLoad.invoke(bean);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PersistenceException((Throwable)e);
        }
        return list;
    }

    public <T> List<T> queryForList(RowMapper<T> rowMapper, String sql, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL: {}", (Object)sql);
        }
        return this.jdbcTemplate.query(sql, rowMapper, args);
    }

    public Optional<Number> queryForNumber(String sql, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL: {}", (Object)sql);
        }
        Number number = (Number)this.jdbcTemplate.query(sql, NUMBER_RESULT_SET, args);
        return Optional.ofNullable(number);
    }

    public OptionalLong queryForLong(String sql, Object ... args) {
        Number number;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL: {}", (Object)sql);
        }
        if ((number = (Number)this.jdbcTemplate.query(sql, NUMBER_RESULT_SET, args)) == null) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(number.longValue());
    }

    public OptionalInt queryForInt(String sql, Object ... args) {
        Number number;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SQL: {}", (Object)sql);
        }
        if ((number = (Number)this.jdbcTemplate.query(sql, NUMBER_RESULT_SET, args)) == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(number.intValue());
    }

    public <T> T unique(String sql, Object ... args) {
        List<T> list;
        if (((String)sql).toLowerCase().indexOf(" limit ") == -1) {
            sql = (String)sql + " limit 2";
        }
        if ((list = this.list((String)sql, args)).isEmpty()) {
            throw new NoResultException("Empty result from SQL: " + (String)sql);
        }
        if (list.size() > 1) {
            throw new NonUniqueResultException("Non unique result from SQL: " + (String)sql);
        }
        return list.get(0);
    }

    public <T> T fetch(String sql, Object ... args) {
        List<T> list;
        if (((String)sql).toLowerCase().indexOf(" limit ") == -1) {
            sql = (String)sql + " limit 2";
        }
        if ((list = this.list((String)sql, args)).isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            throw new NonUniqueResultException("Non unique result returned from SQL: " + (String)sql);
        }
        return list.get(0);
    }

    public List<Class<?>> getEntities() {
        return new ArrayList(this.classMapping.keySet());
    }

    public String getTable(Class<?> clazz) {
        Mapper<?> mapper = this.classMapping.get(clazz);
        if (mapper == null) {
            throw new RuntimeException("Target class is not a registered entity: " + clazz.getName());
        }
        return mapper.tableName;
    }

    public String[] getInsertableFields(Class<?> clazz) {
        Mapper<?> mapper = this.classMapping.get(clazz);
        if (mapper == null) {
            throw new RuntimeException("Target class is not a registered entity: " + clazz.getName());
        }
        return (String[])mapper.insertableProperties.stream().map(p -> p.columnName).toArray(String[]::new);
    }

    public <T> Object[] getInsertableValues(T bean) {
        Mapper<?> mapper = this.classMapping.get(bean.getClass());
        if (mapper == null) {
            throw new RuntimeException("Target class is not a registered entity: " + bean.getClass().getName());
        }
        Object[] args = new Object[mapper.insertableProperties.size()];
        int n = 0;
        try {
            for (AccessibleProperty prop : mapper.insertableProperties) {
                args[n] = prop.convertGetter.get(bean);
                ++n;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new PersistenceException((Throwable)e);
        }
        return args;
    }

    <T> Mapper<T> getMapper(Class<T> clazz) {
        Mapper<?> mapper = this.classMapping.get(clazz);
        if (mapper == null) {
            throw new RuntimeException("Target class is not a registered entity: " + clazz.getName());
        }
        return mapper;
    }

    public <T> RowMapper<T> getRowMapper(Class<T> clazz) {
        return this.getMapper(clazz).rowMapper;
    }

    <T> Mapper<T> getMapper(String sql) {
        String[] ss = sql.split("\\s+");
        for (int i = 0; i < ss.length; ++i) {
            Mapper<?> mapper;
            if (!ss[i].toLowerCase().equals("from") || i >= ss.length - 1) continue;
            String table = ss[i + 1];
            if (table.length() > 2 && table.startsWith("`") && table.endsWith("`")) {
                table = table.substring(1, table.length() - 1);
            }
            if ((mapper = this.tableMapping.get(table.toLowerCase())) == null) {
                throw new RuntimeException("Cannot find mapping for table: " + table);
            }
            return mapper;
        }
        throw new RuntimeException("Cannot parse entity name from SQL: " + sql);
    }
}

