/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.warpdb.converter;

import jakarta.persistence.AttributeConverter;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;

public class LocalDateConverter
implements AttributeConverter<LocalDate, Date> {
    static final ZoneId SYSTEM_ZONE_ID = ZoneId.systemDefault();

    public Date convertToDatabaseColumn(LocalDate attribute) {
        return new Date(attribute.atStartOfDay(SYSTEM_ZONE_ID).toEpochSecond() * 1000L);
    }

    public LocalDate convertToEntityAttribute(Date dbData) {
        return Instant.ofEpochMilli(dbData.getTime()).atZone(SYSTEM_ZONE_ID).toLocalDate();
    }
}

