/*
 * Decompiled with CFR 0.152.
 */
package com.itranswarp.warpdb.converter;

import jakarta.persistence.AttributeConverter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class LocalDateTimeConverter
implements AttributeConverter<LocalDateTime, Date> {
    static final ZoneId SYSTEM_ZONE_ID = ZoneId.systemDefault();

    public Date convertToDatabaseColumn(LocalDateTime attribute) {
        return new Date(attribute.atZone(SYSTEM_ZONE_ID).toEpochSecond() * 1000L);
    }

    public LocalDateTime convertToEntityAttribute(Date dbData) {
        return Instant.ofEpochMilli(dbData.getTime()).atZone(SYSTEM_ZONE_ID).toLocalDateTime();
    }
}

