/*
 * Decompiled with CFR 0.152.
 */
package com.itv.scalapact.shared.http;

import com.itv.scalapact.shared.HttpMethod;
import com.itv.scalapact.shared.SimpleRequest;
import com.itv.scalapact.shared.http.HeaderImplicitConversions$;
import com.itv.scalapact.shared.http.IntAndReason;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import org.http4s.AttributeMap$;
import org.http4s.EntityEncoder$;
import org.http4s.HttpVersion$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scalaz.;
import scalaz.concurrent.Task;
import scalaz.concurrent.Task$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public final class Http4sRequestResponseFactory$ {
    public static Http4sRequestResponseFactory$ MODULE$;
    private final Function1<String, ByteVector> stringToByteVector;

    static {
        new Http4sRequestResponseFactory$();
    }

    public Function1<String, ByteVector> stringToByteVector() {
        return this.stringToByteVector;
    }

    public <A extends Throwable, B> Task<B> toTask(.bslash.div<A, B> a) {
        return Task$.MODULE$.fromDisjunction(a);
    }

    public Task<Uri> buildUri(String baseUrl, String endpoint) {
        return this.toTask(Uri$.MODULE$.fromString(baseUrl + endpoint).leftMap((Function1 & Serializable & scala.Serializable)l -> new Exception(l.message())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Task<Status> intToStatus(IntAndReason status) {
        IntAndReason intAndReason = status;
        if (intAndReason != null) {
            int code = intAndReason.code();
            Option<String> option = intAndReason.reason();
            if (option instanceof Some) {
                Some some = (Some)option;
                String reason = (String)some.value();
                return this.toTask(Status$.MODULE$.fromIntAndReason(code, reason));
            }
        }
        if (intAndReason == null) throw new MatchError((Object)intAndReason);
        int code = intAndReason.code();
        Option<String> option = intAndReason.reason();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)intAndReason);
        return this.toTask(Status$.MODULE$.fromInt(code));
    }

    public Method httpMethodToMethod(HttpMethod httpMethod) {
        Method method;
        HttpMethod httpMethod2 = httpMethod;
        if (HttpMethod.GET$.MODULE$.equals(httpMethod2)) {
            method = (Method)Method$.MODULE$.GET();
        } else if (HttpMethod.POST$.MODULE$.equals(httpMethod2)) {
            method = (Method)Method$.MODULE$.POST();
        } else if (HttpMethod.PUT$.MODULE$.equals(httpMethod2)) {
            method = (Method)Method$.MODULE$.PUT();
        } else if (HttpMethod.DELETE$.MODULE$.equals(httpMethod2)) {
            method = (Method)Method$.MODULE$.DELETE();
        } else if (HttpMethod.OPTIONS$.MODULE$.equals(httpMethod2)) {
            method = (Method)Method$.MODULE$.OPTIONS();
        } else {
            throw new MatchError((Object)httpMethod2);
        }
        return method;
    }

    public Task<Request> buildRequest(SimpleRequest request) {
        return this.buildUri(request.baseUrl(), request.endPoint()).flatMap((Function1 & Serializable & scala.Serializable)uri -> {
            Request r = Request$.MODULE$.apply(MODULE$.httpMethodToMethod(request.method()), uri, HttpVersion$.MODULE$.HTTP$div1$u002E1(), HeaderImplicitConversions$.MODULE$.mapToHeaderList((Map<String, String>)request.headers()), package$.MODULE$.EmptyBody(), AttributeMap$.MODULE$.empty());
            return (Task)request.body().map((Function1 & Serializable & scala.Serializable)b -> r.withBody(b, EntityEncoder$.MODULE$.simple((Seq)Nil$.MODULE$, MODULE$.stringToByteVector()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Function0 & Serializable & scala.Serializable x$1 = (Function0 & Serializable & scala.Serializable)() -> r;
                ExecutorService x$2 = Task$.MODULE$.apply$default$2((Function0)x$1);
                return Task$.MODULE$.apply((Function0)x$1, x$2);
            });
        });
    }

    public Task<Response> buildResponse(IntAndReason status, Map<String, String> headers, Option<String> body) {
        return this.intToStatus(status).flatMap((Function1 & Serializable & scala.Serializable)code -> {
            Response response = new Response(code, HttpVersion$.MODULE$.HTTP$div1$u002E1(), HeaderImplicitConversions$.MODULE$.mapToHeaderList(headers), package$.MODULE$.EmptyBody(), AttributeMap$.MODULE$.empty());
            return (Task)body.map((Function1 & Serializable & scala.Serializable)b -> response.withBody(b, EntityEncoder$.MODULE$.simple((Seq)Nil$.MODULE$, MODULE$.stringToByteVector()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Function0 & Serializable & scala.Serializable x$3 = (Function0 & Serializable & scala.Serializable)() -> response;
                ExecutorService x$4 = Task$.MODULE$.apply$default$2((Function0)x$3);
                return Task$.MODULE$.apply((Function0)x$3, x$4);
            });
        });
    }

    private Http4sRequestResponseFactory$() {
        MODULE$ = this;
        this.stringToByteVector = (Function1 & Serializable & scala.Serializable)str -> ByteVector$.MODULE$.apply(str.getBytes(StandardCharsets.UTF_8));
    }
}

