/*
 * Decompiled with CFR 0.152.
 */
package com.itv.scalapact.model;

import com.itv.scalapact.ScalaPactContractWriter$;
import com.itv.scalapact.ScalaPactMock$;
import com.itv.scalapact.ScalaPactMockConfig;
import com.itv.scalapact.ScalaPactMockServer;
import com.itv.scalapact.model.ScalaPactDescriptionFinal;
import com.itv.scalapact.model.ScalaPactDescriptionFinal$;
import com.itv.scalapact.model.ScalaPactInteraction;
import com.itv.scalapact.model.ScalaPactInteractionFinal;
import com.itv.scalapact.model.ScalaPactOptions;
import com.itv.scalapact.shared.IPactStubber;
import com.itv.scalapact.shared.http.IScalaPactHttpClient;
import com.itv.scalapact.shared.http.IScalaPactHttpClientBuilder;
import com.itv.scalapact.shared.http.SslContextMap;
import com.itv.scalapact.shared.http.SslContextMap$;
import com.itv.scalapact.shared.json.IPactReader;
import com.itv.scalapact.shared.json.IPactWriter;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.List;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;

public class ScalaPactDescription {
    private final boolean strict;
    private final String consumer;
    private final String provider;
    private final Option<String> sslContextName;
    private final List<ScalaPactInteraction> interactions;

    public ScalaPactDescription(boolean strict, String consumer, String provider, Option<String> sslContextName, List<ScalaPactInteraction> interactions) {
        this.strict = strict;
        this.consumer = consumer;
        this.provider = provider;
        this.sslContextName = sslContextName;
        this.interactions = interactions;
    }

    public ScalaPactDescription addInteraction(ScalaPactInteraction interaction) {
        return new ScalaPactDescription(this.strict, this.consumer, this.provider, this.sslContextName, (List<ScalaPactInteraction>)this.interactions.$colon$colon((Object)interaction));
    }

    public ScalaPactDescription addSslContextForServer(String name) {
        return new ScalaPactDescription(this.strict, this.consumer, this.provider, (Option<String>)Some$.MODULE$.apply((Object)name), this.interactions);
    }

    public <A> A runConsumerTest(Function1<ScalaPactMockConfig, A> test, ScalaPactOptions options, SslContextMap sslContextMap, IPactReader pactReader, IPactWriter pactWriter, IScalaPactHttpClientBuilder httpClientBuilder, IPactStubber pactStubber) {
        IScalaPactHttpClient client = httpClientBuilder.build((Duration)new package.DurationInt(package$.MODULE$.DurationInt(2)).seconds(), this.sslContextName, 1);
        return ScalaPactMock$.MODULE$.runConsumerIntegrationTest(this.strict, this.finalise(options), test, sslContextMap, pactReader, pactWriter, client, pactStubber);
    }

    public ScalaPactMockServer startServer(IScalaPactHttpClientBuilder httpClientBuilder, ScalaPactOptions options, IPactReader pactReader, IPactWriter pactWriter, IPactStubber pactStubber) {
        IScalaPactHttpClient client = httpClientBuilder.build((Duration)new package.DurationInt(package$.MODULE$.DurationInt(2)).seconds(), this.sslContextName, 1);
        ScalaPactDescriptionFinal pactDescriptionFinal = this.finalise(options);
        ScalaPactMockServer server = ScalaPactMock$.MODULE$.startServer(this.strict, pactDescriptionFinal, client, pactReader, pactWriter, pactStubber, SslContextMap$.MODULE$.defaultEmptyContextMap());
        if (pactDescriptionFinal.options().writePactFiles()) {
            ScalaPactContractWriter$.MODULE$.writePactContracts(server.config().outputPath(), pactWriter).apply((Object)pactDescriptionFinal.withHeaderForSsl());
        }
        return server;
    }

    public void writePactsToFile(ScalaPactOptions options, IPactWriter pactWriter) {
        ScalaPactDescriptionFinal pactDescription = this.finalise(options);
        ScalaPactContractWriter$.MODULE$.writePactContracts(options.outputPath(), pactWriter).apply((Object)pactDescription.withHeaderForSsl());
    }

    private ScalaPactDescriptionFinal finalise(ScalaPactOptions options) {
        return ScalaPactDescriptionFinal$.MODULE$.apply(this.consumer, this.provider, this.sslContextName, (List<ScalaPactInteractionFinal>)this.interactions.map((Function1 & Serializable)i -> i.finalise()), options);
    }
}

