/*
 * Decompiled with CFR 0.152.
 */
package com.iveely.crawler.common;

public class WildcardMatcher {
    private static boolean ignoreCase = false;
    private static final int LOWERCASE = 10;
    private static final int UPPERCASE = 20;
    private static final int NOT_A_LETTER = 30;

    private WildcardMatcher() {
    }

    public static boolean match(String string, String wildcard) {
        return WildcardMatcher.match(string, wildcard, false);
    }

    public static boolean match(String string, String wildcard, boolean ignorecase) {
        int index;
        ignoreCase = ignorecase;
        if (wildcard.indexOf("*") < 0) {
            return WildcardMatcher.stringEquals(string, wildcard);
        }
        if (wildcard.equals("*")) {
            return true;
        }
        String sub = null;
        int pw = 0;
        int ps = 0;
        int wlen = wildcard.length();
        int slen = string.length();
        boolean first = true;
        while (pw < wlen) {
            index = wildcard.indexOf(42, pw);
            if (index < 0) {
                sub = wildcard.substring(pw);
                pw = wlen;
            } else {
                sub = wildcard.substring(pw, index);
                pw = index + 1;
            }
            index = WildcardMatcher.find(string, sub, ps);
            if (first) {
                first = false;
                if (index != 0) {
                    return false;
                }
                ps = sub.length();
                continue;
            }
            if (index < 0) {
                return false;
            }
            ps = index + sub.length();
        }
        return wildcard.charAt(wildcard.length() - 1) == '*' || (index = WildcardMatcher.find(string, sub, string.length() - sub.length())) >= 0;
    }

    private static boolean stringEquals(String a, String b) {
        int blen;
        int alen = a.length();
        if (alen != (blen = b.length())) {
            return false;
        }
        return WildcardMatcher.find(a, b, 0) == 0;
    }

    private static int find(String string, String pattern, int startpos) {
        if (pattern.equals("")) {
            return startpos;
        }
        int pp = 0;
        int ps = startpos;
        int strlen = string.length();
        int patternlen = pattern.length();
        int orgp = ps;
        while (ps < strlen) {
            boolean cmatch;
            char sc = string.charAt(ps);
            char pc = pattern.charAt(pp);
            if (ignoreCase) {
                cmatch = WildcardMatcher.charEqualsIgnoreCase(sc, pc) || pc == '?';
            } else {
                boolean bl = cmatch = sc == pc || pc == '?';
            }
            if (!cmatch) {
                pp = 0;
                ps = ++orgp;
                continue;
            }
            ++ps;
            if (++pp != patternlen) continue;
            return orgp;
        }
        return -1;
    }

    private static boolean charEqualsIgnoreCase(char a, char b) {
        if (a == b) {
            return true;
        }
        if (a > b) {
            char t = a;
            a = b;
            b = t;
        }
        int at = WildcardMatcher.getCharType(a);
        int bt = WildcardMatcher.getCharType(b);
        return at == 20 && bt == 10 && a + 97 - 65 == b;
    }

    private static int getCharType(char c) {
        if (c >= 'a' && c <= 'z') {
            return 10;
        }
        if (c >= 'A' && c <= 'Z') {
            return 20;
        }
        return 30;
    }
}

