/*
 * Decompiled with CFR 0.152.
 */
package com.iveely.crawler.master;

import com.iveely.crawler.config.Loader;
import com.iveely.crawler.config.Seed;
import com.iveely.crawler.master.MasterHandler;
import com.iveely.framework.net.AsynServer;
import com.iveely.framework.process.ThreadUtil;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Master
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Master.class);
    private final AsynServer server;
    private final MasterHandler handler;
    private final Integer port;
    private boolean isStarted;

    public Master(Integer port) {
        this.port = port;
        this.handler = new MasterHandler();
        this.server = new AsynServer(this.port.intValue(), (AsynServer.IHandler)this.handler);
        this.isStarted = false;
    }

    @Override
    public void run() {
        try {
            if (!this.server.open()) {
                logger.error("Cannot start master server.");
                return;
            }
        }
        catch (IOException ex) {
            logger.error("When start master,IOException happend.", (Throwable)ex);
            return;
        }
        this.isStarted = true;
        logger.info("Master server started,at port {}", (Object)this.port);
        while (true) {
            logger.info("Start to check configurations.");
            List<Seed> configs = Loader.fromLocal();
            if (configs.size() > 0) {
                this.handler.addTasks(configs);
            }
            ThreadUtil.sleep((Integer)12000);
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void close() {
        if (this.server != null) {
            this.server.close();
        }
    }
}

