/*
 * Decompiled with CFR 0.152.
 */
package com.iveely.crawler.master;

import com.iveely.crawler.common.ExecuteType;
import com.iveely.crawler.config.Seed;
import com.iveely.crawler.config.Task;
import com.iveely.crawler.worker.BloomFilter;
import com.iveely.framework.net.AsynServer;
import com.iveely.framework.net.Packet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterHandler
implements AsynServer.IHandler {
    private static Logger logger = LoggerFactory.getLogger(MasterHandler.class);
    private static Object mutex = new Object();
    private Map<String, Task> tasks = new HashMap<String, Task>();
    private BloomFilter<String> filter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTasks(List<Seed> configs) {
        Object object = mutex;
        synchronized (object) {
            for (Seed seed : configs) {
                if (this.tasks.containsKey(seed.getName())) {
                    this.tasks.get(seed.getName()).setSeed(seed);
                    continue;
                }
                this.tasks.put(seed.getName(), new Task(seed));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet process(Packet packet) {
        Object object = mutex;
        synchronized (object) {
            if (packet.getMimeType() == ExecuteType.HEARTBEAT.ordinal()) {
                Packet respPacket = new Packet();
                List<Task> seedList = this.getAvailableTask();
                int totalSize = seedList.size();
                int needCount = (Integer)packet.getData();
                if (totalSize > 0 && needCount > 0) {
                    ArrayList<Seed> configs = new ArrayList<Seed>();
                    int max = needCount > totalSize ? totalSize : needCount;
                    for (int i = 0; i < max; ++i) {
                        configs.add(seedList.get(i).getSeed());
                        this.tasks.get(seedList.get(i).getSeed().getName()).setStatus(Task.Status.RUNNING);
                    }
                    respPacket.setExecuteType(ExecuteType.TASK_LIST.ordinal());
                    respPacket.setData(configs);
                } else {
                    respPacket.setExecuteType(ExecuteType.EMPTY.ordinal());
                    respPacket.setData((Serializable)((Object)""));
                }
                return respPacket;
            }
            return Packet.getUnknownPacket();
        }
    }

    public List<Task> getAvailableTask() {
        ArrayList<Task> list = new ArrayList<Task>();
        for (Map.Entry<String, Task> entry : this.tasks.entrySet()) {
            Task task = entry.getValue();
            if (task.getStatus() == Task.Status.PENDING && System.currentTimeMillis() - task.getEndtime() > (long)(task.getSeed().getFrequency() * 1000 * 60)) {
                list.add(task);
                continue;
            }
            if (task.getStatus() != Task.Status.RUNNING || System.currentTimeMillis() - task.getEndtime() <= 21600000L) continue;
            list.add(task);
        }
        return list;
    }

    public void caught(String exception) {
        logger.warn(exception);
    }
}

