/*
 * Decompiled with CFR 0.152.
 */
package com.iveely.crawler.worker;

import com.iveely.crawler.config.Configurate;
import com.iveely.crawler.entity.Article;
import com.iveely.framework.index.StoreField;
import com.iveely.framework.index.StoredDocument;
import com.iveely.framework.text.JSONUtil;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexRequest {
    private static Logger logger = LoggerFactory.getLogger(IndexRequest.class);

    public static void post(Article article) {
        if (article == null || article.getTitle() == null || article.getContent() == null || article.getUrl() == null) {
            return;
        }
        try {
            ArrayList<StoreField> storeFields = new ArrayList<StoreField>();
            storeFields.add(new StoreField(StoreField.Type.TEXT, "title", (Object)article.getTitle()));
            storeFields.add(new StoreField(StoreField.Type.STRING, "url", (Object)article.getUrl()));
            storeFields.add(new StoreField(StoreField.Type.TEXT, "content", (Object)article.getContent()));
            storeFields.add(new StoreField(StoreField.Type.LONG, "timestamp", (Object)article.getCrawlTimestamp()));
            String text = JSONUtil.toString((Object)new StoredDocument(storeFields));
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpPost httpPost = new HttpPost(Configurate.get().getIndexUrl());
            httpPost.setHeader("Content-Type", "application/json;charset=UTF-8");
            httpPost.setEntity((HttpEntity)new StringEntity(text, "UTF-8"));
            httpclient.execute((HttpUriRequest)httpPost);
            httpclient.getConnectionManager().shutdown();
        }
        catch (Exception ex) {
            logger.warn("Post exception.", (Throwable)ex);
        }
    }
}

