/*
 * Decompiled with CFR 0.152.
 */
package com.iveely.crawler.worker;

import com.iveely.crawler.config.Loader;
import com.iveely.crawler.config.Seed;
import com.iveely.crawler.worker.WorkerHandler;
import com.iveely.framework.process.ThreadUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Worker.class);
    private final WorkerHandler handler = new WorkerHandler();
    private static Map<String, Seed> tasks;
    private static Object mutex;

    public Worker() {
        tasks = new HashMap<String, Seed>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(String name) {
        Object object = mutex;
        synchronized (object) {
            if (tasks.containsKey(name)) {
                tasks.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            List<Seed> configs = Loader.fromLocal();
            Object object = mutex;
            synchronized (object) {
                for (Seed seed : configs) {
                    if (tasks.containsKey(seed.getName())) continue;
                    tasks.put(seed.getName(), seed);
                    this.handler.push(seed);
                }
            }
            ThreadUtil.sleep((Integer)300);
        }
    }

    static {
        mutex = new Object();
    }
}

