/*
 * Decompiled with CFR 0.152.
 */
package com.izettle.metrics.dw;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.izettle.metrics.dw.SenderType;
import com.izettle.metrics.dw.tags.ClassBasedTransformer;
import com.izettle.metrics.dw.tags.Transformer;
import com.izettle.metrics.influxdb.InfluxDBKafkaSender;
import com.izettle.metrics.influxdb.InfluxDbHttpSender;
import com.izettle.metrics.influxdb.InfluxDbLoggerSender;
import com.izettle.metrics.influxdb.InfluxDbReporter;
import com.izettle.metrics.influxdb.InfluxDbSender;
import com.izettle.metrics.influxdb.InfluxDbTcpSender;
import com.izettle.metrics.influxdb.InfluxDbUdpSender;
import io.dropwizard.metrics.BaseReporterFactory;
import io.dropwizard.util.Duration;
import io.dropwizard.validation.ValidationMethod;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.activation.UnsupportedDataTypeException;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import org.hibernate.validator.constraints.Range;

@JsonTypeName(value="influxdb")
public class InfluxDbReporterFactory
extends BaseReporterFactory {
    @NotEmpty
    private String protocol = "http";
    @NotEmpty
    private String host = "localhost";
    @Range(min=0L, max=49151L)
    private int port = 8086;
    @NotNull
    private String prefix = "";
    @NotNull
    private Map<String, String> tags = new HashMap<String, String>();
    @NotEmpty
    private ImmutableMap<String, ImmutableSet<String>> fields = ImmutableMap.of((Object)"timers", (Object)ImmutableSet.of((Object)"p50", (Object)"p75", (Object)"p95", (Object)"p99", (Object)"p999", (Object)"m1_rate", (Object[])new String[0]), (Object)"meters", (Object)ImmutableSet.of((Object)"m1_rate"));
    @NotNull
    private String database = "";
    @NotNull
    private String auth = "";
    @Range(min=500L, max=30000L)
    private int connectTimeout = 1500;
    @Range(min=500L, max=30000L)
    private int readTimeout = 1500;
    @NotNull
    private Duration precision = Duration.minutes((long)1L);
    @NotNull
    private SenderType senderType = SenderType.HTTP;
    private boolean groupGauges = true;
    private ImmutableMap<String, String> measurementMappings = ImmutableMap.of();
    private ImmutableMap<String, String> defaultMeasurementMappings = ImmutableMap.builder().put((Object)"health", (Object)".*\\.health(\\..*)?$").put((Object)"auth", (Object)".*\\.auth\\..*").put((Object)"dao", (Object)".*\\.(jdbi|dao)\\..*").put((Object)"resources", (Object)".*\\.resources?\\..*").put((Object)"event_handlers", (Object)".*\\.messaging\\..*").put((Object)"datasources", (Object)"io\\.dropwizard\\.db\\.ManagedPooledDataSource.*").put((Object)"clients", (Object)"org\\.apache\\.http\\.client\\.HttpClient.*").put((Object)"client_connections", (Object)"org\\.apache\\.http\\.conn\\.HttpClientConnectionManager.*").put((Object)"connections", (Object)"org\\.eclipse\\.jetty\\.server\\.HttpConnectionFactory.*").put((Object)"thread_pools", (Object)"org\\.eclipse\\.jetty\\.util\\.thread\\.QueuedThreadPool.*").put((Object)"logs", (Object)"ch\\.qos\\.logback\\.core\\.Appender.*").put((Object)"http_server", (Object)"io\\.dropwizard\\.jetty\\.MutableServletContextHandler.*").put((Object)"raw_sql", (Object)"org\\.skife\\.jdbi\\.v2\\.DBI\\.raw-sql").put((Object)"jvm", (Object)"^jvm$").put((Object)"jvm_attribute", (Object)"jvm\\.attribute.*?").put((Object)"jvm_buffers", (Object)"jvm\\.buffers\\..*").put((Object)"jvm_classloader", (Object)"jvm\\.classloader.*").put((Object)"jvm_gc", (Object)"jvm\\.gc\\..*").put((Object)"jvm_memory", (Object)"jvm\\.memory\\..*").put((Object)"jvm_threads", (Object)"jvm\\.threads.*").build();
    private ImmutableSet<String> excludes = ImmutableSet.builder().add((Object)"ch.qos.logback.core.Appender.debug").add((Object)"ch.qos.logback.core.Appender.trace").add((Object)"io.dropwizard.jetty.MutableServletContextHandler.percent-4xx-15m").add((Object)"io.dropwizard.jetty.MutableServletContextHandler.percent-4xx-1m").add((Object)"io.dropwizard.jetty.MutableServletContextHandler.percent-4xx-5m").add((Object)"io.dropwizard.jetty.MutableServletContextHandler.percent-5xx-15m").add((Object)"io.dropwizard.jetty.MutableServletContextHandler.percent-5xx-1m").add((Object)"io.dropwizard.jetty.MutableServletContextHandler.percent-5xx-5m").add((Object)"jvm.attribute.name").add((Object)"jvm.attribute.vendor").add((Object)"jvm.memory.heap.usage").add((Object)"jvm.memory.non-heap.usage").add((Object)"jvm.memory.pools.Code-Cache.usage").add((Object)"jvm.memory.pools.Compressed-Class-Space.usage").add((Object)"jvm.memory.pools.Metaspace.usage").add((Object)"jvm.memory.pools.PS-Eden-Space.usage").add((Object)"jvm.memory.pools.PS-Old-Gen.usage").add((Object)"jvm.memory.pools.PS-Survivor-Space.usage").build();
    @NotNull
    private Transformer tagsTransformer = new ClassBasedTransformer();

    @JsonProperty
    public String getProtocol() {
        return this.protocol;
    }

    @JsonProperty
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public void setHost(String host) {
        this.host = host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public void setPort(int port) {
        this.port = port;
    }

    @JsonProperty
    public String getPrefix() {
        return this.prefix;
    }

    @JsonProperty
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @JsonProperty
    private Map<String, String> getTags() {
        return this.tags;
    }

    @JsonProperty
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    @JsonProperty
    public ImmutableMap<String, ImmutableSet<String>> getFields() {
        return this.fields;
    }

    @JsonProperty
    public void setFields(ImmutableMap<String, ImmutableSet<String>> fields) {
        this.fields = fields;
    }

    @JsonProperty
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty
    public void setDatabase(String database) {
        this.database = database;
    }

    @JsonProperty
    public String getAuth() {
        return this.auth;
    }

    @JsonProperty
    public void setAuth(String auth) {
        this.auth = auth;
    }

    @JsonProperty
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @JsonProperty
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @JsonProperty
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @JsonProperty
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @JsonProperty
    public boolean getGroupGauges() {
        return this.groupGauges;
    }

    @JsonProperty
    public void setGroupGauges(boolean groupGauges) {
        this.groupGauges = groupGauges;
    }

    @JsonProperty
    public Duration getPrecision() {
        return this.precision;
    }

    @JsonProperty
    public void setPrecision(Duration precision) {
        this.precision = precision;
    }

    @JsonProperty
    public Map<String, String> getMeasurementMappings() {
        return this.measurementMappings;
    }

    @JsonProperty
    public void setMeasurementMappings(ImmutableMap<String, String> measurementMappings) {
        this.measurementMappings = measurementMappings;
    }

    @JsonProperty
    public Map<String, String> getDefaultMeasurementMappings() {
        return this.defaultMeasurementMappings;
    }

    @JsonProperty
    public ImmutableSet<String> getExcludes() {
        return this.excludes;
    }

    @JsonProperty
    public void setExcludes(ImmutableSet<String> excludes) {
        this.excludes = excludes;
    }

    @JsonProperty
    public void setDefaultMeasurementMappings(ImmutableMap<String, String> defaultMeasurementMappings) {
        this.defaultMeasurementMappings = defaultMeasurementMappings;
    }

    @JsonProperty
    public void setSenderType(SenderType senderType) {
        this.senderType = senderType;
    }

    @JsonProperty
    public SenderType getSenderType() {
        return this.senderType;
    }

    @JsonProperty
    public void setTagsTransformer(Transformer tagsTransformer) {
        this.tagsTransformer = tagsTransformer;
    }

    @JsonProperty
    public Transformer getTagsTransformer() {
        return this.tagsTransformer;
    }

    public ScheduledReporter build(MetricRegistry registry) {
        try {
            InfluxDbReporter.Builder builder = this.builder(registry);
            switch (this.senderType) {
                case HTTP: {
                    return builder.build((InfluxDbSender)new InfluxDbHttpSender(this.protocol, this.host, this.port, this.database, this.auth, this.precision.getUnit(), this.connectTimeout, this.readTimeout, this.prefix));
                }
                case TCP: {
                    return builder.build((InfluxDbSender)new InfluxDbTcpSender(this.host, this.port, this.readTimeout, this.database, this.prefix));
                }
                case UDP: {
                    return builder.build((InfluxDbSender)new InfluxDbUdpSender(this.host, this.port, this.readTimeout, this.database, this.prefix));
                }
                case LOGGER: {
                    return builder.build((InfluxDbSender)new InfluxDbLoggerSender(this.database, TimeUnit.MILLISECONDS, this.prefix));
                }
                case KAFKA: {
                    return builder.build((InfluxDbSender)new InfluxDBKafkaSender(this.database, TimeUnit.MILLISECONDS, this.prefix));
                }
            }
            throw new UnsupportedDataTypeException("The Sender Type is not supported. ");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, String> buildMeasurementMappings() {
        HashMap<String, String> mappings = new HashMap<String, String>((Map<String, String>)this.defaultMeasurementMappings);
        for (Map.Entry entry : this.measurementMappings.entrySet()) {
            String mappingKey = (String)entry.getKey();
            String mappingValue = (String)entry.getValue();
            if (mappingValue.isEmpty()) {
                mappings.remove(mappingKey);
                continue;
            }
            mappings.put(mappingKey, mappingValue);
        }
        return mappings;
    }

    @ValidationMethod(message="measurementMappings must be regular expressions")
    public boolean isMeasurementMappingRegularExpressions() {
        for (Map.Entry<String, String> entry : this.buildMeasurementMappings().entrySet()) {
            try {
                Pattern.compile(entry.getValue());
            }
            catch (PatternSyntaxException e) {
                return false;
            }
        }
        return true;
    }

    @VisibleForTesting
    protected InfluxDbReporter.Builder builder(MetricRegistry registry) {
        return InfluxDbReporter.forRegistry((MetricRegistry)registry).convertDurationsTo(this.getDurationUnit()).convertRatesTo(this.getRateUnit()).includeMeterFields((Set)this.fields.get((Object)"meters")).includeTimerFields((Set)this.fields.get((Object)"timers")).filter(this.getFilter()).groupGauges(this.getGroupGauges()).withTags(this.getTags()).tagsTransformer((com.izettle.metrics.influxdb.tags.Transformer)this.tagsTransformer).measurementMappings(this.buildMeasurementMappings());
    }
}

