/*
 * Decompiled with CFR 0.152.
 */
package com.izettle.metrics.influxdb;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Counting;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.izettle.metrics.influxdb.InfluxDbSender;
import com.izettle.metrics.influxdb.data.InfluxDbPoint;
import com.izettle.metrics.influxdb.tags.NoopTransformer;
import com.izettle.metrics.influxdb.tags.Transformer;
import java.net.ConnectException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InfluxDbReporter
extends ScheduledReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfluxDbReporter.class);
    private final InfluxDbSender influxDb;
    private final boolean skipIdleMetrics;
    private final Map<String, Long> previousValues;
    private final boolean groupGauges;
    private final Set<String> includeTimerFields;
    private final Set<String> includeMeterFields;
    private final Map<String, Pattern> measurementMappings;
    private final Transformer tagsTransformer;

    private InfluxDbReporter(MetricRegistry registry, InfluxDbSender influxDb, Map<String, String> tags, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, boolean skipIdleMetrics, boolean groupGauges, Set<String> includeTimerFields, Set<String> includeMeterFields, Map<String, Pattern> measurementMappings, Transformer tagsTransformer) {
        super(registry, "influxDb-reporter", filter, rateUnit, durationUnit);
        influxDb.setTags(tags);
        this.influxDb = influxDb;
        this.skipIdleMetrics = skipIdleMetrics;
        this.groupGauges = groupGauges;
        this.includeTimerFields = includeTimerFields;
        this.includeMeterFields = includeMeterFields;
        this.previousValues = new TreeMap<String, Long>();
        this.measurementMappings = measurementMappings == null ? Collections.emptyMap() : measurementMappings;
        this.tagsTransformer = tagsTransformer == null ? new NoopTransformer() : tagsTransformer;
    }

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long now = System.currentTimeMillis();
        try {
            this.influxDb.flush();
            this.reportGauges(gauges, now);
            for (Map.Entry<String, Counter> entry : counters.entrySet()) {
                this.reportCounter(entry.getKey(), entry.getValue(), now);
            }
            for (Map.Entry<String, Counter> entry : histograms.entrySet()) {
                this.reportHistogram(entry.getKey(), (Histogram)entry.getValue(), now);
            }
            for (Map.Entry<String, Counter> entry : meters.entrySet()) {
                this.reportMeter(entry.getKey(), (Metered)entry.getValue(), now);
            }
            for (Map.Entry<String, Counter> entry : timers.entrySet()) {
                this.reportTimer(entry.getKey(), (Timer)entry.getValue(), now);
            }
            if (this.influxDb.hasSeriesData()) {
                this.influxDb.writeData();
            }
        }
        catch (ConnectException e) {
            LOGGER.warn("Unable to connect to InfluxDB. Discarding data.");
        }
        catch (Exception e) {
            LOGGER.warn("Unable to report to InfluxDB with error '{}'. Discarding data.", (Object)e.getMessage());
        }
    }

    private void reportGauges(SortedMap<String, Gauge> gauges, long now) {
        if (this.groupGauges) {
            Map<String, Map<String, Gauge>> groupedGauges = this.groupGauges(gauges);
            for (Map.Entry<String, Map<String, Gauge>> entry : groupedGauges.entrySet()) {
                this.reportGaugeGroup(entry.getKey(), entry.getValue(), now);
            }
        } else {
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                this.reportGauge(entry.getKey(), entry.getValue(), now);
            }
        }
    }

    private Map<String, Map<String, Gauge>> groupGauges(SortedMap<String, Gauge> gauges) {
        HashMap<String, Map<String, Gauge>> groupedGauges = new HashMap<String, Map<String, Gauge>>();
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            String fieldName;
            String metricName;
            int lastDotIndex = entry.getKey().lastIndexOf(".");
            if (lastDotIndex != -1) {
                metricName = entry.getKey().substring(0, lastDotIndex);
                fieldName = entry.getKey().substring(lastDotIndex + 1);
            } else {
                metricName = entry.getKey();
                fieldName = "value";
            }
            HashMap<String, Gauge> fields = (HashMap<String, Gauge>)groupedGauges.get(metricName);
            if (fields == null) {
                fields = new HashMap<String, Gauge>();
            }
            fields.put(fieldName, entry.getValue());
            groupedGauges.put(metricName, fields);
        }
        return groupedGauges;
    }

    private void reportGaugeGroup(String name, Map<String, Gauge> gaugeGroup, long now) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (Map.Entry<String, Gauge> entry : gaugeGroup.entrySet()) {
            Object gaugeValue = this.sanitizeGauge(entry.getValue().getValue());
            if (gaugeValue == null) continue;
            fields.put(entry.getKey(), gaugeValue);
        }
        if (!fields.isEmpty()) {
            this.influxDb.appendPoints(new InfluxDbPoint(this.getMeasurementName(name), this.getTags(name), now, fields));
        }
    }

    private Object sanitizeGauge(Object value) {
        Object finalValue = value instanceof Double && (Double.isInfinite((Double)value) || Double.isNaN((Double)value)) ? null : (value instanceof Float && (Float.isInfinite(((Float)value).floatValue()) || Float.isNaN(((Float)value).floatValue())) ? null : value);
        return finalValue;
    }

    private void reportTimer(String name, Timer timer, long now) {
        if (this.canSkipMetric(name, (Counting)timer)) {
            return;
        }
        Snapshot snapshot = timer.getSnapshot();
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("count", timer.getCount());
        fields.put("min", this.convertDuration(snapshot.getMin()));
        fields.put("max", this.convertDuration(snapshot.getMax()));
        fields.put("mean", this.convertDuration(snapshot.getMean()));
        fields.put("stddev", this.convertDuration(snapshot.getStdDev()));
        fields.put("p50", this.convertDuration(snapshot.getMedian()));
        fields.put("p75", this.convertDuration(snapshot.get75thPercentile()));
        fields.put("p95", this.convertDuration(snapshot.get95thPercentile()));
        fields.put("p98", this.convertDuration(snapshot.get98thPercentile()));
        fields.put("p99", this.convertDuration(snapshot.get99thPercentile()));
        fields.put("p999", this.convertDuration(snapshot.get999thPercentile()));
        fields.put("m1_rate", this.convertRate(timer.getOneMinuteRate()));
        fields.put("m5_rate", this.convertRate(timer.getFiveMinuteRate()));
        fields.put("m15_rate", this.convertRate(timer.getFifteenMinuteRate()));
        fields.put("mean_rate", this.convertRate(timer.getMeanRate()));
        if (this.includeTimerFields != null) {
            fields.keySet().retainAll(this.includeTimerFields);
        }
        this.influxDb.appendPoints(new InfluxDbPoint(this.getMeasurementName(name), this.getTags(name), now, fields));
    }

    private void reportHistogram(String name, Histogram histogram, long now) {
        if (this.canSkipMetric(name, (Counting)histogram)) {
            return;
        }
        Snapshot snapshot = histogram.getSnapshot();
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("count", histogram.getCount());
        fields.put("min", snapshot.getMin());
        fields.put("max", snapshot.getMax());
        fields.put("mean", snapshot.getMean());
        fields.put("stddev", snapshot.getStdDev());
        fields.put("p50", snapshot.getMedian());
        fields.put("p75", snapshot.get75thPercentile());
        fields.put("p95", snapshot.get95thPercentile());
        fields.put("p98", snapshot.get98thPercentile());
        fields.put("p99", snapshot.get99thPercentile());
        fields.put("p999", snapshot.get999thPercentile());
        this.influxDb.appendPoints(new InfluxDbPoint(this.getMeasurementName(name), this.getTags(name), now, fields));
    }

    private void reportCounter(String name, Counter counter, long now) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("count", counter.getCount());
        this.influxDb.appendPoints(new InfluxDbPoint(this.getMeasurementName(name), this.getTags(name), now, fields));
    }

    private void reportGauge(String name, Gauge<?> gauge, long now) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        Object sanitizeGauge = this.sanitizeGauge(gauge.getValue());
        if (sanitizeGauge != null) {
            fields.put("value", sanitizeGauge);
            this.influxDb.appendPoints(new InfluxDbPoint(this.getMeasurementName(name), this.getTags(name), now, fields));
        }
    }

    private void reportMeter(String name, Metered meter, long now) {
        if (this.canSkipMetric(name, (Counting)meter)) {
            return;
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("count", meter.getCount());
        fields.put("m1_rate", this.convertRate(meter.getOneMinuteRate()));
        fields.put("m5_rate", this.convertRate(meter.getFiveMinuteRate()));
        fields.put("m15_rate", this.convertRate(meter.getFifteenMinuteRate()));
        fields.put("mean_rate", this.convertRate(meter.getMeanRate()));
        if (this.includeMeterFields != null) {
            fields.keySet().retainAll(this.includeMeterFields);
        }
        this.influxDb.appendPoints(new InfluxDbPoint(this.getMeasurementName(name), this.getTags(name), now, fields));
    }

    private boolean canSkipMetric(String name, Counting counting) {
        boolean isIdle;
        boolean bl = isIdle = this.calculateDelta(name, counting.getCount()) == 0L;
        if (this.skipIdleMetrics && !isIdle) {
            this.previousValues.put(name, counting.getCount());
        }
        return this.skipIdleMetrics && isIdle;
    }

    private long calculateDelta(String name, long count) {
        Long previous = this.previousValues.get(name);
        if (previous == null) {
            return -1L;
        }
        if (count < previous) {
            LOGGER.warn("Saw a non-monotonically increasing value for metric '{}'", (Object)name);
            return 0L;
        }
        return count - previous;
    }

    private Map<String, String> getTags(String name) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.putAll(this.influxDb.getTags());
        tags.putAll(this.tagsTransformer.getTags(name));
        return tags;
    }

    private String getMeasurementName(String name) {
        for (Map.Entry<String, Pattern> entry : this.measurementMappings.entrySet()) {
            Pattern pattern = entry.getValue();
            if (!pattern.matcher(name).matches()) continue;
            return entry.getKey();
        }
        return name;
    }

    public static class Builder {
        private final MetricRegistry registry;
        private Map<String, String> tags;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private boolean skipIdleMetrics;
        private boolean groupGauges;
        private Set<String> includeTimerFields;
        private Set<String> includeMeterFields;
        private Map<String, Pattern> measurementMappings;
        private Transformer tagsTransformer;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.tags = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
        }

        public Builder withTags(Map<String, String> tags) {
            this.tags = Collections.unmodifiableMap(tags);
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder skipIdleMetrics(boolean skipIdleMetrics) {
            this.skipIdleMetrics = skipIdleMetrics;
            return this;
        }

        public Builder groupGauges(boolean groupGauges) {
            this.groupGauges = groupGauges;
            return this;
        }

        public Builder includeTimerFields(Set<String> fields) {
            this.includeTimerFields = fields;
            return this;
        }

        public Builder includeMeterFields(Set<String> fields) {
            this.includeMeterFields = fields;
            return this;
        }

        public Builder measurementMappings(Map<String, String> measurementMappings) {
            HashMap<String, Pattern> mappingsByPattern = new HashMap<String, Pattern>();
            for (Map.Entry<String, String> entry : measurementMappings.entrySet()) {
                try {
                    Pattern pattern = Pattern.compile(entry.getValue());
                    mappingsByPattern.put(entry.getKey(), pattern);
                }
                catch (PatternSyntaxException e) {
                    throw new RuntimeException("Could not compile regex: " + entry.getValue(), e);
                }
            }
            this.measurementMappings = mappingsByPattern;
            return this;
        }

        public Builder tagsTransformer(Transformer tagsTransformer) {
            this.tagsTransformer = tagsTransformer;
            return this;
        }

        public InfluxDbReporter build(InfluxDbSender influxDb) {
            return new InfluxDbReporter(this.registry, influxDb, this.tags, this.rateUnit, this.durationUnit, this.filter, this.skipIdleMetrics, this.groupGauges, this.includeTimerFields, this.includeMeterFields, this.measurementMappings, this.tagsTransformer);
        }
    }
}

