/*
 * Decompiled with CFR 0.152.
 */
package com.izettle.metrics.influxdb;

import com.izettle.metrics.influxdb.InfluxDbBaseSender;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;

public class InfluxDbUdpSender
extends InfluxDbBaseSender {
    private static final TimeUnit UDP_TIME_PRECISION = TimeUnit.NANOSECONDS;
    private final String hostname;
    private final int port;
    private final int socketTimeout;
    private DatagramSocket udpSocket;

    public InfluxDbUdpSender(String hostname, int port, int socketTimeout, String database, String measurementPrefix) {
        super(database, UDP_TIME_PRECISION, measurementPrefix);
        this.hostname = hostname;
        this.port = port;
        this.socketTimeout = socketTimeout;
    }

    @Override
    protected int writeData(byte[] line) throws Exception {
        this.createSocket();
        this.udpSocket.send(new DatagramPacket(line, line.length, InetAddress.getByName(this.hostname), this.port));
        return 0;
    }

    private void createSocket() throws IOException {
        if (this.udpSocket == null) {
            this.udpSocket = new DatagramSocket();
            this.udpSocket.setSoTimeout(this.socketTimeout);
        }
    }
}

