/*
 * Decompiled with CFR 0.152.
 */
package com.izettle.metrics.influxdb.tags;

import com.izettle.metrics.influxdb.tags.Transformer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassBasedTransformer
implements Transformer {
    private static final Pattern PACKAGE = Pattern.compile("(.*)\\.[A-Z].*");
    private static final Pattern CLASS_NAME = Pattern.compile(".*\\.([A-Z][^\\.]*).*");
    private static final Pattern METHOD = Pattern.compile(".*\\.[A-Z][^\\.]*\\.(.*)");

    @Override
    public Map<String, String> getTags(String metricsName) {
        Matcher methodMatcher;
        Matcher classMatcher;
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("metricName", metricsName);
        Matcher packageMatcher = PACKAGE.matcher(metricsName);
        if (packageMatcher.find()) {
            tags.put("package", packageMatcher.group(1));
        }
        if ((classMatcher = CLASS_NAME.matcher(metricsName)).find()) {
            tags.put("className", classMatcher.group(1));
        }
        if ((methodMatcher = METHOD.matcher(metricsName)).find()) {
            tags.put("method", methodMatcher.group(1));
        }
        return tags;
    }
}

