/*
 * Decompiled with CFR 0.152.
 */
package com.izettle.metrics.influxdb;

import com.izettle.metrics.influxdb.InfluxDbHttpSender;
import com.izettle.metrics.influxdb.data.InfluxDbWriteObject;
import com.izettle.metrics.influxdb.utils.InfluxDbWriteObjectSerializer;
import java.util.concurrent.TimeUnit;

public class GroupedInfluxDbHttpSender
extends InfluxDbHttpSender {
    private final String groupMeasurement;

    public GroupedInfluxDbHttpSender(String protocol, String hostname, int port, String database, String authString, TimeUnit timePrecision, int connectTimeout, int readTimeout, String measurementPrefix, String groupMeasurement) throws Exception {
        super(protocol, hostname, port, database, authString, timePrecision, connectTimeout, readTimeout, measurementPrefix);
        this.groupMeasurement = groupMeasurement;
    }

    @Override
    public int writeData() throws Exception {
        InfluxDbWriteObjectSerializer serializer = this.getSerializer();
        InfluxDbWriteObject writeObject = this.getWriteObject();
        String linestr = serializer.getGroupedLineProtocolString(writeObject, this.groupMeasurement);
        byte[] line = linestr.getBytes(UTF_8);
        return super.writeData(line);
    }
}

